/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableObjectIntMap;
import com.gs.collections.api.map.primitive.ObjectIntMap;

/**
 * A factory which creates instances of type {@link ImmutableObjectIntMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableObjectIntMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    <K> ImmutableObjectIntMap<K> of();

    <K> ImmutableObjectIntMap<K> with();

    /**
     * Same as {@link #with(Object, int)}.
     */
    <K> ImmutableObjectIntMap<K> of(K key, int value);

    <K> ImmutableObjectIntMap<K> with(K key, int value);

    /**
     * Same as {@link #withAll(ObjectIntMap)}.
     */
    <K> ImmutableObjectIntMap<K> ofAll(ObjectIntMap<? extends K>  map);

    <K> ImmutableObjectIntMap<K> withAll(ObjectIntMap<? extends K>  map);
}
