/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableIntList extends MutableIntCollection, IntList
{
    void addAtIndex(int index, int element);

    boolean addAllAtIndex(int index, int... source);

    boolean addAllAtIndex(int index, IntIterable source);

    int removeAtIndex(int index);

    int set(int index, int element);

    MutableIntList select(IntPredicate predicate);

    MutableIntList reject(IntPredicate predicate);

    MutableIntList with(int element);

    MutableIntList without(int element);

    MutableIntList withAll(IntIterable elements);

    MutableIntList withoutAll(IntIterable elements);

    <V> MutableList<V> collect(IntToObjectFunction<? extends V> function);

    MutableIntList reverseThis();

    MutableIntList toReversed();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableIntList sortThis();

    MutableIntList asUnmodifiable();

    MutableIntList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableIntList toImmutable();

    MutableIntList subList(int fromIndex, int toIndex);
}
