/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.function.primitive.FloatToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.FloatDoublePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatDoubleMap extends FloatDoubleMap
{
    void clear();

    void put(float key, double value);

    void putAll(FloatDoubleMap map);

    void removeKey(float key);

    void remove(float key);

    double removeKeyIfAbsent(float key, double value);

    double getIfAbsentPut(float key, double value);

    double getIfAbsentPut(float key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(float key, FloatToDoubleFunction function);

    <P> double getIfAbsentPutWith(float key, DoubleFunction<? super P> function, P parameter);

    double updateValue(float key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableFloatDoubleMap select(FloatDoublePredicate predicate);

    MutableFloatDoubleMap reject(FloatDoublePredicate predicate);

    MutableDoubleCollection select(DoublePredicate predicate);

    MutableDoubleCollection reject(DoublePredicate predicate);

    <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableFloatDoubleMap withKeyValue(float key, double value);

    MutableFloatDoubleMap withoutKey(float key);

    MutableFloatDoubleMap withoutAllKeys(FloatIterable keys);

    MutableFloatDoubleMap asUnmodifiable();

    MutableFloatDoubleMap asSynchronized();

    double addToValue(float key, double toBeAdded);
}
