/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.IntIntPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntIntMap extends IntIntMap
{
    void clear();

    void put(int key, int value);

    void putAll(IntIntMap map);

    void removeKey(int key);

    void remove(int key);

    int removeKeyIfAbsent(int key, int value);

    int getIfAbsentPut(int key, int value);

    int getIfAbsentPut(int key, IntFunction0 function);

    int getIfAbsentPutWithKey(int key, IntToIntFunction function);

    <P> int getIfAbsentPutWith(int key, IntFunction<? super P> function, P parameter);

    int updateValue(int key, int initialValueIfAbsent, IntToIntFunction function);

    MutableIntIntMap select(IntIntPredicate predicate);

    MutableIntIntMap reject(IntIntPredicate predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableIntIntMap withKeyValue(int key, int value);

    MutableIntIntMap withoutKey(int key);

    MutableIntIntMap withoutAllKeys(IntIterable keys);

    MutableIntIntMap asUnmodifiable();

    MutableIntIntMap asSynchronized();

    int addToValue(int key, int toBeAdded);
}
