/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.set.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableByteSet extends MutableByteCollection, ByteSet
{
    MutableByteSet select(BytePredicate predicate);

    MutableByteSet reject(BytePredicate predicate);

    <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteSet with(byte element);

    MutableByteSet without(byte element);

    MutableByteSet withAll(ByteIterable elements);

    MutableByteSet withoutAll(ByteIterable elements);

    MutableByteSet asUnmodifiable();

    MutableByteSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    ByteSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableByteSet toImmutable();
}
