/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Bundle;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class BundleableUtil {
    public static <T extends Bundleable> ImmutableList<Bundle> toBundleList(List<T> bundleableList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleableList.size(); ++i) {
            Bundleable bundleable = (Bundleable)bundleableList.get(i);
            builder.add((Object)bundleable.toBundle());
        }
        return builder.build();
    }

    public static <T extends Bundleable> ImmutableList<T> fromBundleList(Bundleable.Creator<T> creator, List<Bundle> bundleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleList.size(); ++i) {
            Bundle bundle = Assertions.checkNotNull(bundleList.get(i));
            T bundleable = creator.fromBundle(bundle);
            builder.add(bundleable);
        }
        return builder.build();
    }

    public static <T extends Bundleable> ArrayList<Bundle> toBundleArrayList(Collection<T> bundleables) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundleables.size());
        for (Bundleable element : bundleables) {
            arrayList.add(element.toBundle());
        }
        return arrayList;
    }

    public static <T extends Bundleable> SparseArray<T> fromBundleSparseArray(Bundleable.Creator<T> creator, SparseArray<Bundle> bundleSparseArray) {
        SparseArray result = new SparseArray(bundleSparseArray.size());
        for (int i = 0; i < bundleSparseArray.size(); ++i) {
            result.put(bundleSparseArray.keyAt(i), creator.fromBundle((Bundle)bundleSparseArray.valueAt(i)));
        }
        return result;
    }

    public static <T extends Bundleable> SparseArray<Bundle> toBundleSparseArray(SparseArray<T> bundleableSparseArray) {
        SparseArray sparseArray = new SparseArray(bundleableSparseArray.size());
        for (int i = 0; i < bundleableSparseArray.size(); ++i) {
            sparseArray.put(bundleableSparseArray.keyAt(i), (Object)((Bundleable)bundleableSparseArray.valueAt(i)).toBundle());
        }
        return sparseArray;
    }

    public static void ensureClassLoader(@Nullable Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(Util.castNonNull(BundleableUtil.class.getClassLoader()));
        }
    }

    private BundleableUtil() {
    }
}

