/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.graphics.Rect;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.DeviceInfo;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.Tracks;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.CueGroup;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Size;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public abstract class SimpleBasePlayer
extends BasePlayer {
    private static final long POSITION_DISCONTINUITY_THRESHOLD_MS = 1000L;
    private final ListenerSet<Player.Listener> listeners;
    private final Looper applicationLooper;
    private final HandlerWrapper applicationHandler;
    private final HashSet<ListenableFuture<?>> pendingOperations;
    private final Timeline.Period period;
    private @MonotonicNonNull State state;
    private boolean released;

    protected SimpleBasePlayer(Looper applicationLooper) {
        this(applicationLooper, Clock.DEFAULT);
    }

    protected SimpleBasePlayer(Looper applicationLooper, Clock clock) {
        this.applicationLooper = applicationLooper;
        this.applicationHandler = clock.createHandler(applicationLooper, null);
        this.pendingOperations = new HashSet();
        this.period = new Timeline.Period();
        ListenerSet<Player.Listener> listenerSet = new ListenerSet<Player.Listener>(applicationLooper, clock, (listener, flags) -> listener.onEvents(this, new Player.Events(flags)));
        this.listeners = listenerSet;
    }

    @Override
    public final void addListener(Player.Listener listener) {
        this.listeners.add(Assertions.checkNotNull(listener));
    }

    @Override
    public final void removeListener(Player.Listener listener) {
        this.verifyApplicationThreadAndInitState();
        this.listeners.remove(listener);
    }

    @Override
    public final Looper getApplicationLooper() {
        return this.applicationLooper;
    }

    @Override
    public final Player.Commands getAvailableCommands() {
        this.verifyApplicationThreadAndInitState();
        return this.state.availableCommands;
    }

    @Override
    public final void setPlayWhenReady(boolean playWhenReady) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(1)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetPlayWhenReady(playWhenReady), (Supplier<State>)((Supplier)() -> state.buildUpon().setPlayWhenReady(playWhenReady, 1).build()));
    }

    @Override
    public final boolean getPlayWhenReady() {
        this.verifyApplicationThreadAndInitState();
        return this.state.playWhenReady;
    }

    @Override
    public final void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.verifyApplicationThreadAndInitState();
        int startIndex = resetPosition ? -1 : this.state.currentMediaItemIndex;
        long startPositionMs = resetPosition ? -9223372036854775807L : this.state.contentPositionMsSupplier.get();
        this.setMediaItemsInternal(mediaItems, startIndex, startPositionMs);
    }

    @Override
    public final void setMediaItems(List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        this.verifyApplicationThreadAndInitState();
        if (startIndex == -1) {
            startIndex = this.state.currentMediaItemIndex;
            startPositionMs = this.state.contentPositionMsSupplier.get();
        }
        this.setMediaItemsInternal(mediaItems, startIndex, startPositionMs);
    }

    @RequiresNonNull(value={"state"})
    private void setMediaItemsInternal(List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        Assertions.checkArgument(startIndex == -1 || startIndex >= 0);
        State state = this.state;
        if (!(this.shouldHandleCommand(20) || mediaItems.size() == 1 && this.shouldHandleCommand(31))) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetMediaItems(mediaItems, startIndex, startPositionMs), (Supplier<State>)((Supplier)() -> {
            ArrayList<MediaItemData> placeholderPlaylist = new ArrayList<MediaItemData>();
            for (int i = 0; i < mediaItems.size(); ++i) {
                placeholderPlaylist.add(this.getPlaceholderMediaItemData((MediaItem)mediaItems.get(i)));
            }
            return SimpleBasePlayer.getStateWithNewPlaylistAndPosition(state, placeholderPlaylist, startIndex, startPositionMs);
        }));
    }

    @Override
    public final void addMediaItems(int index, List<MediaItem> mediaItems) {
        this.verifyApplicationThreadAndInitState();
        Assertions.checkArgument(index >= 0);
        State state = this.state;
        int playlistSize = state.playlist.size();
        if (!this.shouldHandleCommand(20) || mediaItems.isEmpty()) {
            return;
        }
        int correctedIndex = Math.min(index, playlistSize);
        this.updateStateForPendingOperation(this.handleAddMediaItems(correctedIndex, mediaItems), (Supplier<State>)((Supplier)() -> {
            ArrayList<MediaItemData> placeholderPlaylist = new ArrayList<MediaItemData>((Collection<MediaItemData>)state.playlist);
            for (int i = 0; i < mediaItems.size(); ++i) {
                placeholderPlaylist.add(i + correctedIndex, this.getPlaceholderMediaItemData((MediaItem)mediaItems.get(i)));
            }
            return SimpleBasePlayer.getStateWithNewPlaylist(state, placeholderPlaylist, this.period);
        }));
    }

    @Override
    public final void moveMediaItems(int fromIndex, int toIndex, int newIndex) {
        this.verifyApplicationThreadAndInitState();
        Assertions.checkArgument(fromIndex >= 0 && toIndex >= fromIndex && newIndex >= 0);
        State state = this.state;
        int playlistSize = state.playlist.size();
        if (!this.shouldHandleCommand(20) || playlistSize == 0 || fromIndex >= playlistSize) {
            return;
        }
        int correctedToIndex = Math.min(toIndex, playlistSize);
        int correctedNewIndex = Math.min(newIndex, state.playlist.size() - (correctedToIndex - fromIndex));
        if (fromIndex == correctedToIndex || correctedNewIndex == fromIndex) {
            return;
        }
        this.updateStateForPendingOperation(this.handleMoveMediaItems(fromIndex, correctedToIndex, correctedNewIndex), (Supplier<State>)((Supplier)() -> {
            ArrayList<MediaItemData> placeholderPlaylist = new ArrayList<MediaItemData>((Collection<MediaItemData>)state.playlist);
            Util.moveItems(placeholderPlaylist, fromIndex, correctedToIndex, correctedNewIndex);
            return SimpleBasePlayer.getStateWithNewPlaylist(state, placeholderPlaylist, this.period);
        }));
    }

    @Override
    public final void removeMediaItems(int fromIndex, int toIndex) {
        this.verifyApplicationThreadAndInitState();
        Assertions.checkArgument(fromIndex >= 0 && toIndex >= fromIndex);
        State state = this.state;
        int playlistSize = state.playlist.size();
        if (!this.shouldHandleCommand(20) || playlistSize == 0 || fromIndex >= playlistSize) {
            return;
        }
        int correctedToIndex = Math.min(toIndex, playlistSize);
        if (fromIndex == correctedToIndex) {
            return;
        }
        this.updateStateForPendingOperation(this.handleRemoveMediaItems(fromIndex, correctedToIndex), (Supplier<State>)((Supplier)() -> {
            ArrayList<MediaItemData> placeholderPlaylist = new ArrayList<MediaItemData>((Collection<MediaItemData>)state.playlist);
            Util.removeRange(placeholderPlaylist, fromIndex, correctedToIndex);
            return SimpleBasePlayer.getStateWithNewPlaylist(state, placeholderPlaylist, this.period);
        }));
    }

    @Override
    public final void prepare() {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(2)) {
            return;
        }
        this.updateStateForPendingOperation(this.handlePrepare(), (Supplier<State>)((Supplier)() -> state.buildUpon().setPlayerError(null).setPlaybackState(state.timeline.isEmpty() ? 4 : 2).build()));
    }

    @Override
    public final int getPlaybackState() {
        this.verifyApplicationThreadAndInitState();
        return this.state.playbackState;
    }

    @Override
    public final int getPlaybackSuppressionReason() {
        this.verifyApplicationThreadAndInitState();
        return this.state.playbackSuppressionReason;
    }

    @Override
    @Nullable
    public final PlaybackException getPlayerError() {
        this.verifyApplicationThreadAndInitState();
        return this.state.playerError;
    }

    @Override
    public final void setRepeatMode(int repeatMode) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(15)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetRepeatMode(repeatMode), (Supplier<State>)((Supplier)() -> state.buildUpon().setRepeatMode(repeatMode).build()));
    }

    @Override
    public final int getRepeatMode() {
        this.verifyApplicationThreadAndInitState();
        return this.state.repeatMode;
    }

    @Override
    public final void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(14)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetShuffleModeEnabled(shuffleModeEnabled), (Supplier<State>)((Supplier)() -> state.buildUpon().setShuffleModeEnabled(shuffleModeEnabled).build()));
    }

    @Override
    public final boolean getShuffleModeEnabled() {
        this.verifyApplicationThreadAndInitState();
        return this.state.shuffleModeEnabled;
    }

    @Override
    public final boolean isLoading() {
        this.verifyApplicationThreadAndInitState();
        return this.state.isLoading;
    }

    @Override
    @VisibleForTesting(otherwise=4)
    public final void seekTo(int mediaItemIndex, long positionMs, int seekCommand, boolean isRepeatingCurrentItem) {
        this.verifyApplicationThreadAndInitState();
        Assertions.checkArgument(mediaItemIndex >= 0);
        State state = this.state;
        if (!this.shouldHandleCommand(seekCommand) || this.isPlayingAd() || !state.playlist.isEmpty() && mediaItemIndex >= state.playlist.size()) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSeek(mediaItemIndex, positionMs, seekCommand), (Supplier<State>)((Supplier)() -> SimpleBasePlayer.getStateWithNewPlaylistAndPosition(state, state.playlist, mediaItemIndex, positionMs)), true, isRepeatingCurrentItem);
    }

    @Override
    public final long getSeekBackIncrement() {
        this.verifyApplicationThreadAndInitState();
        return this.state.seekBackIncrementMs;
    }

    @Override
    public final long getSeekForwardIncrement() {
        this.verifyApplicationThreadAndInitState();
        return this.state.seekForwardIncrementMs;
    }

    @Override
    public final long getMaxSeekToPreviousPosition() {
        this.verifyApplicationThreadAndInitState();
        return this.state.maxSeekToPreviousPositionMs;
    }

    @Override
    public final void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(13)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetPlaybackParameters(playbackParameters), (Supplier<State>)((Supplier)() -> state.buildUpon().setPlaybackParameters(playbackParameters).build()));
    }

    @Override
    public final PlaybackParameters getPlaybackParameters() {
        this.verifyApplicationThreadAndInitState();
        return this.state.playbackParameters;
    }

    @Override
    public final void stop() {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(3)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleStop(), (Supplier<State>)((Supplier)() -> state.buildUpon().setPlaybackState(1).setTotalBufferedDurationMs(PositionSupplier.ZERO).setContentBufferedPositionMs(PositionSupplier.getConstant(SimpleBasePlayer.getContentPositionMsInternal(state))).setAdBufferedPositionMs(state.adPositionMsSupplier).setIsLoading(false).build()));
    }

    @Override
    public final void stop(boolean reset) {
        this.stop();
        if (reset) {
            this.clearMediaItems();
        }
    }

    @Override
    public final void release() {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (this.released) {
            return;
        }
        this.updateStateForPendingOperation(this.handleRelease(), (Supplier<State>)((Supplier)() -> state));
        this.released = true;
        this.listeners.release();
        this.state = this.state.buildUpon().setPlaybackState(1).setTotalBufferedDurationMs(PositionSupplier.ZERO).setContentBufferedPositionMs(PositionSupplier.getConstant(SimpleBasePlayer.getContentPositionMsInternal(state))).setAdBufferedPositionMs(state.adPositionMsSupplier).setIsLoading(false).build();
    }

    @Override
    public final Tracks getCurrentTracks() {
        this.verifyApplicationThreadAndInitState();
        return SimpleBasePlayer.getCurrentTracksInternal(this.state);
    }

    @Override
    public final TrackSelectionParameters getTrackSelectionParameters() {
        this.verifyApplicationThreadAndInitState();
        return this.state.trackSelectionParameters;
    }

    @Override
    public final void setTrackSelectionParameters(TrackSelectionParameters parameters) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(29)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetTrackSelectionParameters(parameters), (Supplier<State>)((Supplier)() -> state.buildUpon().setTrackSelectionParameters(parameters).build()));
    }

    @Override
    public final MediaMetadata getMediaMetadata() {
        this.verifyApplicationThreadAndInitState();
        return SimpleBasePlayer.getMediaMetadataInternal(this.state);
    }

    @Override
    public final MediaMetadata getPlaylistMetadata() {
        this.verifyApplicationThreadAndInitState();
        return this.state.playlistMetadata;
    }

    @Override
    public final void setPlaylistMetadata(MediaMetadata mediaMetadata) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(19)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetPlaylistMetadata(mediaMetadata), (Supplier<State>)((Supplier)() -> state.buildUpon().setPlaylistMetadata(mediaMetadata).build()));
    }

    @Override
    public final Timeline getCurrentTimeline() {
        this.verifyApplicationThreadAndInitState();
        return this.state.timeline;
    }

    @Override
    public final int getCurrentPeriodIndex() {
        this.verifyApplicationThreadAndInitState();
        return SimpleBasePlayer.getCurrentPeriodIndexInternal(this.state, this.window, this.period);
    }

    @Override
    public final int getCurrentMediaItemIndex() {
        this.verifyApplicationThreadAndInitState();
        return SimpleBasePlayer.getCurrentMediaItemIndexInternal(this.state);
    }

    @Override
    public final long getDuration() {
        this.verifyApplicationThreadAndInitState();
        if (this.isPlayingAd()) {
            this.state.timeline.getPeriod(this.getCurrentPeriodIndex(), this.period);
            long adDurationUs = this.period.getAdDurationUs(this.state.currentAdGroupIndex, this.state.currentAdIndexInAdGroup);
            return Util.usToMs(adDurationUs);
        }
        return this.getContentDuration();
    }

    @Override
    public final long getCurrentPosition() {
        this.verifyApplicationThreadAndInitState();
        return this.isPlayingAd() ? this.state.adPositionMsSupplier.get() : this.getContentPosition();
    }

    @Override
    public final long getBufferedPosition() {
        this.verifyApplicationThreadAndInitState();
        return this.isPlayingAd() ? Math.max(this.state.adBufferedPositionMsSupplier.get(), this.state.adPositionMsSupplier.get()) : this.getContentBufferedPosition();
    }

    @Override
    public final long getTotalBufferedDuration() {
        this.verifyApplicationThreadAndInitState();
        return this.state.totalBufferedDurationMsSupplier.get();
    }

    @Override
    public final boolean isPlayingAd() {
        this.verifyApplicationThreadAndInitState();
        return this.state.currentAdGroupIndex != -1;
    }

    @Override
    public final int getCurrentAdGroupIndex() {
        this.verifyApplicationThreadAndInitState();
        return this.state.currentAdGroupIndex;
    }

    @Override
    public final int getCurrentAdIndexInAdGroup() {
        this.verifyApplicationThreadAndInitState();
        return this.state.currentAdIndexInAdGroup;
    }

    @Override
    public final long getContentPosition() {
        this.verifyApplicationThreadAndInitState();
        return SimpleBasePlayer.getContentPositionMsInternal(this.state);
    }

    @Override
    public final long getContentBufferedPosition() {
        this.verifyApplicationThreadAndInitState();
        return Math.max(SimpleBasePlayer.getContentBufferedPositionMsInternal(this.state), SimpleBasePlayer.getContentPositionMsInternal(this.state));
    }

    @Override
    public final AudioAttributes getAudioAttributes() {
        this.verifyApplicationThreadAndInitState();
        return this.state.audioAttributes;
    }

    @Override
    public final void setVolume(float volume) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(24)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetVolume(volume), (Supplier<State>)((Supplier)() -> state.buildUpon().setVolume(volume).build()));
    }

    @Override
    public final float getVolume() {
        this.verifyApplicationThreadAndInitState();
        return this.state.volume;
    }

    @Override
    public final void setVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(27)) {
            return;
        }
        if (surface == null) {
            this.clearVideoSurface();
            return;
        }
        this.updateStateForPendingOperation(this.handleSetVideoOutput(surface), (Supplier<State>)((Supplier)() -> state.buildUpon().setSurfaceSize(Size.UNKNOWN).build()));
    }

    @Override
    public final void setVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(27)) {
            return;
        }
        if (surfaceHolder == null) {
            this.clearVideoSurface();
            return;
        }
        this.updateStateForPendingOperation(this.handleSetVideoOutput(surfaceHolder), (Supplier<State>)((Supplier)() -> state.buildUpon().setSurfaceSize(SimpleBasePlayer.getSurfaceHolderSize(surfaceHolder)).build()));
    }

    @Override
    public final void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(27)) {
            return;
        }
        if (surfaceView == null) {
            this.clearVideoSurface();
            return;
        }
        this.updateStateForPendingOperation(this.handleSetVideoOutput(surfaceView), (Supplier<State>)((Supplier)() -> state.buildUpon().setSurfaceSize(SimpleBasePlayer.getSurfaceHolderSize(surfaceView.getHolder())).build()));
    }

    @Override
    public final void setVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(27)) {
            return;
        }
        if (textureView == null) {
            this.clearVideoSurface();
            return;
        }
        Size surfaceSize = textureView.isAvailable() ? new Size(textureView.getWidth(), textureView.getHeight()) : Size.ZERO;
        this.updateStateForPendingOperation(this.handleSetVideoOutput(textureView), (Supplier<State>)((Supplier)() -> state.buildUpon().setSurfaceSize(surfaceSize).build()));
    }

    @Override
    public final void clearVideoSurface() {
        this.clearVideoOutput(null);
    }

    @Override
    public final void clearVideoSurface(@Nullable Surface surface) {
        this.clearVideoOutput(surface);
    }

    @Override
    public final void clearVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.clearVideoOutput(surfaceHolder);
    }

    @Override
    public final void clearVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.clearVideoOutput(surfaceView);
    }

    @Override
    public final void clearVideoTextureView(@Nullable TextureView textureView) {
        this.clearVideoOutput(textureView);
    }

    private void clearVideoOutput(@Nullable Object videoOutput) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(27)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleClearVideoOutput(videoOutput), (Supplier<State>)((Supplier)() -> state.buildUpon().setSurfaceSize(Size.ZERO).build()));
    }

    @Override
    public final VideoSize getVideoSize() {
        this.verifyApplicationThreadAndInitState();
        return this.state.videoSize;
    }

    @Override
    public final Size getSurfaceSize() {
        this.verifyApplicationThreadAndInitState();
        return this.state.surfaceSize;
    }

    @Override
    public final CueGroup getCurrentCues() {
        this.verifyApplicationThreadAndInitState();
        return this.state.currentCues;
    }

    @Override
    public final DeviceInfo getDeviceInfo() {
        this.verifyApplicationThreadAndInitState();
        return this.state.deviceInfo;
    }

    @Override
    public final int getDeviceVolume() {
        this.verifyApplicationThreadAndInitState();
        return this.state.deviceVolume;
    }

    @Override
    public final boolean isDeviceMuted() {
        this.verifyApplicationThreadAndInitState();
        return this.state.isDeviceMuted;
    }

    @Override
    public final void setDeviceVolume(int volume) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(25)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetDeviceVolume(volume), (Supplier<State>)((Supplier)() -> state.buildUpon().setDeviceVolume(volume).build()));
    }

    @Override
    public final void increaseDeviceVolume() {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(26)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleIncreaseDeviceVolume(), (Supplier<State>)((Supplier)() -> state.buildUpon().setDeviceVolume(state.deviceVolume + 1).build()));
    }

    @Override
    public final void decreaseDeviceVolume() {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(26)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleDecreaseDeviceVolume(), (Supplier<State>)((Supplier)() -> state.buildUpon().setDeviceVolume(Math.max(0, state.deviceVolume - 1)).build()));
    }

    @Override
    public final void setDeviceMuted(boolean muted) {
        this.verifyApplicationThreadAndInitState();
        State state = this.state;
        if (!this.shouldHandleCommand(26)) {
            return;
        }
        this.updateStateForPendingOperation(this.handleSetDeviceMuted(muted), (Supplier<State>)((Supplier)() -> state.buildUpon().setIsDeviceMuted(muted).build()));
    }

    protected final void invalidateState() {
        this.verifyApplicationThreadAndInitState();
        if (!this.pendingOperations.isEmpty() || this.released) {
            return;
        }
        this.updateStateAndInformListeners(this.getState(), false, false);
    }

    @ForOverride
    protected abstract State getState();

    @ForOverride
    protected State getPlaceholderState(State suggestedPlaceholderState) {
        return suggestedPlaceholderState;
    }

    @ForOverride
    protected MediaItemData getPlaceholderMediaItemData(MediaItem mediaItem) {
        return new MediaItemData.Builder(new PlaceholderUid()).setMediaItem(mediaItem).setIsDynamic(true).setIsPlaceholder(true).build();
    }

    @ForOverride
    protected ListenableFuture<?> handleSetPlayWhenReady(boolean playWhenReady) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_PLAY_PAUSE");
    }

    @ForOverride
    protected ListenableFuture<?> handlePrepare() {
        throw new IllegalStateException("Missing implementation to handle COMMAND_PREPARE");
    }

    @ForOverride
    protected ListenableFuture<?> handleStop() {
        throw new IllegalStateException("Missing implementation to handle COMMAND_STOP");
    }

    @ForOverride
    protected ListenableFuture<?> handleRelease() {
        throw new IllegalStateException("Missing implementation to handle COMMAND_RELEASE");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetRepeatMode(int repeatMode) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_REPEAT_MODE");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetShuffleModeEnabled(boolean shuffleModeEnabled) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_SHUFFLE_MODE");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetPlaybackParameters(PlaybackParameters playbackParameters) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_SPEED_AND_PITCH");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetTrackSelectionParameters(TrackSelectionParameters trackSelectionParameters) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_TRACK_SELECTION_PARAMETERS");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetPlaylistMetadata(MediaMetadata playlistMetadata) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_MEDIA_ITEMS_METADATA");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_VOLUME");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetDeviceVolume(@IntRange(from=0L) int deviceVolume) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_DEVICE_VOLUME");
    }

    @ForOverride
    protected ListenableFuture<?> handleIncreaseDeviceVolume() {
        throw new IllegalStateException("Missing implementation to handle COMMAND_ADJUST_DEVICE_VOLUME");
    }

    @ForOverride
    protected ListenableFuture<?> handleDecreaseDeviceVolume() {
        throw new IllegalStateException("Missing implementation to handle COMMAND_ADJUST_DEVICE_VOLUME");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetDeviceMuted(boolean muted) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_ADJUST_DEVICE_VOLUME");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetVideoOutput(Object videoOutput) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_VIDEO_SURFACE");
    }

    @ForOverride
    protected ListenableFuture<?> handleClearVideoOutput(@Nullable Object videoOutput) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_VIDEO_SURFACE");
    }

    @ForOverride
    protected ListenableFuture<?> handleSetMediaItems(List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_SET_MEDIA_ITEM(S)");
    }

    @ForOverride
    protected ListenableFuture<?> handleAddMediaItems(int index, List<MediaItem> mediaItems) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_CHANGE_MEDIA_ITEMS");
    }

    @ForOverride
    protected ListenableFuture<?> handleMoveMediaItems(int fromIndex, int toIndex, int newIndex) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_CHANGE_MEDIA_ITEMS");
    }

    @ForOverride
    protected ListenableFuture<?> handleRemoveMediaItems(int fromIndex, int toIndex) {
        throw new IllegalStateException("Missing implementation to handle COMMAND_CHANGE_MEDIA_ITEMS");
    }

    @ForOverride
    protected ListenableFuture<?> handleSeek(int mediaItemIndex, long positionMs, int seekCommand) {
        throw new IllegalStateException("Missing implementation to handle one of the COMMAND_SEEK_*");
    }

    @RequiresNonNull(value={"state"})
    private boolean shouldHandleCommand(int commandCode) {
        return !this.released && this.state.availableCommands.contains(commandCode);
    }

    @RequiresNonNull(value={"state"})
    private void updateStateAndInformListeners(State newState, boolean seeked, boolean isRepeatingCurrentItem) {
        State previousState = this.state;
        this.state = newState;
        if (newState.hasPositionDiscontinuity || newState.newlyRenderedFirstFrame) {
            this.state = this.state.buildUpon().clearPositionDiscontinuity().setNewlyRenderedFirstFrame(false).build();
        }
        boolean playWhenReadyChanged = previousState.playWhenReady != newState.playWhenReady;
        boolean playbackStateChanged = previousState.playbackState != newState.playbackState;
        Tracks previousTracks = SimpleBasePlayer.getCurrentTracksInternal(previousState);
        Tracks newTracks = SimpleBasePlayer.getCurrentTracksInternal(newState);
        MediaMetadata previousMediaMetadata = SimpleBasePlayer.getMediaMetadataInternal(previousState);
        MediaMetadata newMediaMetadata = SimpleBasePlayer.getMediaMetadataInternal(newState);
        int positionDiscontinuityReason = SimpleBasePlayer.getPositionDiscontinuityReason(previousState, newState, seeked, this.window, this.period);
        boolean timelineChanged = !previousState.timeline.equals(newState.timeline);
        int mediaItemTransitionReason = SimpleBasePlayer.getMediaItemTransitionReason(previousState, newState, positionDiscontinuityReason, isRepeatingCurrentItem, this.window);
        if (timelineChanged) {
            int timelineChangeReason = SimpleBasePlayer.getTimelineChangeReason(previousState.playlist, newState.playlist);
            this.listeners.queueEvent(0, listener -> listener.onTimelineChanged(newState.timeline, timelineChangeReason));
        }
        if (positionDiscontinuityReason != -1) {
            Player.PositionInfo previousPositionInfo = SimpleBasePlayer.getPositionInfo(previousState, false, this.window, this.period);
            Player.PositionInfo positionInfo = SimpleBasePlayer.getPositionInfo(newState, newState.hasPositionDiscontinuity, this.window, this.period);
            this.listeners.queueEvent(11, listener -> {
                listener.onPositionDiscontinuity(positionDiscontinuityReason);
                listener.onPositionDiscontinuity(previousPositionInfo, positionInfo, positionDiscontinuityReason);
            });
        }
        if (mediaItemTransitionReason != -1) {
            MediaItem mediaItem = newState.timeline.isEmpty() ? null : ((MediaItemData)newState.playlist.get((int)SimpleBasePlayer.getCurrentMediaItemIndexInternal((State)newState))).mediaItem;
            this.listeners.queueEvent(1, listener -> listener.onMediaItemTransition(mediaItem, mediaItemTransitionReason));
        }
        if (!Util.areEqual(previousState.playerError, newState.playerError)) {
            this.listeners.queueEvent(10, listener -> listener.onPlayerErrorChanged(newState.playerError));
            if (newState.playerError != null) {
                this.listeners.queueEvent(10, listener -> listener.onPlayerError(Util.castNonNull(newState.playerError)));
            }
        }
        if (!previousState.trackSelectionParameters.equals(newState.trackSelectionParameters)) {
            this.listeners.queueEvent(19, listener -> listener.onTrackSelectionParametersChanged(newState.trackSelectionParameters));
        }
        if (!previousTracks.equals(newTracks)) {
            this.listeners.queueEvent(2, listener -> listener.onTracksChanged(newTracks));
        }
        if (!previousMediaMetadata.equals(newMediaMetadata)) {
            this.listeners.queueEvent(14, listener -> listener.onMediaMetadataChanged(newMediaMetadata));
        }
        if (previousState.isLoading != newState.isLoading) {
            this.listeners.queueEvent(3, listener -> {
                listener.onLoadingChanged(newState.isLoading);
                listener.onIsLoadingChanged(newState.isLoading);
            });
        }
        if (playWhenReadyChanged || playbackStateChanged) {
            this.listeners.queueEvent(-1, listener -> listener.onPlayerStateChanged(newState.playWhenReady, newState.playbackState));
        }
        if (playbackStateChanged) {
            this.listeners.queueEvent(4, listener -> listener.onPlaybackStateChanged(newState.playbackState));
        }
        if (playWhenReadyChanged || previousState.playWhenReadyChangeReason != newState.playWhenReadyChangeReason) {
            this.listeners.queueEvent(5, listener -> listener.onPlayWhenReadyChanged(newState.playWhenReady, newState.playWhenReadyChangeReason));
        }
        if (previousState.playbackSuppressionReason != newState.playbackSuppressionReason) {
            this.listeners.queueEvent(6, listener -> listener.onPlaybackSuppressionReasonChanged(newState.playbackSuppressionReason));
        }
        if (SimpleBasePlayer.isPlaying(previousState) != SimpleBasePlayer.isPlaying(newState)) {
            this.listeners.queueEvent(7, listener -> listener.onIsPlayingChanged(SimpleBasePlayer.isPlaying(newState)));
        }
        if (!previousState.playbackParameters.equals(newState.playbackParameters)) {
            this.listeners.queueEvent(12, listener -> listener.onPlaybackParametersChanged(newState.playbackParameters));
        }
        if (previousState.repeatMode != newState.repeatMode) {
            this.listeners.queueEvent(8, listener -> listener.onRepeatModeChanged(newState.repeatMode));
        }
        if (previousState.shuffleModeEnabled != newState.shuffleModeEnabled) {
            this.listeners.queueEvent(9, listener -> listener.onShuffleModeEnabledChanged(newState.shuffleModeEnabled));
        }
        if (previousState.seekBackIncrementMs != newState.seekBackIncrementMs) {
            this.listeners.queueEvent(16, listener -> listener.onSeekBackIncrementChanged(newState.seekBackIncrementMs));
        }
        if (previousState.seekForwardIncrementMs != newState.seekForwardIncrementMs) {
            this.listeners.queueEvent(17, listener -> listener.onSeekForwardIncrementChanged(newState.seekForwardIncrementMs));
        }
        if (previousState.maxSeekToPreviousPositionMs != newState.maxSeekToPreviousPositionMs) {
            this.listeners.queueEvent(18, listener -> listener.onMaxSeekToPreviousPositionChanged(newState.maxSeekToPreviousPositionMs));
        }
        if (!previousState.audioAttributes.equals(newState.audioAttributes)) {
            this.listeners.queueEvent(20, listener -> listener.onAudioAttributesChanged(newState.audioAttributes));
        }
        if (!previousState.videoSize.equals(newState.videoSize)) {
            this.listeners.queueEvent(25, listener -> listener.onVideoSizeChanged(newState.videoSize));
        }
        if (!previousState.deviceInfo.equals(newState.deviceInfo)) {
            this.listeners.queueEvent(29, listener -> listener.onDeviceInfoChanged(newState.deviceInfo));
        }
        if (!previousState.playlistMetadata.equals(newState.playlistMetadata)) {
            this.listeners.queueEvent(15, listener -> listener.onPlaylistMetadataChanged(newState.playlistMetadata));
        }
        if (newState.newlyRenderedFirstFrame) {
            this.listeners.queueEvent(26, Player.Listener::onRenderedFirstFrame);
        }
        if (!previousState.surfaceSize.equals(newState.surfaceSize)) {
            this.listeners.queueEvent(24, listener -> listener.onSurfaceSizeChanged(newState.surfaceSize.getWidth(), newState.surfaceSize.getHeight()));
        }
        if (previousState.volume != newState.volume) {
            this.listeners.queueEvent(22, listener -> listener.onVolumeChanged(newState.volume));
        }
        if (previousState.deviceVolume != newState.deviceVolume || previousState.isDeviceMuted != newState.isDeviceMuted) {
            this.listeners.queueEvent(30, listener -> listener.onDeviceVolumeChanged(newState.deviceVolume, newState.isDeviceMuted));
        }
        if (!previousState.currentCues.equals(newState.currentCues)) {
            this.listeners.queueEvent(27, listener -> {
                listener.onCues((List<Cue>)newState.currentCues.cues);
                listener.onCues(newState.currentCues);
            });
        }
        if (!previousState.timedMetadata.equals(newState.timedMetadata) && newState.timedMetadata.presentationTimeUs != -9223372036854775807L) {
            this.listeners.queueEvent(28, listener -> listener.onMetadata(newState.timedMetadata));
        }
        if (positionDiscontinuityReason == 1) {
            this.listeners.queueEvent(-1, Player.Listener::onSeekProcessed);
        }
        if (!previousState.availableCommands.equals(newState.availableCommands)) {
            this.listeners.queueEvent(13, listener -> listener.onAvailableCommandsChanged(newState.availableCommands));
        }
        this.listeners.flushEvents();
    }

    @EnsuresNonNull(value={"state"})
    private void verifyApplicationThreadAndInitState() {
        if (Thread.currentThread() != this.applicationLooper.getThread()) {
            String message = Util.formatInvariant("Player is accessed on the wrong thread.\nCurrent thread: '%s'\nExpected thread: '%s'\nSee https://developer.android.com/guide/topics/media/issues/player-accessed-on-wrong-thread", Thread.currentThread().getName(), this.applicationLooper.getThread().getName());
            throw new IllegalStateException(message);
        }
        if (this.state == null) {
            this.state = this.getState();
        }
    }

    @RequiresNonNull(value={"state"})
    private void updateStateForPendingOperation(ListenableFuture<?> pendingOperation, Supplier<State> placeholderStateSupplier) {
        this.updateStateForPendingOperation(pendingOperation, placeholderStateSupplier, false, false);
    }

    @RequiresNonNull(value={"state"})
    private void updateStateForPendingOperation(ListenableFuture<?> pendingOperation, Supplier<State> placeholderStateSupplier, boolean seeked, boolean isRepeatingCurrentItem) {
        if (pendingOperation.isDone() && this.pendingOperations.isEmpty()) {
            this.updateStateAndInformListeners(this.getState(), seeked, isRepeatingCurrentItem);
        } else {
            this.pendingOperations.add(pendingOperation);
            State suggestedPlaceholderState = (State)placeholderStateSupplier.get();
            this.updateStateAndInformListeners(this.getPlaceholderState(suggestedPlaceholderState), seeked, isRepeatingCurrentItem);
            pendingOperation.addListener(() -> {
                Util.castNonNull(this.state);
                this.pendingOperations.remove(pendingOperation);
                if (this.pendingOperations.isEmpty() && !this.released) {
                    this.updateStateAndInformListeners(this.getState(), false, false);
                }
            }, this::postOrRunOnApplicationHandler);
        }
    }

    private void postOrRunOnApplicationHandler(Runnable runnable) {
        if (this.applicationHandler.getLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            this.applicationHandler.post(runnable);
        }
    }

    private static boolean isPlaying(State state) {
        return state.playWhenReady && state.playbackState == 3 && state.playbackSuppressionReason == 0;
    }

    private static Tracks getCurrentTracksInternal(State state) {
        return state.playlist.isEmpty() ? Tracks.EMPTY : ((MediaItemData)state.playlist.get((int)SimpleBasePlayer.getCurrentMediaItemIndexInternal((State)state))).tracks;
    }

    private static MediaMetadata getMediaMetadataInternal(State state) {
        return state.playlist.isEmpty() ? MediaMetadata.EMPTY : ((MediaItemData)state.playlist.get(SimpleBasePlayer.getCurrentMediaItemIndexInternal(state))).combinedMediaMetadata;
    }

    private static int getCurrentMediaItemIndexInternal(State state) {
        if (state.currentMediaItemIndex != -1) {
            return state.currentMediaItemIndex;
        }
        return 0;
    }

    private static long getContentPositionMsInternal(State state) {
        return SimpleBasePlayer.getPositionOrDefaultInMediaItem(state.contentPositionMsSupplier.get(), state);
    }

    private static long getContentBufferedPositionMsInternal(State state) {
        return SimpleBasePlayer.getPositionOrDefaultInMediaItem(state.contentBufferedPositionMsSupplier.get(), state);
    }

    private static long getPositionOrDefaultInMediaItem(long positionMs, State state) {
        if (positionMs != -9223372036854775807L) {
            return positionMs;
        }
        if (state.playlist.isEmpty()) {
            return 0L;
        }
        return Util.usToMs(((MediaItemData)state.playlist.get((int)SimpleBasePlayer.getCurrentMediaItemIndexInternal((State)state))).defaultPositionUs);
    }

    private static int getCurrentPeriodIndexInternal(State state, Timeline.Window window, Timeline.Period period) {
        int currentMediaItemIndex = SimpleBasePlayer.getCurrentMediaItemIndexInternal(state);
        if (state.timeline.isEmpty()) {
            return currentMediaItemIndex;
        }
        return SimpleBasePlayer.getPeriodIndexFromWindowPosition(state.timeline, currentMediaItemIndex, SimpleBasePlayer.getContentPositionMsInternal(state), window, period);
    }

    private static int getPeriodIndexFromWindowPosition(Timeline timeline, int windowIndex, long windowPositionMs, Timeline.Window window, Timeline.Period period) {
        Object periodUid = timeline.getPeriodPositionUs((Timeline.Window)window, (Timeline.Period)period, (int)windowIndex, (long)Util.msToUs((long)windowPositionMs)).first;
        return timeline.getIndexOfPeriod(periodUid);
    }

    private static int getTimelineChangeReason(List<MediaItemData> previousPlaylist, List<MediaItemData> newPlaylist) {
        if (previousPlaylist.size() != newPlaylist.size()) {
            return 0;
        }
        for (int i = 0; i < previousPlaylist.size(); ++i) {
            boolean resolvedAutoGeneratedPlaceholder;
            Object previousUid = previousPlaylist.get((int)i).uid;
            Object newUid = newPlaylist.get((int)i).uid;
            boolean bl = resolvedAutoGeneratedPlaceholder = previousUid instanceof PlaceholderUid && !(newUid instanceof PlaceholderUid);
            if (previousUid.equals(newUid) || resolvedAutoGeneratedPlaceholder) continue;
            return 0;
        }
        return 1;
    }

    private static int getPositionDiscontinuityReason(State previousState, State newState, boolean seeked, Timeline.Window window, Timeline.Period period) {
        long newPositionMs;
        if (newState.hasPositionDiscontinuity) {
            return newState.positionDiscontinuityReason;
        }
        if (seeked) {
            return 1;
        }
        if (previousState.playlist.isEmpty()) {
            return -1;
        }
        if (newState.playlist.isEmpty()) {
            return 4;
        }
        Object previousPeriodUid = previousState.timeline.getUidOfPeriod(SimpleBasePlayer.getCurrentPeriodIndexInternal(previousState, window, period));
        Object newPeriodUid = newState.timeline.getUidOfPeriod(SimpleBasePlayer.getCurrentPeriodIndexInternal(newState, window, period));
        if (previousPeriodUid instanceof PlaceholderUid && !(newPeriodUid instanceof PlaceholderUid)) {
            return -1;
        }
        if (!newPeriodUid.equals(previousPeriodUid) || previousState.currentAdGroupIndex != newState.currentAdGroupIndex || previousState.currentAdIndexInAdGroup != newState.currentAdIndexInAdGroup) {
            if (newState.timeline.getIndexOfPeriod(previousPeriodUid) == -1) {
                return 4;
            }
            long previousPositionMs = SimpleBasePlayer.getCurrentPeriodOrAdPositionMs(previousState, previousPeriodUid, period);
            long previousDurationMs = SimpleBasePlayer.getPeriodOrAdDurationMs(previousState, previousPeriodUid, period);
            return previousDurationMs != -9223372036854775807L && previousPositionMs >= previousDurationMs ? 0 : 3;
        }
        long previousPositionMs = SimpleBasePlayer.getCurrentPeriodOrAdPositionMs(previousState, previousPeriodUid, period);
        if (Math.abs(previousPositionMs - (newPositionMs = SimpleBasePlayer.getCurrentPeriodOrAdPositionMs(newState, newPeriodUid, period))) < 1000L) {
            return -1;
        }
        long previousDurationMs = SimpleBasePlayer.getPeriodOrAdDurationMs(previousState, previousPeriodUid, period);
        return previousDurationMs != -9223372036854775807L && previousPositionMs >= previousDurationMs ? 0 : 5;
    }

    private static long getCurrentPeriodOrAdPositionMs(State state, Object currentPeriodUid, Timeline.Period period) {
        return state.currentAdGroupIndex != -1 ? state.adPositionMsSupplier.get() : SimpleBasePlayer.getContentPositionMsInternal(state) - state.timeline.getPeriodByUid(currentPeriodUid, period).getPositionInWindowMs();
    }

    private static long getPeriodOrAdDurationMs(State state, Object currentPeriodUid, Timeline.Period period) {
        state.timeline.getPeriodByUid(currentPeriodUid, period);
        long periodOrAdDurationUs = state.currentAdGroupIndex == -1 ? period.durationUs : period.getAdDurationUs(state.currentAdGroupIndex, state.currentAdIndexInAdGroup);
        return Util.usToMs(periodOrAdDurationUs);
    }

    private static Player.PositionInfo getPositionInfo(State state, boolean useDiscontinuityPosition, Timeline.Window window, Timeline.Period period) {
        long contentPositionMs;
        long positionMs;
        Object windowUid = null;
        Object periodUid = null;
        int mediaItemIndex = SimpleBasePlayer.getCurrentMediaItemIndexInternal(state);
        int periodIndex = -1;
        MediaItem mediaItem = null;
        if (!state.timeline.isEmpty()) {
            periodIndex = SimpleBasePlayer.getCurrentPeriodIndexInternal(state, window, period);
            periodUid = state.timeline.getPeriod((int)periodIndex, (Timeline.Period)period, (boolean)true).uid;
            windowUid = state.timeline.getWindow((int)mediaItemIndex, (Timeline.Window)window).uid;
            mediaItem = window.mediaItem;
        }
        if (useDiscontinuityPosition) {
            positionMs = state.discontinuityPositionMs;
            contentPositionMs = state.currentAdGroupIndex == -1 ? positionMs : SimpleBasePlayer.getContentPositionMsInternal(state);
        } else {
            contentPositionMs = SimpleBasePlayer.getContentPositionMsInternal(state);
            positionMs = state.currentAdGroupIndex != -1 ? state.adPositionMsSupplier.get() : contentPositionMs;
        }
        return new Player.PositionInfo(windowUid, mediaItemIndex, mediaItem, periodUid, periodIndex, positionMs, contentPositionMs, state.currentAdGroupIndex, state.currentAdIndexInAdGroup);
    }

    private static int getMediaItemTransitionReason(State previousState, State newState, int positionDiscontinuityReason, boolean isRepeatingCurrentItem, Timeline.Window window) {
        Timeline previousTimeline = previousState.timeline;
        Timeline newTimeline = newState.timeline;
        if (newTimeline.isEmpty() && previousTimeline.isEmpty()) {
            return -1;
        }
        if (newTimeline.isEmpty() != previousTimeline.isEmpty()) {
            return 3;
        }
        Object previousWindowUid = previousState.timeline.getWindow((int)SimpleBasePlayer.getCurrentMediaItemIndexInternal((State)previousState), (Timeline.Window)window).uid;
        Object newWindowUid = newState.timeline.getWindow((int)SimpleBasePlayer.getCurrentMediaItemIndexInternal((State)newState), (Timeline.Window)window).uid;
        if (previousWindowUid instanceof PlaceholderUid && !(newWindowUid instanceof PlaceholderUid)) {
            return -1;
        }
        if (!previousWindowUid.equals(newWindowUid)) {
            if (positionDiscontinuityReason == 0) {
                return 1;
            }
            if (positionDiscontinuityReason == 1) {
                return 2;
            }
            return 3;
        }
        if (positionDiscontinuityReason == 0 && SimpleBasePlayer.getContentPositionMsInternal(previousState) > SimpleBasePlayer.getContentPositionMsInternal(newState)) {
            return 0;
        }
        if (positionDiscontinuityReason == 1 && isRepeatingCurrentItem) {
            return 2;
        }
        return -1;
    }

    private static Size getSurfaceHolderSize(SurfaceHolder surfaceHolder) {
        if (!surfaceHolder.getSurface().isValid()) {
            return Size.ZERO;
        }
        Rect surfaceFrame = surfaceHolder.getSurfaceFrame();
        return new Size(surfaceFrame.width(), surfaceFrame.height());
    }

    private static int getMediaItemIndexInNewPlaylist(List<MediaItemData> oldPlaylist, Timeline newPlaylistTimeline, int oldMediaItemIndex, Timeline.Period period) {
        if (oldPlaylist.isEmpty()) {
            return oldMediaItemIndex < newPlaylistTimeline.getWindowCount() ? oldMediaItemIndex : -1;
        }
        Object oldFirstPeriodUid = oldPlaylist.get(oldMediaItemIndex).getPeriodUid(0);
        if (newPlaylistTimeline.getIndexOfPeriod(oldFirstPeriodUid) == -1) {
            return -1;
        }
        return newPlaylistTimeline.getPeriodByUid((Object)oldFirstPeriodUid, (Timeline.Period)period).windowIndex;
    }

    private static State getStateWithNewPlaylist(State oldState, List<MediaItemData> newPlaylist, Timeline.Period period) {
        State.Builder stateBuilder = oldState.buildUpon();
        stateBuilder.setPlaylist(newPlaylist);
        Timeline newTimeline = stateBuilder.timeline;
        long oldPositionMs = oldState.contentPositionMsSupplier.get();
        int oldIndex = SimpleBasePlayer.getCurrentMediaItemIndexInternal(oldState);
        int newIndex = SimpleBasePlayer.getMediaItemIndexInNewPlaylist(oldState.playlist, newTimeline, oldIndex, period);
        long newPositionMs = newIndex == -1 ? -9223372036854775807L : oldPositionMs;
        for (int i = oldIndex + 1; newIndex == -1 && i < oldState.playlist.size(); ++i) {
            newIndex = SimpleBasePlayer.getMediaItemIndexInNewPlaylist(oldState.playlist, newTimeline, i, period);
        }
        if (oldState.playbackState != 1 && newIndex == -1) {
            stateBuilder.setPlaybackState(4).setIsLoading(false);
        }
        return SimpleBasePlayer.buildStateForNewPosition(stateBuilder, oldState, oldPositionMs, newPlaylist, newIndex, newPositionMs, true);
    }

    private static State getStateWithNewPlaylistAndPosition(State oldState, List<MediaItemData> newPlaylist, int newIndex, long newPositionMs) {
        State.Builder stateBuilder = oldState.buildUpon();
        stateBuilder.setPlaylist(newPlaylist);
        if (oldState.playbackState != 1) {
            if (newPlaylist.isEmpty()) {
                stateBuilder.setPlaybackState(4).setIsLoading(false);
            } else {
                stateBuilder.setPlaybackState(2);
            }
        }
        long oldPositionMs = oldState.contentPositionMsSupplier.get();
        return SimpleBasePlayer.buildStateForNewPosition(stateBuilder, oldState, oldPositionMs, newPlaylist, newIndex, newPositionMs, false);
    }

    private static State buildStateForNewPosition(State.Builder stateBuilder, State oldState, long oldPositionMs, List<MediaItemData> newPlaylist, int newIndex, long newPositionMs, boolean keepAds) {
        boolean mediaItemChanged;
        oldPositionMs = SimpleBasePlayer.getPositionOrDefaultInMediaItem(oldPositionMs, oldState);
        if (!(newPlaylist.isEmpty() || newIndex != -1 && newIndex < newPlaylist.size())) {
            newIndex = 0;
            newPositionMs = -9223372036854775807L;
        }
        if (!newPlaylist.isEmpty() && newPositionMs == -9223372036854775807L) {
            newPositionMs = Util.usToMs(newPlaylist.get((int)newIndex).defaultPositionUs);
        }
        boolean oldOrNewPlaylistEmpty = oldState.playlist.isEmpty() || newPlaylist.isEmpty();
        boolean bl = mediaItemChanged = !oldOrNewPlaylistEmpty && !((MediaItemData)oldState.playlist.get((int)SimpleBasePlayer.getCurrentMediaItemIndexInternal((State)oldState))).uid.equals(newPlaylist.get((int)newIndex).uid);
        if (oldOrNewPlaylistEmpty || mediaItemChanged || newPositionMs < oldPositionMs) {
            stateBuilder.setCurrentMediaItemIndex(newIndex).setCurrentAd(-1, -1).setContentPositionMs(newPositionMs).setContentBufferedPositionMs(PositionSupplier.getConstant(newPositionMs)).setTotalBufferedDurationMs(PositionSupplier.ZERO);
        } else if (newPositionMs == oldPositionMs) {
            stateBuilder.setCurrentMediaItemIndex(newIndex);
            if (oldState.currentAdGroupIndex != -1 && keepAds) {
                stateBuilder.setTotalBufferedDurationMs(PositionSupplier.getConstant(oldState.adBufferedPositionMsSupplier.get() - oldState.adPositionMsSupplier.get()));
            } else {
                stateBuilder.setCurrentAd(-1, -1).setTotalBufferedDurationMs(PositionSupplier.getConstant(SimpleBasePlayer.getContentBufferedPositionMsInternal(oldState) - oldPositionMs));
            }
        } else {
            long contentBufferedDurationMs = Math.max(SimpleBasePlayer.getContentBufferedPositionMsInternal(oldState), newPositionMs);
            long totalBufferedDurationMs = Math.max(0L, oldState.totalBufferedDurationMsSupplier.get() - (newPositionMs - oldPositionMs));
            stateBuilder.setCurrentMediaItemIndex(newIndex).setCurrentAd(-1, -1).setContentPositionMs(newPositionMs).setContentBufferedPositionMs(PositionSupplier.getConstant(contentBufferedDurationMs)).setTotalBufferedDurationMs(PositionSupplier.getConstant(totalBufferedDurationMs));
        }
        return stateBuilder.build();
    }

    private static final class PlaceholderUid {
        private PlaceholderUid() {
        }
    }

    protected static interface PositionSupplier {
        public static final PositionSupplier ZERO = PositionSupplier.getConstant(0L);

        public static PositionSupplier getConstant(long positionMs) {
            return () -> positionMs;
        }

        public static PositionSupplier getExtrapolating(long currentPositionMs, float playbackSpeed) {
            long startTimeMs = SystemClock.elapsedRealtime();
            return () -> {
                long currentTimeMs = SystemClock.elapsedRealtime();
                return currentPositionMs + (long)((float)(currentTimeMs - startTimeMs) * playbackSpeed);
            };
        }

        public long get();
    }

    protected static final class PeriodData {
        public final Object uid;
        public final long durationUs;
        public final AdPlaybackState adPlaybackState;
        public final boolean isPlaceholder;

        private PeriodData(Builder builder) {
            this.uid = builder.uid;
            this.durationUs = builder.durationUs;
            this.adPlaybackState = builder.adPlaybackState;
            this.isPlaceholder = builder.isPlaceholder;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PeriodData)) {
                return false;
            }
            PeriodData periodData = (PeriodData)o;
            return this.uid.equals(periodData.uid) && this.durationUs == periodData.durationUs && this.adPlaybackState.equals(periodData.adPlaybackState) && this.isPlaceholder == periodData.isPlaceholder;
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + this.uid.hashCode();
            result = 31 * result + (int)(this.durationUs ^ this.durationUs >>> 32);
            result = 31 * result + this.adPlaybackState.hashCode();
            result = 31 * result + (this.isPlaceholder ? 1 : 0);
            return result;
        }

        public static final class Builder {
            private Object uid;
            private long durationUs;
            private AdPlaybackState adPlaybackState;
            private boolean isPlaceholder;

            public Builder(Object uid) {
                this.uid = uid;
                this.durationUs = 0L;
                this.adPlaybackState = AdPlaybackState.NONE;
                this.isPlaceholder = false;
            }

            private Builder(PeriodData periodData) {
                this.uid = periodData.uid;
                this.durationUs = periodData.durationUs;
                this.adPlaybackState = periodData.adPlaybackState;
                this.isPlaceholder = periodData.isPlaceholder;
            }

            @CanIgnoreReturnValue
            public Builder setUid(Object uid) {
                this.uid = uid;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setDurationUs(long durationUs) {
                Assertions.checkArgument(durationUs == -9223372036854775807L || durationUs >= 0L);
                this.durationUs = durationUs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAdPlaybackState(AdPlaybackState adPlaybackState) {
                this.adPlaybackState = adPlaybackState;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsPlaceholder(boolean isPlaceholder) {
                this.isPlaceholder = isPlaceholder;
                return this;
            }

            public PeriodData build() {
                return new PeriodData(this);
            }
        }
    }

    protected static final class MediaItemData {
        public final Object uid;
        public final Tracks tracks;
        public final MediaItem mediaItem;
        @Nullable
        public final MediaMetadata mediaMetadata;
        @Nullable
        public final Object manifest;
        @Nullable
        public final MediaItem.LiveConfiguration liveConfiguration;
        public final long presentationStartTimeMs;
        public final long windowStartTimeMs;
        public final long elapsedRealtimeEpochOffsetMs;
        public final boolean isSeekable;
        public final boolean isDynamic;
        public final long defaultPositionUs;
        public final long durationUs;
        public final long positionInFirstPeriodUs;
        public final boolean isPlaceholder;
        public final ImmutableList<PeriodData> periods;
        private final long[] periodPositionInWindowUs;
        private final MediaMetadata combinedMediaMetadata;

        private MediaItemData(Builder builder) {
            if (builder.liveConfiguration == null) {
                Assertions.checkArgument(builder.presentationStartTimeMs == -9223372036854775807L, "presentationStartTimeMs can only be set if liveConfiguration != null");
                Assertions.checkArgument(builder.windowStartTimeMs == -9223372036854775807L, "windowStartTimeMs can only be set if liveConfiguration != null");
                Assertions.checkArgument(builder.elapsedRealtimeEpochOffsetMs == -9223372036854775807L, "elapsedRealtimeEpochOffsetMs can only be set if liveConfiguration != null");
            } else if (builder.presentationStartTimeMs != -9223372036854775807L && builder.windowStartTimeMs != -9223372036854775807L) {
                Assertions.checkArgument(builder.windowStartTimeMs >= builder.presentationStartTimeMs, "windowStartTimeMs can't be less than presentationStartTimeMs");
            }
            int periodCount = builder.periods.size();
            if (builder.durationUs != -9223372036854775807L) {
                Assertions.checkArgument(builder.defaultPositionUs <= builder.durationUs, "defaultPositionUs can't be greater than durationUs");
            }
            this.uid = builder.uid;
            this.tracks = builder.tracks;
            this.mediaItem = builder.mediaItem;
            this.mediaMetadata = builder.mediaMetadata;
            this.manifest = builder.manifest;
            this.liveConfiguration = builder.liveConfiguration;
            this.presentationStartTimeMs = builder.presentationStartTimeMs;
            this.windowStartTimeMs = builder.windowStartTimeMs;
            this.elapsedRealtimeEpochOffsetMs = builder.elapsedRealtimeEpochOffsetMs;
            this.isSeekable = builder.isSeekable;
            this.isDynamic = builder.isDynamic;
            this.defaultPositionUs = builder.defaultPositionUs;
            this.durationUs = builder.durationUs;
            this.positionInFirstPeriodUs = builder.positionInFirstPeriodUs;
            this.isPlaceholder = builder.isPlaceholder;
            this.periods = builder.periods;
            this.periodPositionInWindowUs = new long[this.periods.size()];
            if (!this.periods.isEmpty()) {
                this.periodPositionInWindowUs[0] = -this.positionInFirstPeriodUs;
                for (int i = 0; i < periodCount - 1; ++i) {
                    this.periodPositionInWindowUs[i + 1] = this.periodPositionInWindowUs[i] + ((PeriodData)this.periods.get((int)i)).durationUs;
                }
            }
            this.combinedMediaMetadata = this.mediaMetadata != null ? this.mediaMetadata : MediaItemData.getCombinedMediaMetadata(this.mediaItem, this.tracks);
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MediaItemData)) {
                return false;
            }
            MediaItemData mediaItemData = (MediaItemData)o;
            return this.uid.equals(mediaItemData.uid) && this.tracks.equals(mediaItemData.tracks) && this.mediaItem.equals(mediaItemData.mediaItem) && Util.areEqual(this.mediaMetadata, mediaItemData.mediaMetadata) && Util.areEqual(this.manifest, mediaItemData.manifest) && Util.areEqual(this.liveConfiguration, mediaItemData.liveConfiguration) && this.presentationStartTimeMs == mediaItemData.presentationStartTimeMs && this.windowStartTimeMs == mediaItemData.windowStartTimeMs && this.elapsedRealtimeEpochOffsetMs == mediaItemData.elapsedRealtimeEpochOffsetMs && this.isSeekable == mediaItemData.isSeekable && this.isDynamic == mediaItemData.isDynamic && this.defaultPositionUs == mediaItemData.defaultPositionUs && this.durationUs == mediaItemData.durationUs && this.positionInFirstPeriodUs == mediaItemData.positionInFirstPeriodUs && this.isPlaceholder == mediaItemData.isPlaceholder && this.periods.equals(mediaItemData.periods);
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + this.uid.hashCode();
            result = 31 * result + this.tracks.hashCode();
            result = 31 * result + this.mediaItem.hashCode();
            result = 31 * result + (this.mediaMetadata == null ? 0 : this.mediaMetadata.hashCode());
            result = 31 * result + (this.manifest == null ? 0 : this.manifest.hashCode());
            result = 31 * result + (this.liveConfiguration == null ? 0 : this.liveConfiguration.hashCode());
            result = 31 * result + (int)(this.presentationStartTimeMs ^ this.presentationStartTimeMs >>> 32);
            result = 31 * result + (int)(this.windowStartTimeMs ^ this.windowStartTimeMs >>> 32);
            result = 31 * result + (int)(this.elapsedRealtimeEpochOffsetMs ^ this.elapsedRealtimeEpochOffsetMs >>> 32);
            result = 31 * result + (this.isSeekable ? 1 : 0);
            result = 31 * result + (this.isDynamic ? 1 : 0);
            result = 31 * result + (int)(this.defaultPositionUs ^ this.defaultPositionUs >>> 32);
            result = 31 * result + (int)(this.durationUs ^ this.durationUs >>> 32);
            result = 31 * result + (int)(this.positionInFirstPeriodUs ^ this.positionInFirstPeriodUs >>> 32);
            result = 31 * result + (this.isPlaceholder ? 1 : 0);
            result = 31 * result + this.periods.hashCode();
            return result;
        }

        private Timeline.Window getWindow(int firstPeriodIndex, Timeline.Window window) {
            int periodCount = this.periods.isEmpty() ? 1 : this.periods.size();
            window.set(this.uid, this.mediaItem, this.manifest, this.presentationStartTimeMs, this.windowStartTimeMs, this.elapsedRealtimeEpochOffsetMs, this.isSeekable, this.isDynamic, this.liveConfiguration, this.defaultPositionUs, this.durationUs, firstPeriodIndex, firstPeriodIndex + periodCount - 1, this.positionInFirstPeriodUs);
            window.isPlaceholder = this.isPlaceholder;
            return window;
        }

        private Timeline.Period getPeriod(int windowIndex, int periodIndexInMediaItem, Timeline.Period period) {
            if (this.periods.isEmpty()) {
                period.set(this.uid, this.uid, windowIndex, this.positionInFirstPeriodUs + this.durationUs, 0L, AdPlaybackState.NONE, this.isPlaceholder);
            } else {
                PeriodData periodData = (PeriodData)this.periods.get(periodIndexInMediaItem);
                Object periodId = periodData.uid;
                Pair periodUid = Pair.create((Object)this.uid, (Object)periodId);
                period.set(periodId, periodUid, windowIndex, periodData.durationUs, this.periodPositionInWindowUs[periodIndexInMediaItem], periodData.adPlaybackState, periodData.isPlaceholder);
            }
            return period;
        }

        private Object getPeriodUid(int periodIndexInMediaItem) {
            if (this.periods.isEmpty()) {
                return this.uid;
            }
            Object periodId = ((PeriodData)this.periods.get((int)periodIndexInMediaItem)).uid;
            return Pair.create((Object)this.uid, (Object)periodId);
        }

        private static MediaMetadata getCombinedMediaMetadata(MediaItem mediaItem, Tracks tracks) {
            MediaMetadata.Builder metadataBuilder = new MediaMetadata.Builder();
            int trackGroupCount = tracks.getGroups().size();
            for (int i = 0; i < trackGroupCount; ++i) {
                Tracks.Group group = (Tracks.Group)tracks.getGroups().get(i);
                for (int j = 0; j < group.length; ++j) {
                    if (!group.isTrackSelected(j)) continue;
                    Format format = group.getTrackFormat(j);
                    if (format.metadata == null) continue;
                    for (int k = 0; k < format.metadata.length(); ++k) {
                        format.metadata.get(k).populateMediaMetadata(metadataBuilder);
                    }
                }
            }
            return metadataBuilder.populate(mediaItem.mediaMetadata).build();
        }

        public static final class Builder {
            private Object uid;
            private Tracks tracks;
            private MediaItem mediaItem;
            @Nullable
            private MediaMetadata mediaMetadata;
            @Nullable
            private Object manifest;
            @Nullable
            private MediaItem.LiveConfiguration liveConfiguration;
            private long presentationStartTimeMs;
            private long windowStartTimeMs;
            private long elapsedRealtimeEpochOffsetMs;
            private boolean isSeekable;
            private boolean isDynamic;
            private long defaultPositionUs;
            private long durationUs;
            private long positionInFirstPeriodUs;
            private boolean isPlaceholder;
            private ImmutableList<PeriodData> periods;

            public Builder(Object uid) {
                this.uid = uid;
                this.tracks = Tracks.EMPTY;
                this.mediaItem = MediaItem.EMPTY;
                this.mediaMetadata = null;
                this.manifest = null;
                this.liveConfiguration = null;
                this.presentationStartTimeMs = -9223372036854775807L;
                this.windowStartTimeMs = -9223372036854775807L;
                this.elapsedRealtimeEpochOffsetMs = -9223372036854775807L;
                this.isSeekable = false;
                this.isDynamic = false;
                this.defaultPositionUs = 0L;
                this.durationUs = -9223372036854775807L;
                this.positionInFirstPeriodUs = 0L;
                this.isPlaceholder = false;
                this.periods = ImmutableList.of();
            }

            private Builder(MediaItemData mediaItemData) {
                this.uid = mediaItemData.uid;
                this.tracks = mediaItemData.tracks;
                this.mediaItem = mediaItemData.mediaItem;
                this.mediaMetadata = mediaItemData.mediaMetadata;
                this.manifest = mediaItemData.manifest;
                this.liveConfiguration = mediaItemData.liveConfiguration;
                this.presentationStartTimeMs = mediaItemData.presentationStartTimeMs;
                this.windowStartTimeMs = mediaItemData.windowStartTimeMs;
                this.elapsedRealtimeEpochOffsetMs = mediaItemData.elapsedRealtimeEpochOffsetMs;
                this.isSeekable = mediaItemData.isSeekable;
                this.isDynamic = mediaItemData.isDynamic;
                this.defaultPositionUs = mediaItemData.defaultPositionUs;
                this.durationUs = mediaItemData.durationUs;
                this.positionInFirstPeriodUs = mediaItemData.positionInFirstPeriodUs;
                this.isPlaceholder = mediaItemData.isPlaceholder;
                this.periods = mediaItemData.periods;
            }

            @CanIgnoreReturnValue
            public Builder setUid(Object uid) {
                this.uid = uid;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTracks(Tracks tracks) {
                this.tracks = tracks;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMediaItem(MediaItem mediaItem) {
                this.mediaItem = mediaItem;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMediaMetadata(@Nullable MediaMetadata mediaMetadata) {
                this.mediaMetadata = mediaMetadata;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setManifest(@Nullable Object manifest) {
                this.manifest = manifest;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setLiveConfiguration(@Nullable MediaItem.LiveConfiguration liveConfiguration) {
                this.liveConfiguration = liveConfiguration;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPresentationStartTimeMs(long presentationStartTimeMs) {
                this.presentationStartTimeMs = presentationStartTimeMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setWindowStartTimeMs(long windowStartTimeMs) {
                this.windowStartTimeMs = windowStartTimeMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setElapsedRealtimeEpochOffsetMs(long elapsedRealtimeEpochOffsetMs) {
                this.elapsedRealtimeEpochOffsetMs = elapsedRealtimeEpochOffsetMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsSeekable(boolean isSeekable) {
                this.isSeekable = isSeekable;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsDynamic(boolean isDynamic) {
                this.isDynamic = isDynamic;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setDefaultPositionUs(long defaultPositionUs) {
                Assertions.checkArgument(defaultPositionUs >= 0L);
                this.defaultPositionUs = defaultPositionUs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setDurationUs(long durationUs) {
                Assertions.checkArgument(durationUs == -9223372036854775807L || durationUs >= 0L);
                this.durationUs = durationUs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPositionInFirstPeriodUs(long positionInFirstPeriodUs) {
                Assertions.checkArgument(positionInFirstPeriodUs >= 0L);
                this.positionInFirstPeriodUs = positionInFirstPeriodUs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsPlaceholder(boolean isPlaceholder) {
                this.isPlaceholder = isPlaceholder;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPeriods(List<PeriodData> periods) {
                int periodCount = periods.size();
                for (int i = 0; i < periodCount - 1; ++i) {
                    Assertions.checkArgument(periods.get((int)i).durationUs != -9223372036854775807L, "Periods other than last need a duration");
                    for (int j = i + 1; j < periodCount; ++j) {
                        Assertions.checkArgument(!periods.get((int)i).uid.equals(periods.get((int)j).uid), "Duplicate PeriodData UIDs in period list");
                    }
                }
                this.periods = ImmutableList.copyOf(periods);
                return this;
            }

            public MediaItemData build() {
                return new MediaItemData(this);
            }
        }
    }

    private static final class PlaylistTimeline
    extends Timeline {
        private final ImmutableList<MediaItemData> playlist;
        private final int[] firstPeriodIndexByWindowIndex;
        private final int[] windowIndexByPeriodIndex;
        private final HashMap<Object, Integer> periodIndexByUid;

        public PlaylistTimeline(ImmutableList<MediaItemData> playlist) {
            int mediaItemCount = playlist.size();
            this.playlist = playlist;
            this.firstPeriodIndexByWindowIndex = new int[mediaItemCount];
            int periodCount = 0;
            for (int i = 0; i < mediaItemCount; ++i) {
                MediaItemData mediaItemData = (MediaItemData)playlist.get(i);
                this.firstPeriodIndexByWindowIndex[i] = periodCount;
                periodCount += PlaylistTimeline.getPeriodCountInMediaItem(mediaItemData);
            }
            this.windowIndexByPeriodIndex = new int[periodCount];
            this.periodIndexByUid = new HashMap();
            int periodIndex = 0;
            for (int i = 0; i < mediaItemCount; ++i) {
                MediaItemData mediaItemData = (MediaItemData)playlist.get(i);
                for (int j = 0; j < PlaylistTimeline.getPeriodCountInMediaItem(mediaItemData); ++j) {
                    this.periodIndexByUid.put(mediaItemData.getPeriodUid(j), periodIndex);
                    this.windowIndexByPeriodIndex[periodIndex] = i;
                    ++periodIndex;
                }
            }
        }

        @Override
        public int getWindowCount() {
            return this.playlist.size();
        }

        @Override
        public int getNextWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
            return super.getNextWindowIndex(windowIndex, repeatMode, shuffleModeEnabled);
        }

        @Override
        public int getPreviousWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
            return super.getPreviousWindowIndex(windowIndex, repeatMode, shuffleModeEnabled);
        }

        @Override
        public int getLastWindowIndex(boolean shuffleModeEnabled) {
            return super.getLastWindowIndex(shuffleModeEnabled);
        }

        @Override
        public int getFirstWindowIndex(boolean shuffleModeEnabled) {
            return super.getFirstWindowIndex(shuffleModeEnabled);
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            return ((MediaItemData)this.playlist.get(windowIndex)).getWindow(this.firstPeriodIndexByWindowIndex[windowIndex], window);
        }

        @Override
        public int getPeriodCount() {
            return this.windowIndexByPeriodIndex.length;
        }

        @Override
        public Timeline.Period getPeriodByUid(Object periodUid, Timeline.Period period) {
            int periodIndex = Assertions.checkNotNull(this.periodIndexByUid.get(periodUid));
            return this.getPeriod(periodIndex, period, true);
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            int windowIndex = this.windowIndexByPeriodIndex[periodIndex];
            int periodIndexInWindow = periodIndex - this.firstPeriodIndexByWindowIndex[windowIndex];
            return ((MediaItemData)this.playlist.get(windowIndex)).getPeriod(windowIndex, periodIndexInWindow, period);
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            Integer index = this.periodIndexByUid.get(uid);
            return index == null ? -1 : index;
        }

        @Override
        public Object getUidOfPeriod(int periodIndex) {
            int windowIndex = this.windowIndexByPeriodIndex[periodIndex];
            int periodIndexInWindow = periodIndex - this.firstPeriodIndexByWindowIndex[windowIndex];
            return ((MediaItemData)this.playlist.get(windowIndex)).getPeriodUid(periodIndexInWindow);
        }

        private static int getPeriodCountInMediaItem(MediaItemData mediaItemData) {
            return mediaItemData.periods.isEmpty() ? 1 : mediaItemData.periods.size();
        }
    }

    protected static final class State {
        public final Player.Commands availableCommands;
        public final boolean playWhenReady;
        public final int playWhenReadyChangeReason;
        public final int playbackState;
        public final int playbackSuppressionReason;
        @Nullable
        public final PlaybackException playerError;
        public final int repeatMode;
        public final boolean shuffleModeEnabled;
        public final boolean isLoading;
        public final long seekBackIncrementMs;
        public final long seekForwardIncrementMs;
        public final long maxSeekToPreviousPositionMs;
        public final PlaybackParameters playbackParameters;
        public final TrackSelectionParameters trackSelectionParameters;
        public final AudioAttributes audioAttributes;
        @FloatRange(from=0.0, to=1.0)
        public final float volume;
        public final VideoSize videoSize;
        public final CueGroup currentCues;
        public final DeviceInfo deviceInfo;
        @IntRange(from=0L)
        public final int deviceVolume;
        public final boolean isDeviceMuted;
        public final Size surfaceSize;
        public final boolean newlyRenderedFirstFrame;
        public final Metadata timedMetadata;
        public final ImmutableList<MediaItemData> playlist;
        public final Timeline timeline;
        public final MediaMetadata playlistMetadata;
        public final int currentMediaItemIndex;
        public final int currentAdGroupIndex;
        public final int currentAdIndexInAdGroup;
        public final PositionSupplier contentPositionMsSupplier;
        public final PositionSupplier adPositionMsSupplier;
        public final PositionSupplier contentBufferedPositionMsSupplier;
        public final PositionSupplier adBufferedPositionMsSupplier;
        public final PositionSupplier totalBufferedDurationMsSupplier;
        public final boolean hasPositionDiscontinuity;
        public final int positionDiscontinuityReason;
        public final long discontinuityPositionMs;

        private State(Builder builder) {
            if (builder.timeline.isEmpty()) {
                Assertions.checkArgument(builder.playbackState == 1 || builder.playbackState == 4, "Empty playlist only allowed in STATE_IDLE or STATE_ENDED");
                Assertions.checkArgument(builder.currentAdGroupIndex == -1 && builder.currentAdIndexInAdGroup == -1, "Ads not allowed if playlist is empty");
            } else {
                int mediaItemIndex = builder.currentMediaItemIndex;
                if (mediaItemIndex == -1) {
                    mediaItemIndex = 0;
                } else {
                    Assertions.checkArgument(builder.currentMediaItemIndex < builder.timeline.getWindowCount(), "currentMediaItemIndex must be less than playlist.size()");
                }
                if (builder.currentAdGroupIndex != -1) {
                    Timeline.Period period = new Timeline.Period();
                    Timeline.Window window = new Timeline.Window();
                    long contentPositionMs = builder.contentPositionMs != null ? builder.contentPositionMs.longValue() : builder.contentPositionMsSupplier.get();
                    int periodIndex = SimpleBasePlayer.getPeriodIndexFromWindowPosition(builder.timeline, mediaItemIndex, contentPositionMs, window, period);
                    builder.timeline.getPeriod(periodIndex, period);
                    Assertions.checkArgument(builder.currentAdGroupIndex < period.getAdGroupCount(), "PeriodData has less ad groups than adGroupIndex");
                    int adCountInGroup = period.getAdCountInAdGroup(builder.currentAdGroupIndex);
                    if (adCountInGroup != -1) {
                        Assertions.checkArgument(builder.currentAdIndexInAdGroup < adCountInGroup, "Ad group has less ads than adIndexInGroupIndex");
                    }
                }
            }
            if (builder.playerError != null) {
                Assertions.checkArgument(builder.playbackState == 1, "Player error only allowed in STATE_IDLE");
            }
            if (builder.playbackState == 1 || builder.playbackState == 4) {
                Assertions.checkArgument(!builder.isLoading, "isLoading only allowed when not in STATE_IDLE or STATE_ENDED");
            }
            PositionSupplier contentPositionMsSupplier = builder.contentPositionMsSupplier;
            if (builder.contentPositionMs != null) {
                contentPositionMsSupplier = builder.currentAdGroupIndex == -1 && builder.playWhenReady && builder.playbackState == 3 && builder.playbackSuppressionReason == 0 && builder.contentPositionMs != -9223372036854775807L ? PositionSupplier.getExtrapolating(builder.contentPositionMs, ((Builder)builder).playbackParameters.speed) : PositionSupplier.getConstant(builder.contentPositionMs);
            }
            PositionSupplier adPositionMsSupplier = builder.adPositionMsSupplier;
            if (builder.adPositionMs != null) {
                adPositionMsSupplier = builder.currentAdGroupIndex != -1 && builder.playWhenReady && builder.playbackState == 3 && builder.playbackSuppressionReason == 0 ? PositionSupplier.getExtrapolating(builder.adPositionMs, 1.0f) : PositionSupplier.getConstant(builder.adPositionMs);
            }
            this.availableCommands = builder.availableCommands;
            this.playWhenReady = builder.playWhenReady;
            this.playWhenReadyChangeReason = builder.playWhenReadyChangeReason;
            this.playbackState = builder.playbackState;
            this.playbackSuppressionReason = builder.playbackSuppressionReason;
            this.playerError = builder.playerError;
            this.repeatMode = builder.repeatMode;
            this.shuffleModeEnabled = builder.shuffleModeEnabled;
            this.isLoading = builder.isLoading;
            this.seekBackIncrementMs = builder.seekBackIncrementMs;
            this.seekForwardIncrementMs = builder.seekForwardIncrementMs;
            this.maxSeekToPreviousPositionMs = builder.maxSeekToPreviousPositionMs;
            this.playbackParameters = builder.playbackParameters;
            this.trackSelectionParameters = builder.trackSelectionParameters;
            this.audioAttributes = builder.audioAttributes;
            this.volume = builder.volume;
            this.videoSize = builder.videoSize;
            this.currentCues = builder.currentCues;
            this.deviceInfo = builder.deviceInfo;
            this.deviceVolume = builder.deviceVolume;
            this.isDeviceMuted = builder.isDeviceMuted;
            this.surfaceSize = builder.surfaceSize;
            this.newlyRenderedFirstFrame = builder.newlyRenderedFirstFrame;
            this.timedMetadata = builder.timedMetadata;
            this.playlist = builder.playlist;
            this.timeline = builder.timeline;
            this.playlistMetadata = builder.playlistMetadata;
            this.currentMediaItemIndex = builder.currentMediaItemIndex;
            this.currentAdGroupIndex = builder.currentAdGroupIndex;
            this.currentAdIndexInAdGroup = builder.currentAdIndexInAdGroup;
            this.contentPositionMsSupplier = contentPositionMsSupplier;
            this.adPositionMsSupplier = adPositionMsSupplier;
            this.contentBufferedPositionMsSupplier = builder.contentBufferedPositionMsSupplier;
            this.adBufferedPositionMsSupplier = builder.adBufferedPositionMsSupplier;
            this.totalBufferedDurationMsSupplier = builder.totalBufferedDurationMsSupplier;
            this.hasPositionDiscontinuity = builder.hasPositionDiscontinuity;
            this.positionDiscontinuityReason = builder.positionDiscontinuityReason;
            this.discontinuityPositionMs = builder.discontinuityPositionMs;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State state = (State)o;
            return this.playWhenReady == state.playWhenReady && this.playWhenReadyChangeReason == state.playWhenReadyChangeReason && this.availableCommands.equals(state.availableCommands) && this.playbackState == state.playbackState && this.playbackSuppressionReason == state.playbackSuppressionReason && Util.areEqual(this.playerError, state.playerError) && this.repeatMode == state.repeatMode && this.shuffleModeEnabled == state.shuffleModeEnabled && this.isLoading == state.isLoading && this.seekBackIncrementMs == state.seekBackIncrementMs && this.seekForwardIncrementMs == state.seekForwardIncrementMs && this.maxSeekToPreviousPositionMs == state.maxSeekToPreviousPositionMs && this.playbackParameters.equals(state.playbackParameters) && this.trackSelectionParameters.equals(state.trackSelectionParameters) && this.audioAttributes.equals(state.audioAttributes) && this.volume == state.volume && this.videoSize.equals(state.videoSize) && this.currentCues.equals(state.currentCues) && this.deviceInfo.equals(state.deviceInfo) && this.deviceVolume == state.deviceVolume && this.isDeviceMuted == state.isDeviceMuted && this.surfaceSize.equals(state.surfaceSize) && this.newlyRenderedFirstFrame == state.newlyRenderedFirstFrame && this.timedMetadata.equals(state.timedMetadata) && this.playlist.equals(state.playlist) && this.playlistMetadata.equals(state.playlistMetadata) && this.currentMediaItemIndex == state.currentMediaItemIndex && this.currentAdGroupIndex == state.currentAdGroupIndex && this.currentAdIndexInAdGroup == state.currentAdIndexInAdGroup && this.contentPositionMsSupplier.equals(state.contentPositionMsSupplier) && this.adPositionMsSupplier.equals(state.adPositionMsSupplier) && this.contentBufferedPositionMsSupplier.equals(state.contentBufferedPositionMsSupplier) && this.adBufferedPositionMsSupplier.equals(state.adBufferedPositionMsSupplier) && this.totalBufferedDurationMsSupplier.equals(state.totalBufferedDurationMsSupplier) && this.hasPositionDiscontinuity == state.hasPositionDiscontinuity && this.positionDiscontinuityReason == state.positionDiscontinuityReason && this.discontinuityPositionMs == state.discontinuityPositionMs;
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + this.availableCommands.hashCode();
            result = 31 * result + (this.playWhenReady ? 1 : 0);
            result = 31 * result + this.playWhenReadyChangeReason;
            result = 31 * result + this.playbackState;
            result = 31 * result + this.playbackSuppressionReason;
            result = 31 * result + (this.playerError == null ? 0 : this.playerError.hashCode());
            result = 31 * result + this.repeatMode;
            result = 31 * result + (this.shuffleModeEnabled ? 1 : 0);
            result = 31 * result + (this.isLoading ? 1 : 0);
            result = 31 * result + (int)(this.seekBackIncrementMs ^ this.seekBackIncrementMs >>> 32);
            result = 31 * result + (int)(this.seekForwardIncrementMs ^ this.seekForwardIncrementMs >>> 32);
            result = 31 * result + (int)(this.maxSeekToPreviousPositionMs ^ this.maxSeekToPreviousPositionMs >>> 32);
            result = 31 * result + this.playbackParameters.hashCode();
            result = 31 * result + this.trackSelectionParameters.hashCode();
            result = 31 * result + this.audioAttributes.hashCode();
            result = 31 * result + Float.floatToRawIntBits(this.volume);
            result = 31 * result + this.videoSize.hashCode();
            result = 31 * result + this.currentCues.hashCode();
            result = 31 * result + this.deviceInfo.hashCode();
            result = 31 * result + this.deviceVolume;
            result = 31 * result + (this.isDeviceMuted ? 1 : 0);
            result = 31 * result + this.surfaceSize.hashCode();
            result = 31 * result + (this.newlyRenderedFirstFrame ? 1 : 0);
            result = 31 * result + this.timedMetadata.hashCode();
            result = 31 * result + this.playlist.hashCode();
            result = 31 * result + this.playlistMetadata.hashCode();
            result = 31 * result + this.currentMediaItemIndex;
            result = 31 * result + this.currentAdGroupIndex;
            result = 31 * result + this.currentAdIndexInAdGroup;
            result = 31 * result + this.contentPositionMsSupplier.hashCode();
            result = 31 * result + this.adPositionMsSupplier.hashCode();
            result = 31 * result + this.contentBufferedPositionMsSupplier.hashCode();
            result = 31 * result + this.adBufferedPositionMsSupplier.hashCode();
            result = 31 * result + this.totalBufferedDurationMsSupplier.hashCode();
            result = 31 * result + (this.hasPositionDiscontinuity ? 1 : 0);
            result = 31 * result + this.positionDiscontinuityReason;
            result = 31 * result + (int)(this.discontinuityPositionMs ^ this.discontinuityPositionMs >>> 32);
            return result;
        }

        public static final class Builder {
            private Player.Commands availableCommands;
            private boolean playWhenReady;
            private int playWhenReadyChangeReason;
            private int playbackState;
            private int playbackSuppressionReason;
            @Nullable
            private PlaybackException playerError;
            private int repeatMode;
            private boolean shuffleModeEnabled;
            private boolean isLoading;
            private long seekBackIncrementMs;
            private long seekForwardIncrementMs;
            private long maxSeekToPreviousPositionMs;
            private PlaybackParameters playbackParameters;
            private TrackSelectionParameters trackSelectionParameters;
            private AudioAttributes audioAttributes;
            private float volume;
            private VideoSize videoSize;
            private CueGroup currentCues;
            private DeviceInfo deviceInfo;
            private int deviceVolume;
            private boolean isDeviceMuted;
            private Size surfaceSize;
            private boolean newlyRenderedFirstFrame;
            private Metadata timedMetadata;
            private ImmutableList<MediaItemData> playlist;
            private Timeline timeline;
            private MediaMetadata playlistMetadata;
            private int currentMediaItemIndex;
            private int currentAdGroupIndex;
            private int currentAdIndexInAdGroup;
            @Nullable
            private Long contentPositionMs;
            private PositionSupplier contentPositionMsSupplier;
            @Nullable
            private Long adPositionMs;
            private PositionSupplier adPositionMsSupplier;
            private PositionSupplier contentBufferedPositionMsSupplier;
            private PositionSupplier adBufferedPositionMsSupplier;
            private PositionSupplier totalBufferedDurationMsSupplier;
            private boolean hasPositionDiscontinuity;
            private int positionDiscontinuityReason;
            private long discontinuityPositionMs;

            public Builder() {
                this.availableCommands = Player.Commands.EMPTY;
                this.playWhenReady = false;
                this.playWhenReadyChangeReason = 1;
                this.playbackState = 1;
                this.playbackSuppressionReason = 0;
                this.playerError = null;
                this.repeatMode = 0;
                this.shuffleModeEnabled = false;
                this.isLoading = false;
                this.seekBackIncrementMs = 5000L;
                this.seekForwardIncrementMs = 15000L;
                this.maxSeekToPreviousPositionMs = 3000L;
                this.playbackParameters = PlaybackParameters.DEFAULT;
                this.trackSelectionParameters = TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT;
                this.audioAttributes = AudioAttributes.DEFAULT;
                this.volume = 1.0f;
                this.videoSize = VideoSize.UNKNOWN;
                this.currentCues = CueGroup.EMPTY_TIME_ZERO;
                this.deviceInfo = DeviceInfo.UNKNOWN;
                this.deviceVolume = 0;
                this.isDeviceMuted = false;
                this.surfaceSize = Size.UNKNOWN;
                this.newlyRenderedFirstFrame = false;
                this.timedMetadata = new Metadata(-9223372036854775807L, new Metadata.Entry[0]);
                this.playlist = ImmutableList.of();
                this.timeline = Timeline.EMPTY;
                this.playlistMetadata = MediaMetadata.EMPTY;
                this.currentMediaItemIndex = -1;
                this.currentAdGroupIndex = -1;
                this.currentAdIndexInAdGroup = -1;
                this.contentPositionMs = null;
                this.contentPositionMsSupplier = PositionSupplier.getConstant(-9223372036854775807L);
                this.adPositionMs = null;
                this.adPositionMsSupplier = PositionSupplier.ZERO;
                this.contentBufferedPositionMsSupplier = PositionSupplier.getConstant(-9223372036854775807L);
                this.adBufferedPositionMsSupplier = PositionSupplier.ZERO;
                this.totalBufferedDurationMsSupplier = PositionSupplier.ZERO;
                this.hasPositionDiscontinuity = false;
                this.positionDiscontinuityReason = 5;
                this.discontinuityPositionMs = 0L;
            }

            private Builder(State state) {
                this.availableCommands = state.availableCommands;
                this.playWhenReady = state.playWhenReady;
                this.playWhenReadyChangeReason = state.playWhenReadyChangeReason;
                this.playbackState = state.playbackState;
                this.playbackSuppressionReason = state.playbackSuppressionReason;
                this.playerError = state.playerError;
                this.repeatMode = state.repeatMode;
                this.shuffleModeEnabled = state.shuffleModeEnabled;
                this.isLoading = state.isLoading;
                this.seekBackIncrementMs = state.seekBackIncrementMs;
                this.seekForwardIncrementMs = state.seekForwardIncrementMs;
                this.maxSeekToPreviousPositionMs = state.maxSeekToPreviousPositionMs;
                this.playbackParameters = state.playbackParameters;
                this.trackSelectionParameters = state.trackSelectionParameters;
                this.audioAttributes = state.audioAttributes;
                this.volume = state.volume;
                this.videoSize = state.videoSize;
                this.currentCues = state.currentCues;
                this.deviceInfo = state.deviceInfo;
                this.deviceVolume = state.deviceVolume;
                this.isDeviceMuted = state.isDeviceMuted;
                this.surfaceSize = state.surfaceSize;
                this.newlyRenderedFirstFrame = state.newlyRenderedFirstFrame;
                this.timedMetadata = state.timedMetadata;
                this.playlist = state.playlist;
                this.timeline = state.timeline;
                this.playlistMetadata = state.playlistMetadata;
                this.currentMediaItemIndex = state.currentMediaItemIndex;
                this.currentAdGroupIndex = state.currentAdGroupIndex;
                this.currentAdIndexInAdGroup = state.currentAdIndexInAdGroup;
                this.contentPositionMs = null;
                this.contentPositionMsSupplier = state.contentPositionMsSupplier;
                this.adPositionMs = null;
                this.adPositionMsSupplier = state.adPositionMsSupplier;
                this.contentBufferedPositionMsSupplier = state.contentBufferedPositionMsSupplier;
                this.adBufferedPositionMsSupplier = state.adBufferedPositionMsSupplier;
                this.totalBufferedDurationMsSupplier = state.totalBufferedDurationMsSupplier;
                this.hasPositionDiscontinuity = state.hasPositionDiscontinuity;
                this.positionDiscontinuityReason = state.positionDiscontinuityReason;
                this.discontinuityPositionMs = state.discontinuityPositionMs;
            }

            @CanIgnoreReturnValue
            public Builder setAvailableCommands(Player.Commands availableCommands) {
                this.availableCommands = availableCommands;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlayWhenReady(boolean playWhenReady, int playWhenReadyChangeReason) {
                this.playWhenReady = playWhenReady;
                this.playWhenReadyChangeReason = playWhenReadyChangeReason;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlaybackState(int playbackState) {
                this.playbackState = playbackState;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlaybackSuppressionReason(int playbackSuppressionReason) {
                this.playbackSuppressionReason = playbackSuppressionReason;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlayerError(@Nullable PlaybackException playerError) {
                this.playerError = playerError;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setRepeatMode(int repeatMode) {
                this.repeatMode = repeatMode;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setShuffleModeEnabled(boolean shuffleModeEnabled) {
                this.shuffleModeEnabled = shuffleModeEnabled;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsLoading(boolean isLoading) {
                this.isLoading = isLoading;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSeekBackIncrementMs(long seekBackIncrementMs) {
                this.seekBackIncrementMs = seekBackIncrementMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSeekForwardIncrementMs(long seekForwardIncrementMs) {
                this.seekForwardIncrementMs = seekForwardIncrementMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxSeekToPreviousPositionMs(long maxSeekToPreviousPositionMs) {
                this.maxSeekToPreviousPositionMs = maxSeekToPreviousPositionMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlaybackParameters(PlaybackParameters playbackParameters) {
                this.playbackParameters = playbackParameters;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTrackSelectionParameters(TrackSelectionParameters trackSelectionParameters) {
                this.trackSelectionParameters = trackSelectionParameters;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAudioAttributes(AudioAttributes audioAttributes) {
                this.audioAttributes = audioAttributes;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
                Assertions.checkArgument(volume >= 0.0f && volume <= 1.0f);
                this.volume = volume;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setVideoSize(VideoSize videoSize) {
                this.videoSize = videoSize;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCurrentCues(CueGroup currentCues) {
                this.currentCues = currentCues;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setDeviceInfo(DeviceInfo deviceInfo) {
                this.deviceInfo = deviceInfo;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setDeviceVolume(@IntRange(from=0L) int deviceVolume) {
                Assertions.checkArgument(deviceVolume >= 0);
                this.deviceVolume = deviceVolume;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIsDeviceMuted(boolean isDeviceMuted) {
                this.isDeviceMuted = isDeviceMuted;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSurfaceSize(Size surfaceSize) {
                this.surfaceSize = surfaceSize;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setNewlyRenderedFirstFrame(boolean newlyRenderedFirstFrame) {
                this.newlyRenderedFirstFrame = newlyRenderedFirstFrame;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTimedMetadata(Metadata timedMetadata) {
                this.timedMetadata = timedMetadata;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlaylist(List<MediaItemData> playlist) {
                HashSet<Object> uids = new HashSet<Object>();
                for (int i = 0; i < playlist.size(); ++i) {
                    Assertions.checkArgument(uids.add(playlist.get((int)i).uid), "Duplicate MediaItemData UID in playlist");
                }
                this.playlist = ImmutableList.copyOf(playlist);
                this.timeline = new PlaylistTimeline(this.playlist);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlaylistMetadata(MediaMetadata playlistMetadata) {
                this.playlistMetadata = playlistMetadata;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCurrentMediaItemIndex(int currentMediaItemIndex) {
                this.currentMediaItemIndex = currentMediaItemIndex;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCurrentAd(int adGroupIndex, int adIndexInAdGroup) {
                Assertions.checkArgument(adGroupIndex == -1 == (adIndexInAdGroup == -1));
                this.currentAdGroupIndex = adGroupIndex;
                this.currentAdIndexInAdGroup = adIndexInAdGroup;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setContentPositionMs(long positionMs) {
                this.contentPositionMs = positionMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setContentPositionMs(PositionSupplier contentPositionMsSupplier) {
                this.contentPositionMs = null;
                this.contentPositionMsSupplier = contentPositionMsSupplier;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAdPositionMs(long positionMs) {
                this.adPositionMs = positionMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAdPositionMs(PositionSupplier adPositionMsSupplier) {
                this.adPositionMs = null;
                this.adPositionMsSupplier = adPositionMsSupplier;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setContentBufferedPositionMs(PositionSupplier contentBufferedPositionMsSupplier) {
                this.contentBufferedPositionMsSupplier = contentBufferedPositionMsSupplier;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAdBufferedPositionMs(PositionSupplier adBufferedPositionMsSupplier) {
                this.adBufferedPositionMsSupplier = adBufferedPositionMsSupplier;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTotalBufferedDurationMs(PositionSupplier totalBufferedDurationMsSupplier) {
                this.totalBufferedDurationMsSupplier = totalBufferedDurationMsSupplier;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPositionDiscontinuity(int positionDiscontinuityReason, long discontinuityPositionMs) {
                this.hasPositionDiscontinuity = true;
                this.positionDiscontinuityReason = positionDiscontinuityReason;
                this.discontinuityPositionMs = discontinuityPositionMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder clearPositionDiscontinuity() {
                this.hasPositionDiscontinuity = false;
                return this;
            }

            public State build() {
                return new State(this);
            }
        }
    }
}

