/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;

public final class Metadata
implements Parcelable {
    private final Entry[] entries;
    public final long presentationTimeUs;
    public static final Parcelable.Creator<Metadata> CREATOR = new Parcelable.Creator<Metadata>(){

        public Metadata createFromParcel(Parcel in) {
            return new Metadata(in);
        }

        public Metadata[] newArray(int size) {
            return new Metadata[size];
        }
    };

    public Metadata(Entry ... entries) {
        this(-9223372036854775807L, entries);
    }

    public Metadata(long presentationTimeUs, Entry ... entries) {
        this.presentationTimeUs = presentationTimeUs;
        this.entries = entries;
    }

    public Metadata(List<? extends Entry> entries) {
        this(entries.toArray(new Entry[0]));
    }

    public Metadata(long presentationTimeUs, List<? extends Entry> entries) {
        this(presentationTimeUs, entries.toArray(new Entry[0]));
    }

    Metadata(Parcel in) {
        this.entries = new Entry[in.readInt()];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = (Entry)in.readParcelable(Entry.class.getClassLoader());
        }
        this.presentationTimeUs = in.readLong();
    }

    public int length() {
        return this.entries.length;
    }

    public Entry get(int index) {
        return this.entries[index];
    }

    public Metadata copyWithAppendedEntriesFrom(@Nullable Metadata other) {
        if (other == null) {
            return this;
        }
        return this.copyWithAppendedEntries(other.entries);
    }

    public Metadata copyWithAppendedEntries(Entry ... entriesToAppend) {
        if (entriesToAppend.length == 0) {
            return this;
        }
        return new Metadata(this.presentationTimeUs, Util.nullSafeArrayConcatenation(this.entries, entriesToAppend));
    }

    public Metadata copyWithPresentationTimeUs(long presentationTimeUs) {
        if (this.presentationTimeUs == presentationTimeUs) {
            return this;
        }
        return new Metadata(presentationTimeUs, this.entries);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata other = (Metadata)obj;
        return Arrays.equals(this.entries, other.entries) && this.presentationTimeUs == other.presentationTimeUs;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.entries);
        result = 31 * result + Longs.hashCode((long)this.presentationTimeUs);
        return result;
    }

    public String toString() {
        return "entries=" + Arrays.toString(this.entries) + (this.presentationTimeUs == -9223372036854775807L ? "" : ", presentationTimeUs=" + this.presentationTimeUs);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.entries.length);
        for (Entry entry : this.entries) {
            dest.writeParcelable((Parcelable)entry, 0);
        }
        dest.writeLong(this.presentationTimeUs);
    }

    public static interface Entry
    extends Parcelable {
        @Nullable
        default public Format getWrappedMetadataFormat() {
            return null;
        }

        @Nullable
        default public byte[] getWrappedMetadataBytes() {
            return null;
        }

        default public void populateMediaMetadata(MediaMetadata.Builder builder) {
        }
    }
}

