/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Point;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzqp;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public class zzgy
extends zzhb.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzrN = new Object();
    private final FrameLayout zzGI;
    @Nullable
    private FrameLayout zzsc;
    private Map<String, WeakReference<View>> zzGJ = new HashMap<String, WeakReference<View>>();
    @Nullable
    private zzgn zzGK;
    @Nullable
    private zzgu zzGd;
    boolean zzGL = false;
    int zzGM;
    int zzGN;

    public zzgy(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzGI = frameLayout;
        this.zzsc = frameLayout2;
        zzv.zzdh().zza((View)this.zzGI, this);
        zzv.zzdh().zza((View)this.zzGI, this);
        this.zzGI.setOnTouchListener((View.OnTouchListener)this);
        this.zzGI.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzc(String string2, zzd zzd2) {
        View view = (View)zze.zzE((zzd)zzd2);
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGJ == null) {
                return;
            }
            if (view == null) {
                this.zzGJ.remove(string2);
            } else {
                this.zzGJ.put(string2, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setClickable(true);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzd zzU(String string2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGJ == null) {
                return null;
            }
            WeakReference<View> weakReference = this.zzGJ.get(string2);
            View view = weakReference == null ? null : (View)weakReference.get();
            return zze.zzA(view);
        }
    }

    void zzj(@Nullable View view) {
        zzgu zzgu2;
        if (this.zzGd != null && (zzgu2 = this.zzGd instanceof zzgt ? ((zzgt)this.zzGd).zzfT() : this.zzGd) != null) {
            zzgu2.zzj(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zze(zzd zzd2) {
        Object object = this.zzrN;
        synchronized (object) {
            this.zzj(null);
            Object object2 = zze.zzE((zzd)zzd2);
            if (!(object2 instanceof zzgv)) {
                zzpe.zzbe((String)"Not an instance of native engine. This is most likely a transient error");
                return;
            }
            if (this.zzsc != null) {
                this.zzsc.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                this.zzGI.requestLayout();
            }
            this.zzGL = true;
            final zzgv zzgv2 = (zzgv)object2;
            if (this.zzGd != null && zzfx.zzDV.get().booleanValue()) {
                this.zzGd.zzc((View)this.zzGI, this.zzGJ);
            }
            if (this.zzGd instanceof zzgt && ((zzgt)this.zzGd).zzfS()) {
                ((zzgt)this.zzGd).zzc(zzgv2);
            } else {
                this.zzGd = zzgv2;
                if (zzgv2 instanceof zzgt) {
                    ((zzgt)zzgv2).zzc(null);
                }
            }
            if (zzfx.zzDV.get().booleanValue()) {
                this.zzsc.setClickable(false);
            }
            this.zzsc.removeAllViews();
            this.zzGK = this.zzc(zzgv2);
            if (this.zzGK != null) {
                if (this.zzGJ != null) {
                    this.zzGJ.put("1007", new WeakReference<ViewGroup>(this.zzGK.zzfJ()));
                }
                this.zzsc.addView((View)this.zzGK);
            }
            zzgv2.zza((View)this.zzGI, this.zzGJ, this, this);
            zzpi.zzWR.post(new Runnable(){

                @Override
                public void run() {
                    zzqp zzqp2 = zzgv2.zzfU();
                    if (zzqp2 != null && zzgy.this.zzsc != null) {
                        zzgy.this.zzsc.addView(zzqp2.getView());
                    }
                    if (!(zzgv2 instanceof zzgt)) {
                        zzgy.this.zzd(zzgv2);
                    }
                }
            });
            this.zzj((View)this.zzGI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGd == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("x", this.zzB(this.zzGM));
                jSONObject.put("y", this.zzB(this.zzGN));
            }
            catch (JSONException jSONException) {
                zzpe.zzbe((String)"Unable to get click location");
            }
            if (this.zzGK != null && this.zzGK.zzfJ().equals(view)) {
                if (this.zzGd instanceof zzgt && ((zzgt)this.zzGd).zzfT() != null) {
                    ((zzgt)this.zzGd).zzfT().zza(view, "1007", jSONObject, this.zzGJ, (View)this.zzGI);
                } else {
                    this.zzGd.zza(view, "1007", jSONObject, this.zzGJ, (View)this.zzGI);
                }
            } else {
                this.zzGd.zza(view, this.zzGJ, jSONObject, (View)this.zzGI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGL) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0 && this.zzsc != null) {
                    this.zzsc.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzGL = false;
                }
            }
            if (this.zzGd != null) {
                this.zzGd.zzd((View)this.zzGI, this.zzGJ);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGd != null) {
                this.zzGd.zzd((View)this.zzGI, this.zzGJ);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGd == null) {
                return false;
            }
            Point point = this.zze(motionEvent);
            this.zzGM = point.x;
            this.zzGN = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzGd.zzd(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzsc != null) {
                this.zzsc.removeAllViews();
            }
            this.zzsc = null;
            this.zzGJ = null;
            this.zzGK = null;
            this.zzGd = null;
        }
    }

    Point zze(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzGI.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    @Nullable
    zzgn zzc(zzgv zzgv2) {
        return zzgv2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzGI.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzGI.getMeasuredHeight();
    }

    int zzB(int n) {
        return zzeh.zzeO().zzc(this.zzGd.getContext(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(zzgv zzgv2) {
        Object object = this.zzrN;
        synchronized (object) {
            if (this.zzGJ == null || !this.zzGJ.containsKey("2011")) {
                zzgv2.zzfW();
                return;
            }
            final View view = (View)this.zzGJ.get("2011").get();
            if (!(view instanceof FrameLayout)) {
                zzgv2.zzfW();
                return;
            }
            zzgs zzgs2 = new zzgs(){

                @Override
                public void zzfR() {
                    zzgy.this.onClick(view);
                }

                @Override
                public void zzc(MotionEvent motionEvent) {
                    zzgy.this.onTouch(null, motionEvent);
                }
            };
            zzgv2.zza(view, zzgs2);
        }
    }
}

