/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zznf;
import com.google.android.gms.internal.zznj;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpe;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public final class zzna {
    private static final SimpleDateFormat zzTg = new SimpleDateFormat("yyyyMMdd", Locale.US);

    @Nullable
    public static JSONObject zza(Context context, zzmx zzmx2) {
        zzmh zzmh2 = zzmx2.zzSF;
        Location location = zzmx2.zzyN;
        zznf zznf2 = zzmx2.zzSG;
        Bundle bundle = zzmx2.zzRk;
        JSONObject jSONObject = zzmx2.zzSH;
        try {
            boolean bl;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("extra_caps", zzfx.zzDN.get());
            if (zzmx2.zzRs.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", zzmx2.zzRs));
            }
            if (zzmh2.zzRc != null) {
                hashMap.put("ad_pos", zzmh2.zzRc);
            }
            zzna.zza(hashMap, zzmh2.zzRd);
            if (zzmh2.zzvj.zzzm == null) {
                hashMap.put("format", zzmh2.zzvj.zzzk);
                if (zzmh2.zzvj.zzzo) {
                    hashMap.put("fluid", "height");
                }
            } else {
                boolean bl2 = false;
                bl = false;
                for (zzec zzec2 : zzmh2.zzvj.zzzm) {
                    if (!zzec2.zzzo && !bl2) {
                        hashMap.put("format", zzec2.zzzk);
                        bl2 = true;
                    }
                    if (zzec2.zzzo && !bl) {
                        hashMap.put("fluid", "height");
                        bl = true;
                    }
                    if (bl2 && bl) break;
                }
            }
            if (zzmh2.zzvj.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (zzmh2.zzvj.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (zzmh2.zzvj.zzzm != null) {
                StringBuilder stringBuilder = new StringBuilder();
                bl = false;
                for (zzec zzec2 : zzmh2.zzvj.zzzm) {
                    if (zzec2.zzzo) {
                        bl = true;
                        continue;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(zzec2.width == -1 ? (int)((float)zzec2.widthPixels / zznf2.zzxa) : zzec2.width);
                    stringBuilder.append("x");
                    stringBuilder.append(zzec2.height == -2 ? (int)((float)zzec2.heightPixels / zznf2.zzxa) : zzec2.height);
                }
                if (bl) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.insert(0, "|");
                    }
                    stringBuilder.insert(0, "320x50");
                }
                hashMap.put("sz", stringBuilder);
            }
            if (zzmh2.zzRj != 0) {
                hashMap.put("native_version", zzmh2.zzRj);
                hashMap.put("native_templates", zzmh2.zzvB);
                hashMap.put("native_image_orientation", zzna.zzc(zzmh2.zzvx));
                if (!zzmh2.zzRt.isEmpty()) {
                    hashMap.put("native_custom_templates", zzmh2.zzRt);
                }
            }
            if (zzmh2.zzvj.zzzp) {
                hashMap.put("ene", true);
            }
            hashMap.put("slotname", zzmh2.zzvd);
            hashMap.put("pn", zzmh2.applicationInfo.packageName);
            if (zzmh2.zzRe != null) {
                hashMap.put("vc", zzmh2.zzRe.versionCode);
            }
            hashMap.put("ms", zzmx2.zzRf);
            hashMap.put("seq_num", zzmh2.zzRg);
            hashMap.put("session_id", zzmh2.zzRh);
            hashMap.put("js", zzmh2.zzvf.zzaZ);
            zzna.zza(hashMap, zznf2, zzmx2.zzSD, zzmh2.zzRG, zzmx2.zzSC);
            zzna.zza(hashMap, zzmx2.zzSE);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zzna.zza(hashMap, location);
            } else if (zzmh2.zzRd.versionCode >= 2 && zzmh2.zzRd.zzyN != null) {
                zzna.zza(hashMap, zzmh2.zzRd.zzyN);
            }
            if (zzmh2.versionCode >= 2) {
                hashMap.put("quality_signals", zzmh2.zzRi);
            }
            if (zzmh2.versionCode >= 4 && zzmh2.zzRl) {
                hashMap.put("forceHttps", zzmh2.zzRl);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (zzmh2.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(zzmh2.zzxa));
                hashMap.put("sh", zzmh2.zzRo);
                hashMap.put("sw", zzmh2.zzRn);
            } else {
                hashMap.put("u_sd", Float.valueOf(zznf2.zzxa));
                hashMap.put("sh", zznf2.zzRo);
                hashMap.put("sw", zznf2.zzRn);
            }
            if (zzmh2.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)zzmh2.zzRp)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(zzmh2.zzRp));
                    }
                    catch (JSONException jSONException) {
                        zzpe.zzc((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", zzmh2.zzRq);
            }
            if (zzmh2.versionCode >= 7) {
                hashMap.put("request_id", zzmh2.zzRr);
            }
            if (zzmh2.versionCode >= 11 && zzmh2.zzRv != null) {
                hashMap.put("capability", zzmh2.zzRv.toBundle());
            }
            if (zzmh2.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)zzmh2.zzRw)) {
                hashMap.put("anchor", zzmh2.zzRw);
            }
            if (zzmh2.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(zzmh2.zzRx));
            }
            if (zzmh2.versionCode >= 18) {
                hashMap.put("android_app_muted", zzmh2.zzRD);
            }
            if (zzmh2.versionCode >= 14 && zzmh2.zzRy > 0) {
                hashMap.put("target_api", zzmh2.zzRy);
            }
            if (zzmh2.versionCode >= 15) {
                hashMap.put("scroll_index", zzmh2.zzRz == -1 ? -1 : zzmh2.zzRz);
            }
            if (zzmh2.versionCode >= 16) {
                hashMap.put("_activity_context", zzmh2.zzRA);
            }
            if (zzmh2.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)zzmh2.zzRE)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(zzmh2.zzRE));
                    }
                    catch (JSONException jSONException) {
                        zzpe.zzc((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", zzmh2.zzKc);
            }
            if (zzmh2.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", zzmh2.zzRF);
            }
            zzna.zza(hashMap);
            hashMap.put("cache_state", jSONObject);
            if (zzmh2.versionCode >= 19) {
                hashMap.put("gct", zzmh2.zzRH);
            }
            if (zzpe.zzai((int)2)) {
                String string2 = zzv.zzcJ().zzP(hashMap).toString(2);
                String string3 = String.valueOf(string2);
                zzpe.v(string3.length() != 0 ? "Ad Request JSON: ".concat(string3) : new String("Ad Request JSON: "));
            }
            return zzv.zzcJ().zzP(hashMap);
        }
        catch (JSONException jSONException) {
            String string4 = String.valueOf(jSONException.getMessage());
            zzpe.zzbe((String)(string4.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string4) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap) {
        Bundle bundle = new Bundle();
        Bundle bundle2 = new Bundle();
        bundle2.putString("cl", "139965458");
        bundle2.putString("rapid_rc", "dev");
        bundle2.putString("rapid_rollup", "HEAD");
        bundle.putBundle("build_meta", bundle2);
        bundle.putString("mf", Boolean.toString(zzfx.zzDP.get()));
        hashMap.put("sdk_env", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", string2);
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, zzdy zzdy2) {
        String string2 = zzpc.zzke();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (zzdy2.zzyF != -1L) {
            hashMap.put("cust_age", zzTg.format(new Date(zzdy2.zzyF)));
        }
        if (zzdy2.extras != null) {
            hashMap.put("extras", zzdy2.extras);
        }
        if (zzdy2.zzyG != -1) {
            hashMap.put("cust_gender", zzdy2.zzyG);
        }
        if (zzdy2.zzyH != null) {
            hashMap.put("kw", zzdy2.zzyH);
        }
        if (zzdy2.zzyJ != -1) {
            hashMap.put("tag_for_child_directed_treatment", zzdy2.zzyJ);
        }
        if (zzdy2.zzyI) {
            hashMap.put("adtest", "on");
        }
        if (zzdy2.versionCode >= 2) {
            if (zzdy2.zzyK) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)zzdy2.zzyL)) {
                hashMap.put("ppid", zzdy2.zzyL);
            }
            if (zzdy2.zzyM != null) {
                zzna.zza(hashMap, zzdy2.zzyM);
            }
        }
        if (zzdy2.versionCode >= 3 && zzdy2.zzyO != null) {
            hashMap.put("url", zzdy2.zzyO);
        }
        if (zzdy2.versionCode >= 5) {
            if (zzdy2.zzyQ != null) {
                hashMap.put("custom_targeting", zzdy2.zzyQ);
            }
            if (zzdy2.zzyR != null) {
                hashMap.put("category_exclusions", zzdy2.zzyR);
            }
            if (zzdy2.zzyS != null) {
                hashMap.put("request_agent", zzdy2.zzyS);
            }
        }
        if (zzdy2.versionCode >= 6 && zzdy2.zzyT != null) {
            hashMap.put("request_pkg", zzdy2.zzyT);
        }
        if (zzdy2.versionCode >= 7) {
            hashMap.put("is_designed_for_families", zzdy2.zzyU);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zznf zznf2, zznj.zza zza2, Bundle bundle, Bundle bundle2) {
        Bundle bundle3;
        hashMap.put("am", zznf2.zzUa);
        hashMap.put("cog", zzna.zzB(zznf2.zzUb));
        hashMap.put("coh", zzna.zzB(zznf2.zzUc));
        if (!TextUtils.isEmpty((CharSequence)zznf2.zzUd)) {
            hashMap.put("carrier", zznf2.zzUd);
        }
        hashMap.put("gl", zznf2.zzUe);
        if (zznf2.zzUf) {
            hashMap.put("simulator", 1);
        }
        if (zznf2.zzUg) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzna.zzB(zznf2.zzUh));
        hashMap.put("sp", zzna.zzB(zznf2.zzUi));
        hashMap.put("hl", zznf2.zzUj);
        if (!TextUtils.isEmpty((CharSequence)zznf2.zzUk)) {
            hashMap.put("mv", zznf2.zzUk);
        }
        hashMap.put("muv", zznf2.zzUl);
        if (zznf2.zzUm != -2) {
            hashMap.put("cnt", zznf2.zzUm);
        }
        hashMap.put("gnt", zznf2.zzUn);
        hashMap.put("pt", zznf2.zzUo);
        hashMap.put("rm", zznf2.zzUp);
        hashMap.put("riv", zznf2.zzUq);
        Bundle bundle4 = new Bundle();
        bundle4.putString("build", zznf2.zzUv);
        Bundle bundle5 = new Bundle();
        bundle5.putBoolean("is_charging", zznf2.zzUs);
        bundle5.putDouble("battery_level", zznf2.zzUr);
        bundle4.putBundle("battery", bundle5);
        Bundle bundle6 = new Bundle();
        bundle6.putInt("active_network_state", zznf2.zzUu);
        bundle6.putBoolean("active_network_metered", zznf2.zzUt);
        if (zza2 != null) {
            bundle3 = new Bundle();
            bundle3.putInt("predicted_latency_micros", zza2.zzUA);
            bundle3.putLong("predicted_down_throughput_bps", zza2.zzUB);
            bundle3.putLong("predicted_up_throughput_bps", zza2.zzUC);
            bundle6.putBundle("predictions", bundle3);
        }
        bundle4.putBundle("network", bundle6);
        bundle3 = new Bundle();
        bundle3.putBoolean("is_browser_custom_tabs_capable", zznf2.zzUw);
        bundle4.putBundle("browser", bundle3);
        if (bundle != null) {
            bundle4.putBundle("android_mem_info", zzna.zzg(bundle));
        }
        Bundle bundle7 = new Bundle();
        bundle7.putBundle("parental_controls", bundle2);
        bundle4.putBundle("play_store", bundle7);
        hashMap.put("device", bundle4);
    }

    private static Bundle zzg(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, zzfj zzfj2) {
        String string2;
        String string3;
        if (Color.alpha((int)zzfj2.zzAr) != 0) {
            hashMap.put("acolor", zzna.zzZ(zzfj2.zzAr));
        }
        if (Color.alpha((int)zzfj2.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzna.zzZ(zzfj2.backgroundColor));
        }
        if (Color.alpha((int)zzfj2.zzAs) != 0 && Color.alpha((int)zzfj2.zzAt) != 0) {
            hashMap.put("gradientto", zzna.zzZ(zzfj2.zzAs));
            hashMap.put("gradientfrom", zzna.zzZ(zzfj2.zzAt));
        }
        if (Color.alpha((int)zzfj2.zzAu) != 0) {
            hashMap.put("bcolor", zzna.zzZ(zzfj2.zzAu));
        }
        hashMap.put("bthick", Integer.toString(zzfj2.zzAv));
        switch (zzfj2.zzAw) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (zzfj2.zzAx) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (zzfj2.zzAy != null) {
            hashMap.put("channel", zzfj2.zzAy);
        }
        if (Color.alpha((int)zzfj2.zzAz) != 0) {
            hashMap.put("dcolor", zzna.zzZ(zzfj2.zzAz));
        }
        if (zzfj2.zzAA != null) {
            hashMap.put("font", zzfj2.zzAA);
        }
        if (Color.alpha((int)zzfj2.zzAB) != 0) {
            hashMap.put("hcolor", zzna.zzZ(zzfj2.zzAB));
        }
        hashMap.put("headersize", Integer.toString(zzfj2.zzAC));
        if (zzfj2.zzAD != null) {
            hashMap.put("q", zzfj2.zzAD);
        }
    }

    private static Integer zzB(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzZ(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(zzgw zzgw2) {
        int n = zzgw2 != null ? zzgw2.zzGE : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static zzmk zza(Context context, zzmh zzmh2, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_slot_size", string5);
            boolean bl = zzmh2 != null && zzmh2.zzRj != 0;
            String string7 = jSONObject.optString("ad_json", null);
            if (string7 == null) {
                string7 = jSONObject.optString("ad_html", null);
            }
            if (string7 == null) {
                string7 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string8 = jSONObject.optString("debug_dialog", null);
            String string9 = jSONObject.optString("debug_signals", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string10 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string10)) {
                n = zzv.zzcL().zzkq();
            } else if ("landscape".equals(string10)) {
                n = zzv.zzcL().zzkp();
            }
            zzmk zzmk2 = null;
            if (TextUtils.isEmpty((CharSequence)string7) && !TextUtils.isEmpty((CharSequence)string4)) {
                zzmk2 = zzmz.zza(zzmh2, context, zzmh2.zzvf.zzaZ, string4, null, null, null, null);
                string3 = zzmk2.zzNb;
                string7 = zzmk2.body;
                l = zzmk2.zzRO;
            }
            if (string7 == null) {
                return new zzmk(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = zzmk2 == null ? null : zzmk2.zzJY;
            if (jSONArray != null) {
                list3 = zzna.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = zzmk2 == null ? null : zzmk2.zzJZ;
            if (jSONArray2 != null) {
                list2 = zzna.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = zzmk2 == null ? null : zzmk2.zzRM;
            if (jSONArray3 != null) {
                list = zzna.zza(jSONArray3, list);
            }
            if (zzmk2 != null) {
                if (zzmk2.orientation != -1) {
                    n = zzmk2.orientation;
                }
                if (zzmk2.zzRJ > 0L) {
                    l2 = zzmk2.zzRJ;
                }
            }
            String string11 = jSONObject.optString("active_view");
            String string12 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string12 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("content_vertical_opted_out", true);
            boolean bl7 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string13 = jSONObject.optString("gws_query_id", "");
            boolean bl8 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl9 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zzna.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zzna.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            zzok zzok2 = zzok.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl10 = jSONObject.optBoolean("use_displayed_impression", false);
            zzmm zzmm2 = zzmm.zzg(jSONObject.optJSONObject("auto_protection_configuration"));
            String string14 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zzna.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            zzon zzon2 = zzon.zzi(jSONObject.optJSONObject("safe_browsing"));
            boolean bl11 = jSONObject.optBoolean("render_in_browser", zzmh2.zzKc);
            return new zzmk(zzmh2, string3, string7, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string8, bl2, string12, string11, bl4, bl, zzmh2.zzRl, bl5, bl7, string13, bl8, bl9, zzok2, list7, list8, bl10, zzmm2, zzmh2.zzRB, string14, list9, bl11, string6, zzon2, string9, bl6);
        }
        catch (JSONException jSONException) {
            String string15 = String.valueOf(jSONException.getMessage());
            zzpe.zzbe((String)(string15.length() != 0 ? "Could not parse the inline ad response: ".concat(string15) : new String("Could not parse the inline ad response: ")));
            return new zzmk(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(zzmk zzmk2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (zzmk2.zzNb != null) {
            jSONObject.put("ad_base_url", (Object)zzmk2.zzNb);
        }
        if (zzmk2.zzRN != null) {
            jSONObject.put("ad_size", (Object)zzmk2.zzRN);
        }
        jSONObject.put("native", zzmk2.zzzn);
        if (zzmk2.zzzn) {
            jSONObject.put("ad_json", (Object)zzmk2.body);
        } else {
            jSONObject.put("ad_html", (Object)zzmk2.body);
        }
        if (zzmk2.zzRP != null) {
            jSONObject.put("debug_dialog", (Object)zzmk2.zzRP);
        }
        if (zzmk2.zzSg != null) {
            jSONObject.put("debug_signals", (Object)zzmk2.zzSg);
        }
        if (zzmk2.zzRJ != -1L) {
            jSONObject.put("interstitial_timeout", (double)zzmk2.zzRJ / 1000.0);
        }
        if (zzmk2.orientation == zzv.zzcL().zzkq()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (zzmk2.orientation == zzv.zzcL().zzkp()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (zzmk2.zzJY != null) {
            jSONObject.put("click_urls", (Object)zzna.zzl(zzmk2.zzJY));
        }
        if (zzmk2.zzJZ != null) {
            jSONObject.put("impression_urls", (Object)zzna.zzl(zzmk2.zzJZ));
        }
        if (zzmk2.zzRM != null) {
            jSONObject.put("manual_impression_urls", (Object)zzna.zzl(zzmk2.zzRM));
        }
        if (zzmk2.zzRS != null) {
            jSONObject.put("active_view", (Object)zzmk2.zzRS);
        }
        jSONObject.put("ad_is_javascript", zzmk2.zzRQ);
        if (zzmk2.zzRR != null) {
            jSONObject.put("ad_passback_url", (Object)zzmk2.zzRR);
        }
        jSONObject.put("mediation", zzmk2.zzRK);
        jSONObject.put("custom_render_allowed", zzmk2.zzRT);
        jSONObject.put("content_url_opted_out", zzmk2.zzRU);
        jSONObject.put("content_vertical_opted_out", zzmk2.zzSh);
        jSONObject.put("prefetch", zzmk2.zzRV);
        if (zzmk2.zzKe != -1L) {
            jSONObject.put("refresh_interval_milliseconds", zzmk2.zzKe);
        }
        if (zzmk2.zzRL != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", zzmk2.zzRL);
        }
        if (!TextUtils.isEmpty((CharSequence)zzmk2.zzRY)) {
            jSONObject.put("gws_query_id", (Object)zzmk2.zzRY);
        }
        jSONObject.put("fluid", (Object)(zzmk2.zzzo ? "height" : ""));
        jSONObject.put("native_express", zzmk2.zzzp);
        if (zzmk2.zzSa != null) {
            jSONObject.put("video_start_urls", (Object)zzna.zzl(zzmk2.zzSa));
        }
        if (zzmk2.zzSb != null) {
            jSONObject.put("video_complete_urls", (Object)zzna.zzl(zzmk2.zzSb));
        }
        if (zzmk2.zzRZ != null) {
            jSONObject.put("rewards", (Object)zzmk2.zzRZ.zzjy());
        }
        jSONObject.put("use_displayed_impression", zzmk2.zzSc);
        jSONObject.put("auto_protection_configuration", (Object)zzmk2.zzSd);
        jSONObject.put("render_in_browser", zzmk2.zzKc);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzl(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

