/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.UiModeManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzaef;
import com.google.android.gms.internal.ads.zzafs;
import com.google.android.gms.internal.ads.zzahs;
import com.google.android.gms.internal.ads.zzfeg;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzjq;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzaht {
    public static final int zza;
    public static final String zzb;
    public static final String zzc;
    public static final String zzd;
    public static final String zze;
    public static final byte[] zzf;
    private static final Pattern zzg;
    private static final Pattern zzh;
    private static final Pattern zzi;
    private static final Pattern zzj;
    @Nullable
    private static HashMap<String, String> zzk;
    private static final String[] zzl;
    private static final String[] zzm;
    private static final int[] zzn;
    private static final int[] zzo;

    public static byte[] zza(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean zzb(Uri object) {
        return TextUtils.isEmpty((CharSequence)(object = object.getScheme())) || "file".equals(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzc(@Nullable Object object, @Nullable Object object2) {
        if (object != null) return object.equals(object2);
        if (object2 == null) return true;
        return false;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T zzd(@Nullable T t) {
        return t;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[] zze(T[] TArray) {
        return TArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T[] zzf(T[] TArray, int n) {
        boolean bl = n <= TArray.length;
        zzafs.zza(bl);
        return Arrays.copyOf(TArray, n);
    }

    public static <T> T[] zzg(T[] TArray, T[] TArray2) {
        int n = TArray.length;
        int n2 = TArray2.length;
        TArray = Arrays.copyOf(TArray, n + n2);
        System.arraycopy(TArray2, 0, TArray, n, n2);
        return TArray;
    }

    public static Handler zzh(@Nullable Handler.Callback callback) {
        Looper looper = Looper.myLooper();
        zzafs.zzf(looper);
        Handler handler = new Handler(looper, callback);
        return handler;
    }

    public static Handler zzi(Looper looper, @Nullable Handler.Callback callback) {
        Handler handler = new Handler(looper, callback);
        return handler;
    }

    public static boolean zzj(Handler handler, Runnable runnable) {
        if (!handler.getLooper().getThread().isAlive()) {
            return false;
        }
        if (handler.getLooper() == Looper.myLooper()) {
            runnable.run();
            return true;
        }
        return handler.post(runnable);
    }

    public static Looper zzk() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            return looper;
        }
        return Looper.getMainLooper();
    }

    public static ExecutorService zzl(String object) {
        object = new zzahs("ExoPlayer:Loader:ProgressiveMediaPeriod");
        return Executors.newSingleThreadExecutor((ThreadFactory)object);
    }

    public static void zzm(@Nullable zzaef zzaef2) {
        try {
            zzaef2.zzf();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static boolean zzn(Parcel parcel) {
        return parcel.readInt() != 0;
    }

    public static void zzo(Parcel parcel, boolean bl) {
        parcel.writeInt(bl ? 1 : 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String zzp(String string2) {
        String string3;
        if (string2 == null) {
            return null;
        }
        String string4 = string2.replace('_', '-');
        if (!string4.isEmpty() && !string4.equals("und")) {
            string2 = string4;
        }
        string2 = zzaht.zzu(string2);
        string4 = string2.split("-", 2)[0];
        if (zzk == null) {
            zzk = zzaht.zzY();
        }
        if ((string3 = zzk.get(string4)) != null) {
            string2 = (string2 = String.valueOf(string2.substring(string4.length()))).length() != 0 ? string3.concat(string2) : new String(string3);
            string4 = string3;
        }
        if (!"no".equals(string4) && !"i".equals(string4)) {
            if (!"zh".equals(string4)) return string2;
        }
        int n = 0;
        while (true) {
            int cfr_ignored_0 = zzm.length;
            if (n >= 18) return string2;
            if (string2.startsWith(zzm[n])) {
                string3 = String.valueOf(zzm[n + 1]);
                if ((string2 = String.valueOf(string2.substring(zzm[n].length()))).length() == 0) return new String(string3);
                return string3.concat(string2);
            }
            n += 2;
        }
    }

    public static String zzq(byte[] byArray, int n, int n2) {
        String string2 = new String(byArray, n, n2, zzfeg.zzc);
        return string2;
    }

    public static byte[] zzr(String string2) {
        return string2.getBytes(zzfeg.zzc);
    }

    public static String[] zzs(String string2, String string3) {
        return string2.split(",", -1);
    }

    public static String[] zzt(String string2, String string3) {
        return string2.split(string3, 2);
    }

    public static String zzu(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.toLowerCase(Locale.US);
    }

    public static String zzv(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.toUpperCase(Locale.US);
    }

    public static String zzw(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static int zzx(int n, int n2) {
        return (n + n2 + -1) / n2;
    }

    public static int zzy(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n, n3));
    }

    public static long zzz(long l, long l2, long l3) {
        return Math.max(l2, Math.min(l, l3));
    }

    public static float zzA(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f, f3));
    }

    public static long zzB(long l, long l2, long l3) {
        long l4 = l + l2;
        if (((l ^ l4) & (l2 ^ l4)) < 0L) {
            return Long.MAX_VALUE;
        }
        return l4;
    }

    public static long zzC(long l, long l2, long l3) {
        long l4 = l - l2;
        if (((l ^ l2) & (l ^ l4)) < 0L) {
            return Long.MIN_VALUE;
        }
        return l4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zzD(int[] nArray, int n, boolean n2, boolean bl) {
        n2 = Arrays.binarySearch(nArray, n);
        if (n2 < 0) {
            return -(n2 + 2);
        }
        do {
            if (--n2 < 0) return n2;
        } while (nArray[n2] == n);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzE(long[] lArray, long l, boolean n, boolean bl) {
        int n2;
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            n2 = -(n + 2);
        } else {
            while (--n >= 0 && lArray[n] == l) {
            }
            n2 = n + 1;
        }
        if (bl) {
            return Math.max(0, n2);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zzF(long[] lArray, long l, boolean bl, boolean n) {
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            return ~n;
        }
        while (++n < lArray.length && lArray[n] == l) {
        }
        if (bl) return n + -1;
        return n;
    }

    public static long zzG(long l, long l2, long l3) {
        if (l3 < l2 || l3 % l2 != 0L) {
            if (l3 < l2 && l2 % l3 == 0L) {
                return l * (l2 / l3);
            }
            return (long)((double)l * ((double)l2 / (double)l3));
        }
        return l / (l3 / l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzH(long[] lArray, long l, long l2) {
        if (l2 >= 1000000L && l2 % 1000000L == 0L) {
            long l3 = l2 / 1000000L;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = lArray[i] / l3;
            }
            return;
        } else if (l2 < 1000000L && 1000000L % l2 == 0L) {
            long l4 = 1000000L / l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = lArray[i] * l4;
            }
            return;
        } else {
            double d = 1000000.0 / (double)l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = (long)((double)lArray[i] * d);
            }
        }
    }

    public static long zzI(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l * (double)f);
    }

    public static long zzJ(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l / (double)f);
    }

    public static long zzK(int n, int n2) {
        return ((long)n & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static String zzL(Object[] objectArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < (n = objectArray.length); ++i) {
            stringBuilder.append(objectArray[i].getClass().getSimpleName());
            if (i >= n + -1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static zzjq zzM(int n, int n2, int n3) {
        zzjp zzjp2 = new zzjp();
        zzjp2.zzj("audio/raw");
        zzjp2.zzw(n2);
        zzjp2.zzx(n3);
        zzjp2.zzy(n);
        return zzjp2.zzD();
    }

    public static int zzN(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 32: {
                return 0x30000000;
            }
            case 24: {
                return 0x20000000;
            }
            case 16: {
                return 2;
            }
            case 8: 
        }
        return 3;
    }

    public static boolean zzO(int n) {
        return n == 3 || n == 2 || n == 0x10000000 || n == 0x20000000 || n == 0x30000000 || n == 4;
    }

    public static boolean zzP(int n) {
        return n == 0x20000000 || n == 0x30000000 || n == 4;
    }

    public static int zzQ(int n) {
        switch (n) {
            case 8: {
                if (zza >= 23) {
                    return 6396;
                }
                if (zza >= 21) {
                    return 6396;
                }
                return 0;
            }
            default: {
                return 0;
            }
            case 7: {
                return 1276;
            }
            case 6: {
                return 252;
            }
            case 5: {
                return 220;
            }
            case 4: {
                return 204;
            }
            case 3: {
                return 28;
            }
            case 2: {
                return 12;
            }
            case 1: 
        }
        return 4;
    }

    public static int zzR(int n, int n2) {
        switch (n) {
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                throw illegalArgumentException;
            }
            case 0x20000000: {
                return n2 * 3;
            }
            case 4: 
            case 0x30000000: {
                return n2 * 4;
            }
            case 3: {
                return n2;
            }
            case 2: 
            case 0x10000000: 
        }
        return n2 + n2;
    }

    public static int zzS(byte[] byArray, int n, int n2, int n3) {
        n = -1;
        for (n3 = 0; n3 < n2; ++n3) {
            n = n << 8 ^ zzn[n >>> 24 ^ byArray[n3] & 0xFF];
        }
        return n;
    }

    public static int zzT(byte[] byArray, int n, int n2, int n3) {
        n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = zzo[n3 ^ byArray[i] & 0xFF];
        }
        return n3;
    }

    public static String zzU(@Nullable Context object) {
        if (object != null && (object = (TelephonyManager)object.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(object = object.getNetworkCountryIso()))) {
            return zzaht.zzv((String)object);
        }
        return zzaht.zzv(Locale.getDefault().getCountry());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] zzV() {
        Object object = Resources.getSystem().getConfiguration();
        if (zza >= 24) {
            object = zzaht.zzs(object.getLocales().toLanguageTags(), ",");
        } else {
            String[] stringArray = new String[1];
            object = ((Configuration)object).locale;
            object = zza >= 21 ? ((Locale)object).toLanguageTag() : ((Locale)object).toString();
            stringArray[0] = object;
            object = stringArray;
        }
        int n = 0;
        while (n < ((String[])object).length) {
            object[n] = zzaht.zzp((String)object[n]);
            ++n;
        }
        return object;
    }

    public static boolean zzW(Context context) {
        return (context = (UiModeManager)context.getApplicationContext().getSystemService("uimode")) != null && context.getCurrentModeType() == 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long zzX(long l) {
        if (l != -9223372036854775807L) return SystemClock.elapsedRealtime() + l;
        return System.currentTimeMillis();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap<String, String> zzY() {
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int cfr_ignored_0 = zzl.length;
        HashMap<String, String> hashMap = new HashMap<String, String>(n + 86);
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 < n) {
                    String string2 = stringArray[n2];
                    Object object = new Locale(string2);
                    object = ((Locale)object).getISO3Language();
                    boolean bl = TextUtils.isEmpty((CharSequence)object);
                    if (!bl) {
                        hashMap.put((String)object, string2);
                    }
                    break block7;
                }
                n2 = 0;
                while (true) {
                    int cfr_ignored_1 = zzl.length;
                    if (n2 >= 86) {
                        return hashMap;
                    }
                    hashMap.put(zzl[n2], zzl[n2 + 1]);
                    n2 += 2;
                }
                catch (MissingResourceException missingResourceException) {}
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static {
        void var0_1;
        if ("S".equals(Build.VERSION.CODENAME)) {
            int n = 31;
        } else if ("R".equals(Build.VERSION.CODENAME)) {
            int n = 30;
        } else {
            int n = Build.VERSION.SDK_INT;
        }
        zza = var0_1;
        zzb = Build.DEVICE;
        zzc = Build.MANUFACTURER;
        zzd = Build.MODEL;
        String string2 = zzb;
        String string3 = zzd;
        String string4 = zzc;
        int n = zza;
        String string5 = String.valueOf(string2);
        int n2 = string5.length();
        String string6 = String.valueOf(string3);
        int n3 = string6.length();
        String string7 = String.valueOf(string4);
        int n4 = string7.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 17 + n3 + n4);
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(string4);
        stringBuilder.append(", ");
        stringBuilder.append(n);
        zze = stringBuilder.toString();
        zzf = new byte[0];
        zzg = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
        zzh = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
        zzi = Pattern.compile("%([A-Fa-f0-9]{2})");
        zzj = Pattern.compile(".*\\.isml?(?:/(manifest(.*))?)?");
        String[] stringArray = new String[]{"alb", "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        zzl = stringArray;
        String[] stringArray2 = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        zzm = stringArray2;
        int[] nArray = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
        zzn = nArray;
        int[] nArray2 = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
        zzo = nArray2;
    }
}

