/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbdj;
import com.google.android.gms.internal.ads.zzbht;
import com.google.android.gms.internal.ads.zzbih;
import com.google.android.gms.internal.ads.zzbnx;
import com.google.android.gms.internal.ads.zzbob;
import com.google.android.gms.internal.ads.zzcdm;
import com.google.android.gms.internal.ads.zzcsn;
import com.google.android.gms.internal.ads.zzdgu;
import com.google.android.gms.internal.ads.zzdgz;
import com.google.android.gms.internal.ads.zzdkt;
import com.google.android.gms.internal.ads.zzdku;
import com.google.android.gms.internal.ads.zzfdx;
import java.util.Collections;

public final class zzdkv
extends zzbnx
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbht {
    private View zza;
    private zzbdj zzb;
    private zzdgu zzc;
    private boolean zzd;
    private boolean zze;

    public zzdkv(zzdgu zzdgu2, zzdgz zzdgz2) {
        this.zza = zzdgz2.zzH();
        this.zzb = zzdgz2.zzw();
        this.zzc = zzdgu2;
        this.zzd = false;
        this.zze = false;
        if (zzdgz2.zzR() != null) {
            zzdgz2.zzR().zzaw(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(IObjectWrapper object, zzbob zzbob2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdkv)object2).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad can not be shown after destroy().");
            zzdkv.zzi(zzbob2, 2);
            return;
        }
        View view = ((zzdkv)object2).zza;
        if (view == null || ((zzdkv)object2).zzb == null) {
            Object object2 = view == null ? "can not get video view." : "can not get video controller.";
            object = "Instream internal error: ";
            object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
            com.google.android.gms.ads.internal.util.zze.zzf((String)object2);
            zzdkv.zzi(zzbob2, 0);
            return;
        }
        if (((zzdkv)object2).zze) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad should not be used again.");
            zzdkv.zzi(zzbob2, 1);
            return;
        }
        ((zzdkv)object2).zze = true;
        super.zzg();
        object = ObjectWrapper.unwrap((IObjectWrapper)object);
        object = (ViewGroup)object;
        view = ((zzdkv)object2).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        object.addView(view, layoutParams);
        zzs.zzz();
        zzcdm.zza(((zzdkv)object2).zza, (ViewTreeObserver.OnGlobalLayoutListener)object2);
        zzs.zzz();
        zzcdm.zzb(((zzdkv)object2).zza, (ViewTreeObserver.OnScrollChangedListener)object2);
        super.zzh();
        try {
            zzbob2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzdku zzdku2 = new zzdku(this);
        this.zzd(iObjectWrapper, (zzbob)zzdku2);
    }

    public final zzbdj zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    public final zzbih zzf() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdgu zzdgu2 = this.zzc;
        if (zzdgu2 != null && zzdgu2.zzF() != null) {
            return this.zzc.zzF().zza();
        }
        return null;
    }

    public final void zzc() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzg();
        zzdgu zzdgu2 = this.zzc;
        if (zzdgu2 != null) {
            ((zzcsn)zzdgu2).zzR();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzh();
    }

    public final void onScrollChanged() {
        this.zzh();
    }

    @Override
    public final void zza() {
        zzfdx zzfdx2 = zzr.zza;
        zzdkt zzdkt2 = new zzdkt(this);
        zzfdx2.post((Runnable)zzdkt2);
    }

    private final void zzh() {
        View view;
        zzdgu zzdgu2 = this.zzc;
        if (zzdgu2 != null && (view = this.zza) != null) {
            zzdgu2.zzp(view, Collections.emptyMap(), Collections.emptyMap(), zzdgu.zzz(this.zza));
            return;
        }
    }

    private static final void zzi(zzbob zzbob2, int n) {
        try {
            zzbob2.zzf(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

