/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.appset;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.appset.AppSetClient;
import com.google.android.gms.appset.AppSetInfo;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.appset.zza;
import com.google.android.gms.internal.appset.zzc;
import com.google.android.gms.internal.appset.zzd;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class zze
implements AppSetClient {
    @GuardedBy(value="InternalAppSetAppSideClientImpl.class")
    @Nullable
    private static AppSetClient zza = null;
    private final Context zzb;
    private boolean zzc = false;
    private final ScheduledExecutorService zzd = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService zze = Executors.newSingleThreadExecutor();

    @VisibleForTesting
    protected final long zza() {
        long l = com.google.android.gms.internal.appset.zze.zzf(this.zzb).getLong("app_set_id_last_used_time", -1L);
        if (l != -1L) {
            return l + 33696000000L;
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ Context zzb(zze zze2) {
        return zze2.zzb;
    }

    @NonNull
    public static synchronized AppSetClient zzc(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context, (Object)"Context must not be null");
        if (zza == null) {
            zze zze2 = new zze(context.getApplicationContext());
            zza = zze2;
        }
        return zza;
    }

    @Override
    public final Task<AppSetInfo> getAppSetInfo() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ExecutorService executorService = this.zze;
        zza zza2 = new zza(this, taskCompletionSource);
        executorService.execute(zza2);
        return taskCompletionSource.getTask();
    }

    zze(Context object) {
        this.zzb = object;
        if (!this.zzc) {
            object = this.zzd;
            zzc zzc2 = new zzc(this, null);
            object.scheduleAtFixedRate(zzc2, 0L, 86400L, TimeUnit.SECONDS);
            this.zzc = true;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final /* synthetic */ void zzd(TaskCompletionSource var1_3) {
        block14: {
            block9: {
                block8: {
                    block13: {
                        block11: {
                            block12: {
                                block10: {
                                    var2_4 = com.google.android.gms.internal.appset.zze.zzf(this.zzb).getString("app_set_id", null);
                                    var3_5 = this.zza();
                                    if (var2_4 != null && DefaultClock.getInstance().currentTimeMillis() <= var3_5) break block9;
                                    var2_4 = UUID.randomUUID().toString();
                                    var5_6 = this.zzb;
                                    var6_9 = com.google.android.gms.internal.appset.zze.zzf((Context)var5_6).edit().putString("app_set_id", (String)var2_4).commit();
                                    if (var6_9 != 0) break block10;
                                    var2_4 = "AppSet";
                                    this = "Failed to store app set ID generated for App ";
                                    var6_9 = (var5_6 = String.valueOf(var5_6.getPackageName())).length();
                                    if (var6_9 == 0) ** GOTO lbl-1000
                                    this = this.concat((String)var5_6);
                                    break block11;
                                }
                                com.google.android.gms.internal.appset.zze.zzg((Context)var5_6);
                                this = this.zzb;
                                var5_6 = com.google.android.gms.internal.appset.zze.zzf((Context)this);
                                var6_10 = DefaultClock.getInstance();
                                var7_12 = var6_10.currentTimeMillis();
                                var5_7 = var5_6.edit().putLong("app_set_id_creation_time", var7_12).commit();
                                if (var5_7) break block12;
                                var2_4 = "AppSet";
                                var5_8 = "Failed to store app set ID creation time for App ";
                                var6_11 = (this = String.valueOf(this.getPackageName())).length();
                                if (var6_11 == 0) ** GOTO lbl64
                                this = var5_8.concat((String)this);
                                break block13;
                            }
                            this = var2_4;
                            break block8;
                        }
lbl33:
                        // 2 sources

                        while (true) {
                            Log.e((String)var2_4, (String)this);
                            this = new zzd("Failed to store the app set ID.");
                            throw this;
                        }
                    }
lbl39:
                    // 2 sources

                    while (true) {
                        Log.e((String)var2_4, (String)this);
                        this = new zzd("Failed to store the app set ID creation time.");
                        throw this;
                    }
                }
lbl45:
                // 2 sources

                while (true) {
                    var2_4 = new AppSetInfo((String)this, 1);
                    var1_3.setResult(var2_4);
                    return;
                }
            }
            try {}
            catch (zzd var0_2) {
                var1_3.setException((Exception)var0_2);
                return;
            }
            break block14;
            catch (zzd var0_1) {
                var1_3.setException((Exception)var0_1);
                return;
            }
        }
        com.google.android.gms.internal.appset.zze.zzg(this.zzb);
        this = var2_4;
        ** while (true)
lbl-1000:
        // 1 sources

        {
            this = var5_6 = new String((String)this);
            ** continue;
lbl64:
            // 1 sources

            this = new String(var5_8);
            ** continue;
        }
    }

    private static final SharedPreferences zzf(Context context) {
        return context.getSharedPreferences("app_set_id_storage", 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    protected static final void zze(Context object) {
        String string;
        if (!com.google.android.gms.internal.appset.zze.zzf((Context)object).edit().remove("app_set_id").commit()) {
            string = String.valueOf(object.getPackageName());
            String string2 = "Failed to clear app set ID generated for App ";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            Log.e((String)"AppSet", (String)string);
        }
        if (com.google.android.gms.internal.appset.zze.zzf((Context)object).edit().remove("app_set_id_last_used_time").commit()) {
            return;
        }
        object = String.valueOf(object.getPackageName());
        string = "Failed to clear app set ID last used time for App ";
        object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
        Log.e((String)"AppSet", (String)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzg(Context object) throws zzd {
        Object object2 = com.google.android.gms.internal.appset.zze.zzf((Context)object);
        Clock clock = DefaultClock.getInstance();
        long l = clock.currentTimeMillis();
        if (object2.edit().putLong("app_set_id_last_used_time", l).commit()) {
            return;
        }
        object = String.valueOf(object.getPackageName());
        object2 = "Failed to store app set ID last used time for App ";
        object = ((String)object).length() != 0 ? ((String)object2).concat((String)object) : new String((String)object2);
        Log.e((String)"AppSet", (String)object);
        object = new zzd("Failed to store the app set ID last used time.");
        throw object;
    }
}

