/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zza
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzalX = new Scope("profile");
    public static final Scope zzalY = new Scope("email");
    public static final Scope zzalZ = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzd();
    private int versionCode;
    private final ArrayList<Scope> zzama;
    private Account zzajd;
    private boolean zzalj;
    private final boolean zzamb;
    private final boolean zzamc;
    private String zzalk;
    private String zzamd;
    private ArrayList<zzn> zzame;
    private Map<Integer, zzn> zzamf;
    private static Comparator<Scope> zzalW = new zzc();

    @Nullable
    public static GoogleSignInOptions zzbQ(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzw(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzama = arrayList;
        this.zzajd = account;
        this.zzalj = bl;
        this.zzamb = bl2;
        this.zzamc = bl3;
        this.zzalk = string2;
        this.zzamd = string3;
        this.zzame = new ArrayList<zzn>(map.values());
        this.zzamf = map;
    }

    public final ArrayList<Scope> zzmy() {
        return new ArrayList<Scope>(this.zzama);
    }

    public Scope[] getScopeArray() {
        return this.zzama.toArray(new Scope[this.zzama.size()]);
    }

    public final Account getAccount() {
        return this.zzajd;
    }

    public final boolean isIdTokenRequested() {
        return this.zzalj;
    }

    public final boolean zzmz() {
        return this.zzamb;
    }

    public final String getServerClientId() {
        return this.zzalk;
    }

    private static Map<Integer, zzn> zzw(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzmy(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzajd, (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzalj);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzamb);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzamc);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzalk, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzamd, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzame, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzame.size() > 0 || googleSignInOptions.zzame.size() > 0) {
                return false;
            }
            if (this.zzama.size() != googleSignInOptions.zzmy().size() || !this.zzama.containsAll(googleSignInOptions.zzmy())) {
                return false;
            }
            return (this.zzajd == null ? googleSignInOptions.zzajd == null : this.zzajd.equals((Object)googleSignInOptions.zzajd)) && (TextUtils.isEmpty((CharSequence)this.zzalk) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzalk) : this.zzalk.equals(googleSignInOptions.zzalk)) && this.zzamc == googleSignInOptions.zzamc && this.zzalj == googleSignInOptions.zzalj && this.zzamb == googleSignInOptions.zzamb;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzama;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzpn());
        }
        Collections.sort(arrayList);
        return new zzo().zzo(arrayList).zzo(this.zzajd).zzo(this.zzalk).zzP(this.zzamc).zzP(this.zzalj).zzP(this.zzamb).zzmH();
    }

    public final String zzmA() {
        return this.zzmx().toString();
    }

    private final JSONObject zzmx() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzama, zzalW);
            ArrayList<Scope> arrayList = this.zzama;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzpn());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzajd != null) {
                jSONObject.put("accountName", (Object)this.zzajd.name);
            }
            jSONObject.put("idTokenRequested", this.zzalj);
            jSONObject.put("forceCodeForRefreshToken", this.zzamc);
            jSONObject.put("serverAuthRequested", this.zzamb);
            if (!TextUtils.isEmpty((CharSequence)this.zzalk)) {
                jSONObject.put("serverClientId", (Object)this.zzalk);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzamd)) {
                jSONObject.put("hostedDomain", (Object)this.zzamd);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzc zzc2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzamg = new HashSet<Scope>();
        private boolean zzamb;
        private boolean zzamc;
        private boolean zzalj;
        private String zzalk;
        private Account zzajd;
        private String zzamd;
        private Map<Integer, zzn> zzamh = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbr.zzu((Object)googleSignInOptions);
            this.zzamg = new HashSet<Scope>(googleSignInOptions.zzama);
            this.zzamb = googleSignInOptions.zzamb;
            this.zzamc = googleSignInOptions.zzamc;
            this.zzalj = googleSignInOptions.zzalj;
            this.zzalk = googleSignInOptions.zzalk;
            this.zzajd = googleSignInOptions.zzajd;
            this.zzamd = googleSignInOptions.zzamd;
            this.zzamh = GoogleSignInOptions.zzw(googleSignInOptions.zzame);
        }

        public final Builder requestId() {
            this.zzamg.add(zzalZ);
            return this;
        }

        public final Builder requestEmail() {
            this.zzamg.add(zzalY);
            return this;
        }

        public final Builder requestProfile() {
            this.zzamg.add(zzalX);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzamg.add(scope);
            this.zzamg.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzalj = true;
            this.zzalk = this.zzbR(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzamb = true;
            this.zzalk = this.zzbR(string2);
            this.zzamc = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzajd = new Account(zzbr.zzcF((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzamd = zzbr.zzcF((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzamh.containsKey(1)) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            this.zzamh.put(1, new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzalj && (this.zzajd == null || !this.zzamg.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzamg), this.zzajd, this.zzalj, this.zzamb, this.zzamc, this.zzalk, this.zzamd, this.zzamh, null);
        }

        private final String zzbR(String string2) {
            zzbr.zzcF((String)string2);
            zzbr.zzb((this.zzalk == null || this.zzalk.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

