/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.data.zzf;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzc;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@KeepName
public final class DataHolder
extends com.google.android.gms.common.internal.safeparcel.zza
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zzf();
    private int zzakw;
    private final String[] zzaFD;
    private Bundle zzaFE;
    private final CursorWindow[] zzaFF;
    private final int zzaxw;
    private final Bundle zzaFG;
    private int[] zzaFH;
    int zzaFI;
    private boolean mClosed = false;
    private boolean zzaFJ = true;
    private static final zza zzaFK = new zze(new String[0], null);

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.zzakw = n;
        this.zzaFD = stringArray;
        this.zzaFF = cursorWindowArray;
        this.zzaxw = n2;
        this.zzaFG = bundle;
    }

    private DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzakw = 1;
        this.zzaFD = (String[])zzbr.zzu((Object)stringArray);
        this.zzaFF = (CursorWindow[])zzbr.zzu((Object)cursorWindowArray);
        this.zzaxw = n;
        this.zzaFG = bundle;
        this.zzqP();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzaFD, DataHolder.zza(zza2, -1), n, null);
    }

    public final void zzqP() {
        int n;
        this.zzaFE = new Bundle();
        for (n = 0; n < this.zzaFD.length; ++n) {
            this.zzaFE.putInt(this.zzaFD[n], n);
        }
        this.zzaFH = new int[this.zzaFF.length];
        n = 0;
        for (int i = 0; i < this.zzaFF.length; ++i) {
            this.zzaFH[i] = n;
            int n2 = this.zzaFF[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzaFF[i].getNumRows() - n3;
        }
        this.zzaFI = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String[])dataHolder.zzaFD, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zzaFF, (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)dataHolder.zzaxw);
        zzd.zza((Parcel)parcel2, (int)4, (Bundle)dataHolder.zzaFG, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)dataHolder.zzakw);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final int getStatusCode() {
        return this.zzaxw;
    }

    public final Bundle zzqL() {
        return this.zzaFG;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzaFD.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = zza2.zzaFL;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzaFD.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzaFD.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                }
                Map map = (Map)arrayList.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzaFD.length && bl2; ++n3) {
                    String string2 = zza2.zzaFD[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzaFD.length);
                    arrayList2.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList2.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private final void zzh(String string2, int n) {
        if (this.zzaFE == null || !this.zzaFE.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzaFI) {
            throw new CursorIndexOutOfBoundsException(n, this.zzaFI);
        }
    }

    public final boolean zzcv(String string2) {
        return this.zzaFE.containsKey(string2);
    }

    public final long zzb(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzaFF[n2].getLong(n, this.zzaFE.getInt(string2));
    }

    public final int zzc(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzaFF[n2].getInt(n, this.zzaFE.getInt(string2));
    }

    public final String zzd(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzaFF[n2].getString(n, this.zzaFE.getInt(string2));
    }

    public final boolean zze(String string2, int n, int n2) {
        this.zzh(string2, n);
        return Long.valueOf(this.zzaFF[n2].getLong(n, this.zzaFE.getInt(string2))) == 1L;
    }

    public final float zzf(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzaFF[n2].getFloat(n, this.zzaFE.getInt(string2));
    }

    public final byte[] zzg(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzaFF[n2].getBlob(n, this.zzaFE.getInt(string2));
    }

    public final void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzh(string2, n);
        this.zzaFF[n2].copyStringToBuffer(n, this.zzaFE.getInt(string2), charArrayBuffer);
    }

    public final boolean zzh(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzaFF[n2].isNull(n, this.zzaFE.getInt(string2));
    }

    public final int getCount() {
        return this.zzaFI;
    }

    public final int zzat(int n) {
        int n2;
        zzbr.zzae((n >= 0 && n < this.zzaFI ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzaFH.length; ++n2) {
            if (n >= this.zzaFH[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzaFH.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzaFF.length; ++i) {
                    this.zzaFF[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zzaFJ && this.zzaFF.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = String.valueOf(this.toString());
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public static zza zza(String[] stringArray) {
        return new zza(stringArray, null, null);
    }

    public static DataHolder zzau(int n) {
        int n2 = n;
        return new DataHolder(zzaFK, n2, null);
    }

    /* synthetic */ DataHolder(zza zza2, int n, Bundle bundle, zze zze2) {
        this(zza2, 0, null);
    }

    public static final class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzaFD;
        private final ArrayList<HashMap<String, Object>> zzaFL;
        private final String zzaFM;
        private final HashMap<Object, Integer> zzaFN;
        private boolean zzaFO;
        private String zzaFP;

        private zza(String[] stringArray, String string2) {
            this.zzaFD = (String[])zzbr.zzu((Object)stringArray);
            this.zzaFL = new ArrayList();
            this.zzaFM = string2;
            this.zzaFN = new HashMap();
            this.zzaFO = false;
            this.zzaFP = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            zzc.zzr(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            zza zza2 = this;
            if (zza2.zzaFM == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(zza2.zzaFM);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = zza2.zzaFN.get(object);
                    if (n3 == null) {
                        zza2.zzaFN.put(object, zza2.zzaFL.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zzaFL.add(hashMap);
            } else {
                this.zzaFL.remove(n);
                this.zzaFL.add(n, hashMap);
            }
            this.zzaFO = false;
            return this;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzr((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public final DataHolder zzav(int n) {
            return new DataHolder(this, 0, null, null);
        }

        /* synthetic */ zza(String[] stringArray, String string2, zze zze2) {
            this(stringArray, null);
        }
    }
}

