/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zze;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zza {
    public static final Parcelable.Creator<WebImage> CREATOR = new zze();
    private int zzakw;
    private final Uri zzauS;
    private final int zzrZ;
    private final int zzsa;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zzakw = n;
        this.zzauS = uri;
        this.zzrZ = n2;
        this.zzsa = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzp(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzp(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public final Uri getUrl() {
        return this.zzauS;
    }

    public final int getWidth() {
        return this.zzrZ;
    }

    public final int getHeight() {
        return this.zzsa;
    }

    public final String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzrZ, this.zzsa, this.zzauS.toString());
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzauS.toString());
            jSONObject.put("width", this.zzrZ);
            jSONObject.put("height", this.zzsa);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzbh.equal((Object)this.zzauS, (Object)webImage.zzauS) && this.zzrZ == webImage.zzrZ && this.zzsa == webImage.zzsa;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzauS, this.zzrZ, this.zzsa});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WebImage webImage = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)webImage.zzakw);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)webImage.getUrl(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)webImage.getWidth());
        zzd.zzc((Parcel)parcel2, (int)4, (int)webImage.getHeight());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

