/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcu;
import com.google.android.gms.internal.zzbcx;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbcz;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbfb;
import com.google.android.gms.internal.zzbfu;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.internal.zzcux;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzbcw
implements zzbfb {
    private final Context mContext;
    private final zzbeb zzaCn;
    private final Looper zzrP;
    private final zzbej zzaCo;
    private final zzbej zzaCp;
    private final Map<Api.zzc<?>, zzbej> zzaCq;
    private final Set<zzbfu> zzaCr = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzaCs;
    private Bundle zzaCt;
    private ConnectionResult zzaCu = null;
    private ConnectionResult zzaCv = null;
    private boolean zzaCw = false;
    private final Lock zzaCx;
    private int zzaCy = 0;

    public static zzbcw zza(Context context, zzbeb zzbeb2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcuw, zzcux> zza2, ArrayList<zzbcu> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzmE()) {
                zze3 = object;
            }
            if (object.zzmt()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbr.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzpb();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzbcu>();
        ArrayList<zzbcu> arrayList2 = new ArrayList<zzbcu>();
        ArrayList<zzbcu> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzbcu zzbcu2 = arrayList3.get(i);
            zzbcu zzbcu3 = zzbcu2;
            if (arrayMap5.containsKey(zzbcu3.zzayY)) {
                ((ArrayList)object).add(zzbcu3);
                continue;
            }
            if (arrayMap.containsKey(zzbcu3.zzayY)) {
                arrayList2.add(zzbcu3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzbcw(context, zzbeb2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzq2, zza2, zze3, (ArrayList<zzbcu>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzbcw(Context context, zzbeb zzbeb2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzq zzq2, Api.zza<? extends zzcuw, zzcux> zza2, Api.zze zze3, ArrayList<zzbcu> arrayList, ArrayList<zzbcu> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzaCn = zzbeb2;
        this.zzaCx = lock;
        this.zzrP = looper;
        this.zzaCs = zze3;
        this.zzaCo = new zzbej(context, this.zzaCn, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzbcy(this, null));
        this.zzaCp = new zzbej(context, this.zzaCn, lock, looper, zze2, map, zzq2, map3, zza2, arrayList, new zzbcz(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaCo);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaCp);
        }
        this.zzaCq = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbck<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzpF()) {
                t.zzr(new Status(4, null, this.zzpG()));
                return t;
            }
            return this.zzaCp.zzd(t);
        }
        return this.zzaCo.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzpF()) {
                t.zzr(new Status(4, null, this.zzpG()));
                return t;
            }
            return this.zzaCp.zze(t);
        }
        return this.zzaCo.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzaCq.get(api.zzpb()).equals(this.zzaCp)) {
            if (this.zzpF()) {
                return new ConnectionResult(4, this.zzpG());
            }
            return this.zzaCp.getConnectionResult(api);
        }
        return this.zzaCo.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzaCy = 2;
        this.zzaCw = false;
        zzbcw zzbcw2 = this;
        this.zzaCv = null;
        zzbcw2.zzaCu = null;
        zzbcw2.zzaCo.connect();
        zzbcw2.zzaCp.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzaCv = null;
        this.zzaCu = null;
        this.zzaCy = 0;
        this.zzaCo.disconnect();
        this.zzaCp.disconnect();
        this.zzpE();
    }

    @Override
    public final boolean isConnected() {
        this.zzaCx.lock();
        try {
            boolean bl = this.zzaCo.isConnected() && (this.zzaCp.isConnected() || this.zzpF() || this.zzaCy == 1);
            return bl;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzaCx.lock();
        try {
            boolean bl = this.zzaCy == 2;
            return bl;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final boolean zza(zzbfu zzbfu2) {
        this.zzaCx.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzaCp.isConnected()) {
                this.zzaCr.add(zzbfu2);
                if (this.zzaCy == 0) {
                    this.zzaCy = 1;
                }
                this.zzaCv = null;
                this.zzaCp.connect();
                return true;
            }
        }
        finally {
            this.zzaCx.unlock();
        }
        return false;
    }

    @Override
    public final void zzpC() {
        this.zzaCo.zzpC();
        this.zzaCp.zzpC();
    }

    @Override
    public final void zzpj() {
        this.zzaCx.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzaCp.disconnect();
            this.zzaCv = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzrP).post((Runnable)new zzbcx(this));
            } else {
                this.zzpE();
            }
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    private final void zzpD() {
        if (zzbcw.zzb(this.zzaCu)) {
            if (zzbcw.zzb(this.zzaCv) || this.zzpF()) {
                zzbcw zzbcw2 = this;
                switch (zzbcw2.zzaCy) {
                    case 2: {
                        zzbcw2.zzaCn.zzm(zzbcw2.zzaCt);
                    }
                    case 1: {
                        zzbcw2.zzpE();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzbcw2.zzaCy = 0;
                return;
            }
            if (this.zzaCv != null) {
                if (this.zzaCy == 1) {
                    this.zzpE();
                    return;
                }
                this.zza(this.zzaCv);
                this.zzaCo.disconnect();
                return;
            }
        } else {
            if (this.zzaCu != null && zzbcw.zzb(this.zzaCv)) {
                this.zzaCp.disconnect();
                this.zza(this.zzaCu);
                return;
            }
            if (this.zzaCu != null && this.zzaCv != null) {
                ConnectionResult connectionResult = this.zzaCu;
                if (this.zzaCp.zzaDZ < this.zzaCo.zzaDZ) {
                    connectionResult = this.zzaCv;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzaCy) {
            case 2: {
                this.zzaCn.zzc(connectionResult);
            }
            case 1: {
                this.zzpE();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzaCy = 0;
    }

    private final void zzpE() {
        Iterator<zzbfu> iterator = this.zzaCr.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzmD();
        }
        this.zzaCr.clear();
    }

    private final void zzd(int n, boolean bl) {
        this.zzaCn.zze(n, bl);
        this.zzaCv = null;
        this.zzaCu = null;
    }

    private final boolean zzpF() {
        return this.zzaCv != null && this.zzaCv.getErrorCode() == 4;
    }

    private final boolean zzf(zzbck<? extends Result, ? extends Api.zzb> zzbck2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzbck2.zzpb();
        zzbr.zzb((boolean)this.zzaCq.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzaCq.get(zzc2).equals(this.zzaCp);
    }

    @Nullable
    private final PendingIntent zzpG() {
        if (this.zzaCs == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzaCn), (Intent)this.zzaCs.zzmF(), (int)0x8000000);
    }

    private final void zzl(Bundle bundle) {
        if (this.zzaCt == null) {
            this.zzaCt = bundle;
            return;
        }
        if (bundle != null) {
            this.zzaCt.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzaCp.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzaCo.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzbcw zzbcw2) {
        return zzbcw2.zzaCx;
    }

    static /* synthetic */ void zzb(zzbcw zzbcw2) {
        zzbcw2.zzpD();
    }

    static /* synthetic */ void zza(zzbcw zzbcw2, Bundle bundle) {
        zzbcw2.zzl(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzbcw zzbcw2, ConnectionResult connectionResult) {
        zzbcw2.zzaCu = connectionResult;
        return zzbcw2.zzaCu;
    }

    static /* synthetic */ boolean zzc(zzbcw zzbcw2) {
        return zzbcw2.zzaCw;
    }

    static /* synthetic */ ConnectionResult zzd(zzbcw zzbcw2) {
        return zzbcw2.zzaCv;
    }

    static /* synthetic */ boolean zza(zzbcw zzbcw2, boolean bl) {
        zzbcw2.zzaCw = bl;
        return zzbcw2.zzaCw;
    }

    static /* synthetic */ void zza(zzbcw zzbcw2, int n, boolean bl) {
        zzbcw2.zzd(n, bl);
    }

    static /* synthetic */ zzbej zze(zzbcw zzbcw2) {
        return zzbcw2.zzaCp;
    }

    static /* synthetic */ ConnectionResult zzb(zzbcw zzbcw2, ConnectionResult connectionResult) {
        zzbcw2.zzaCv = connectionResult;
        return zzbcw2.zzaCv;
    }

    static /* synthetic */ zzbej zzf(zzbcw zzbcw2) {
        return zzbcw2.zzaCo;
    }
}

