/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbfs;
import com.google.android.gms.internal.zzbgf;
import com.google.android.gms.internal.zzbgg;
import java.lang.ref.WeakReference;

public final class zzbge<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzaFc = null;
    private zzbge<? extends Result> zzaFd = null;
    private volatile ResultCallbacks<? super R> zzaFe = null;
    private PendingResult<R> zzaFf = null;
    private final Object zzaBY = new Object();
    private Status zzaFg = null;
    private final WeakReference<GoogleApiClient> zzaCa;
    private final zzbgg zzaFh;
    private boolean zzaFi = false;

    public zzbge(WeakReference<GoogleApiClient> weakReference) {
        zzbr.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzaCa = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaCa.get();
        this.zzaFh = new zzbgg(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzaBY;
        synchronized (object) {
            zzbr.zza((this.zzaFc == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbr.zza((this.zzaFe == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaFc = resultTransform;
            zzbge<R> zzbge2 = new zzbge<R>(this.zzaCa);
            this.zzaFd = zzbge2;
            this.zzqH();
            return zzbge2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzaBY;
        synchronized (object) {
            zzbr.zza((this.zzaFe == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbr.zza((this.zzaFc == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaFe = resultCallbacks;
            this.zzqH();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzaBY;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzaFc != null) {
                    zzbfs.zzqh().submit(new zzbgf(this, (Result)r));
                } else if (this.zzqJ()) {
                    this.zzaFe.onSuccess(r);
                }
            } else {
                this.zzv(r.getStatus());
                zzbge.zzc(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzaBY;
        synchronized (object) {
            this.zzaFf = pendingResult;
            this.zzqH();
            return;
        }
    }

    private final void zzqH() {
        if (this.zzaFc == null && this.zzaFe == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaCa.get();
        if (!this.zzaFi && this.zzaFc != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzaFi = true;
        }
        if (this.zzaFg != null) {
            this.zzw(this.zzaFg);
            return;
        }
        if (this.zzaFf != null) {
            this.zzaFf.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzv(Status status) {
        Object object = this.zzaBY;
        synchronized (object) {
            this.zzaFg = status;
            this.zzw(this.zzaFg);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzw(Status status) {
        Object object = this.zzaBY;
        synchronized (object) {
            if (this.zzaFc != null) {
                Status status2 = this.zzaFc.onFailure(status);
                zzbr.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzv(status2);
            } else if (this.zzqJ()) {
                this.zzaFe.onFailure(status);
            }
            return;
        }
    }

    final void zzqI() {
        this.zzaFe = null;
    }

    private final boolean zzqJ() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaCa.get();
        return this.zzaFe != null && googleApiClient != null;
    }

    private static void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzbge zzbge2) {
        return zzbge2.zzaFc;
    }

    static /* synthetic */ zzbgg zzd(zzbge zzbge2) {
        return zzbge2.zzaFh;
    }

    static /* synthetic */ void zza(zzbge zzbge2, Result result) {
        zzbge.zzc(result);
    }

    static /* synthetic */ WeakReference zze(zzbge zzbge2) {
        return zzbge2.zzaCa;
    }

    static /* synthetic */ Object zzf(zzbge zzbge2) {
        return zzbge2.zzaBY;
    }

    static /* synthetic */ zzbge zzg(zzbge zzbge2) {
        return zzbge2.zzaFd;
    }

    static /* synthetic */ void zza(zzbge zzbge2, Status status) {
        zzbge2.zzv(status);
    }
}

