/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzbar;
import com.google.android.gms.internal.zzbas;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdc;
import com.google.android.gms.internal.zzbdi;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzayW;
    private final O zzaAJ;
    private final zzbas<O> zzaAK;
    private final Looper zzrO;
    private final int mId;
    private final GoogleApiClient zzaAL;
    private final zzbel zzaAM;
    private final Account zzajb;
    protected final zzbda zzaAN;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbo.zzb((Object)context, (Object)"Null context is not permitted.");
        zzbo.zzb(api, (Object)"Api must not be null.");
        zzbo.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzayW = api;
        this.zzaAJ = null;
        this.zzrO = looper;
        this.zzaAK = zzbas.zzb(api);
        this.zzaAL = new zzbdi(this);
        this.zzaAN = zzbda.zzay(this.mContext);
        this.mId = this.zzaAN.zzqm();
        this.zzaAM = new zzbar();
        this.zzajb = null;
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzbel zzbel2) {
        this(context, api, null, new zzd().zza(looper).zza(zzbel2).zzpj());
    }

    @MainThread
    private GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbo.zzb((Object)activity, (Object)"Null activity is not permitted.");
        zzbo.zzb(api, (Object)"Api must not be null.");
        zzbo.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzayW = api;
        this.zzaAJ = null;
        this.zzrO = zza2.zzaAQ;
        this.zzaAK = zzbas.zza(this.zzayW, this.zzaAJ);
        this.zzaAL = new zzbdi(this);
        this.zzaAN = zzbda.zzay(this.mContext);
        this.mId = this.zzaAN.zzqm();
        this.zzaAM = zza2.zzaAP;
        this.zzajb = zza2.account;
        zzbbv.zza(activity, this.zzaAN, this.zzaAK);
        this.zzaAN.zzb(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbo.zzb((Object)context, (Object)"Null context is not permitted.");
        zzbo.zzb(api, (Object)"Api must not be null.");
        zzbo.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzayW = api;
        this.zzaAJ = o;
        this.zzrO = zza2.zzaAQ;
        this.zzaAK = zzbas.zza(this.zzayW, this.zzaAJ);
        this.zzaAL = new zzbdi(this);
        this.zzaAN = zzbda.zzay(this.mContext);
        this.mId = this.zzaAN.zzqm();
        this.zzaAM = zza2.zzaAP;
        this.zzajb = zza2.account;
        this.zzaAN.zzb(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzbel zzbel2) {
        this(activity, api, null, new zzd().zza(zzbel2).zza(activity.getMainLooper()).zzpj());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzbel zzbel2) {
        this(context, api, o, new zzd().zza(zzbel2).zzpj());
    }

    private final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzpC();
        this.zzaAN.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzbep<A, TResult> zzbep2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzaAN.zza(this, n, zzbep2, taskCompletionSource, this.zzaAM);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzbep<A, TResult> zzbep2) {
        return this.zza(0, zzbep2);
    }

    public final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzbep<A, TResult> zzbep2) {
        return this.zza(1, zzbep2);
    }

    public final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbdc<O> zzbdc2) {
        zzq zzq2 = new GoogleApiClient.Builder(this.mContext).zze(this.zzajb).zzpn();
        return this.zzayW.zzpc().zza(this.mContext, looper, zzq2, this.zzaAJ, zzbdc2, zzbdc2);
    }

    public final Api<O> zzpg() {
        return this.zzayW;
    }

    public final zzbas<O> zzph() {
        return this.zzaAK;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzpi() {
        return this.zzaAL;
    }

    public final Looper getLooper() {
        return this.zzrO;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    public zzbei zza(Context context, Handler handler) {
        return new zzbei(context, handler);
    }

    public static final class zza {
        public static final zza zzaAO = new zzd().zzpj();
        public final zzbel zzaAP;
        public final Account account;
        public final Looper zzaAQ;

        private zza(zzbel zzbel2, Account account, Looper looper) {
            this.zzaAP = zzbel2;
            this.account = account;
            this.zzaAQ = looper;
        }

        /* synthetic */ zza(zzbel zzbel2, Account account, Looper looper, zzc zzc2) {
            this(zzbel2, null, looper);
        }
    }
}

