/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbt;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzbv;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzcw;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzby;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbr<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzx {
    private final Queue<zza> zzfnv = new LinkedList<zza>();
    private final Api.zze zzfkh;
    private final Api.zzb zzfnw;
    private final zzh<O> zzfgs;
    private final zzah zzfnx;
    private final Set<zzj> zzfny = new HashSet<zzj>();
    private final Map<zzcl<?>, zzcs> zzfnz = new HashMap();
    private final int zzfoa;
    private final zzcw zzfob;
    private boolean zzfmi;
    private ConnectionResult zzfoc = null;
    private /* synthetic */ zzbp zzfnu;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbr(zzbp zzbp2, GoogleApi googleApi) {
        this.zzfnu = zzbp2;
        this.zzfkh = googleApi.zza(zzbp.zza(zzbp2).getLooper(), this);
        this.zzfnw = this.zzfkh instanceof zzby ? zzby.zzako() : this.zzfkh;
        this.zzfgs = googleApi.zzafk();
        this.zzfnx = new zzah();
        this.zzfoa = googleApi.getInstanceId();
        if (this.zzfkh.zzaac()) {
            this.zzfob = googleApi.zza(zzbp.zzb(zzbp2), zzbp.zza(zzbp2));
            return;
        }
        this.zzfob = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbp.zza(this.zzfnu).getLooper()) {
            this.zzahu();
            return;
        }
        zzbp.zza(this.zzfnu).post((Runnable)new zzbs(this));
    }

    @WorkerThread
    private final void zzahu() {
        this.zzahx();
        this.zzi(ConnectionResult.zzfff);
        this.zzahz();
        for (zzcs zzcs2 : this.zzfnz.values()) {
            try {
                zzcs2.zzfid.zzb(this.zzfnw, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfkh.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbr zzbr2 = this;
        while (zzbr2.zzfkh.isConnected() && !zzbr2.zzfnv.isEmpty()) {
            zza zza2 = zzbr2.zzfnv.remove();
            zzbr2.zzb(zza2);
        }
        this.zzaia();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbp.zza(this.zzfnu).getLooper()) {
            this.zzahv();
            return;
        }
        zzbp.zza(this.zzfnu).post((Runnable)new zzbt(this));
    }

    @WorkerThread
    private final void zzahv() {
        this.zzahx();
        this.zzfmi = true;
        this.zzfnx.zzagu();
        zzbp.zza(this.zzfnu).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfnu), (int)9, this.zzfgs), zzbp.zzc(this.zzfnu));
        zzbp.zza(this.zzfnu).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfnu), (int)11, this.zzfgs), zzbp.zzd(this.zzfnu));
        zzbp.zza(this.zzfnu, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        this.zzfkh.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbp.zza(this.zzfnu).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbp.zza(this.zzfnu).post((Runnable)new zzbu(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        if (this.zzfob != null) {
            this.zzfob.zzaim();
        }
        this.zzahx();
        zzbp.zza(this.zzfnu, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzv(zzbp.zzahs());
            return;
        }
        if (this.zzfnv.isEmpty()) {
            this.zzfoc = connectionResult;
            return;
        }
        Object object = zzbp.zzaht();
        synchronized (object) {
            if (zzbp.zze(this.zzfnu) != null && zzbp.zzf(this.zzfnu).contains(this.zzfgs)) {
                zzbp.zze(this.zzfnu).zzb(connectionResult, this.zzfoa);
                return;
            }
        }
        if (!this.zzfnu.zzc(connectionResult, this.zzfoa)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfmi = true;
            }
            if (this.zzfmi) {
                zzbp.zza(this.zzfnu).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfnu), (int)9, this.zzfgs), zzbp.zzc(this.zzfnu));
                return;
            }
            object = this.zzfgs.zzafv();
            this.zzv(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        if (this.zzfkh.isConnected()) {
            this.zzb(zza2);
            this.zzaia();
            return;
        }
        this.zzfnv.add(zza2);
        if (this.zzfoc != null && this.zzfoc.hasResolution()) {
            this.onConnectionFailed(this.zzfoc);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        this.zzv(zzbp.zzfnk);
        this.zzfnx.zzagt();
        for (zzcl<?> zzcl2 : this.zzfnz.keySet()) {
            this.zza(new zzf(zzcl2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzfkh.disconnect();
    }

    public final Api.zze zzagn() {
        return this.zzfkh;
    }

    public final Map<zzcl<?>, zzcs> zzahw() {
        return this.zzfnz;
    }

    @WorkerThread
    public final void zzahx() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        this.zzfoc = null;
    }

    @WorkerThread
    public final ConnectionResult zzahy() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        return this.zzfoc;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzfnx, this.zzaac());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfkh.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzv(Status status) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        Iterator iterator = this.zzfnv.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzr(status);
        }
        this.zzfnv.clear();
    }

    @WorkerThread
    public final void resume() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        if (this.zzfmi) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzahz() {
        if (this.zzfmi) {
            zzbp.zza(this.zzfnu).removeMessages(11, this.zzfgs);
            zzbp.zza(this.zzfnu).removeMessages(9, this.zzfgs);
            this.zzfmi = false;
        }
    }

    @WorkerThread
    public final void zzahh() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        if (this.zzfmi) {
            this.zzahz();
            Status status = zzbp.zzg(this.zzfnu).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfnu)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzv(status);
            this.zzfkh.disconnect();
        }
    }

    private final void zzaia() {
        zzbp.zza(this.zzfnu).removeMessages(12, this.zzfgs);
        zzbp.zza(this.zzfnu).sendMessageDelayed(zzbp.zza(this.zzfnu).obtainMessage(12, this.zzfgs), zzbp.zzh(this.zzfnu));
    }

    @WorkerThread
    public final void zzaib() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        if (this.zzfkh.isConnected() && this.zzfnz.size() == 0) {
            if (this.zzfnx.zzags()) {
                this.zzaia();
                return;
            }
            this.zzfkh.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        if (this.zzfkh.isConnected() || this.zzfkh.isConnecting()) {
            return;
        }
        if (this.zzfkh.zzaff() && zzbp.zzi(this.zzfnu) != 0) {
            zzbp.zza(this.zzfnu, zzbp.zzg(this.zzfnu).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfnu)));
            if (zzbp.zzi(this.zzfnu) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbp.zzi(this.zzfnu), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbv zzbv2 = new zzbv(this.zzfnu, this.zzfkh, this.zzfgs);
        if (this.zzfkh.zzaac()) {
            this.zzfob.zza(zzbv2);
        }
        this.zzfkh.zza(zzbv2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnu));
        this.zzfny.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzj> iterator = this.zzfny.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzfgs, connectionResult);
        }
        this.zzfny.clear();
    }

    final boolean isConnected() {
        return this.zzfkh.isConnected();
    }

    public final boolean zzaac() {
        return this.zzfkh.zzaac();
    }

    public final int getInstanceId() {
        return this.zzfoa;
    }

    final zzcps zzaic() {
        if (this.zzfob == null) {
            return null;
        }
        return this.zzfob.zzaic();
    }

    static /* synthetic */ void zzc(zzbr zzbr2) {
        zzbr2.zzahu();
    }

    static /* synthetic */ void zzd(zzbr zzbr2) {
        zzbr2.zzahv();
    }
}

