/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import com.google.android.gms.internal.zzcpy;
import com.google.android.gms.internal.zzcqa;
import com.google.android.gms.internal.zzcqb;
import com.google.android.gms.internal.zzcqd;
import com.google.android.gms.internal.zzcqf;

public final class zzcqc
extends zzaa<zzcqa>
implements zzcps {
    private final boolean zzjnv;
    private final zzq zzfkj;
    private final Bundle zzjnw;
    private Integer zzftu;

    private zzcqc(Context context, Looper looper, boolean bl, zzq zzq2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzjnv = true;
        this.zzfkj = zzq2;
        this.zzjnw = bundle;
        this.zzftu = zzq2.zzajy();
    }

    public zzcqc(Context context, Looper looper, boolean bl, zzq zzq2, zzcpt zzcpt2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, true, zzq2, zzcqc.zza(zzq2), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public final boolean zzaac() {
        return this.zzjnv;
    }

    @Override
    public final void zza(zzam zzam2, boolean bl) {
        try {
            ((zzcqa)this.zzajj()).zza(zzam2, this.zzftu, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zzbbv() {
        try {
            ((zzcqa)this.zzajj()).zzec(this.zzftu);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zza(zzcpy zzcpy2) {
        zzbp.zzb((Object)zzcpy2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            zzcqc zzcqc2 = this;
            Account account = zzcqc2.zzfkj.zzajp();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = zzy.zzbl(zzcqc2.getContext()).zzaas();
            }
            zzbq zzbq2 = new zzbq(account, zzcqc2.zzftu, googleSignInAccount);
            ((zzcqa)this.zzajj()).zza(new zzcqd(zzbq2), zzcpy2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zzcpy2.zzb(new zzcqf(8));
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    protected final String zzhc() {
        return "com.google.android.gms.signin.service.START";
    }

    protected final String zzhd() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected final Bundle zzzu() {
        String string2 = this.zzfkj.zzaju();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.zzjnw.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzfkj.zzaju());
        }
        return this.zzjnw;
    }

    @Override
    public final void connect() {
        this.zza((zzj)new zzm((zzd)this));
    }

    public static Bundle zza(zzq zzq2) {
        zzcpt zzcpt2 = zzq2.zzajx();
        Integer n = zzq2.zzajy();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)zzq2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (zzcpt2 != null) {
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzcpt2.zzbbw());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzcpt2.isIdTokenRequested());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzcpt2.getServerClientId());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzcpt2.zzbbx());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", zzcpt2.zzbby());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzcpt2.zzbbz());
            if (zzcpt2.zzbca() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", zzcpt2.zzbca().longValue());
            }
            if (zzcpt2.zzbcb() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", zzcpt2.zzbcb().longValue());
            }
        }
        return bundle;
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (iInterface instanceof zzcqa) {
            return (zzcqa)iInterface;
        }
        return new zzcqb(iBinder2);
    }
}

