/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcg;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzdc;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdl;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbeq;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbd
extends GoogleApiClient
implements zzcg {
    private final Lock zzfni;
    private boolean zzfks;
    private final zzae zzfpk;
    private zzcf zzfpl = null;
    private final int zzfkm;
    private final Context mContext;
    private final Looper zzakm;
    final Queue<zzm<?, ?>> zzfnw = new LinkedList();
    private volatile boolean zzfpm;
    private long zzfpn = 120000L;
    private long zzfpo = 5000L;
    private final zzbi zzfpp;
    private final GoogleApiAvailability zzfko;
    private zzca zzfpq;
    final Map<Api.zzc<?>, Api.zze> zzfpr;
    Set<Scope> zzfps = new HashSet<Scope>();
    private zzr zzfnn;
    private Map<Api<?>, Boolean> zzfnq;
    private Api.zza<? extends zzcwb, zzcwc> zzfkp;
    private final zzcp zzfpt = new zzcp();
    private final ArrayList<zzw> zzfpu;
    private Integer zzfpv = null;
    Set<zzdi> zzfpw = null;
    final zzdl zzfpx;
    private final zzaf zzfpy = new zzbe(this);

    public zzbd(Context context, Lock lock, Looper looper, zzr zzr2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcwb, zzcwc> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzw> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfni = lock;
        this.zzfks = false;
        this.zzfpk = new zzae(looper, this.zzfpy);
        this.zzakm = looper;
        this.zzfpp = new zzbi(this, looper);
        this.zzfko = googleApiAvailability;
        this.zzfkm = n;
        if (this.zzfkm >= 0) {
            this.zzfpv = n2;
        }
        this.zzfnq = map;
        this.zzfpr = map2;
        this.zzfpu = arrayList;
        this.zzfpx = new zzdl(this.zzfpr);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfpk.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfpk.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfnn = zzr2;
        this.zzfkp = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbq.checkArgument((t.zzafu() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzafz() != null ? t.zzafz().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfpr.containsKey(t.zzafu()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfni.lock();
        try {
            if (this.zzfpl == null) {
                this.zzfnw.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfpl.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbq.checkArgument((t.zzafu() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzafz() != null ? t.zzafz().getName() : "the API";
        zzbq.checkArgument((boolean)this.zzfpr.containsKey(t.zzafu()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfni.lock();
        try {
            if (this.zzfpl == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfpm) {
                this.zzfnw.add(t);
                while (!this.zzfnw.isEmpty()) {
                    object = this.zzfnw.remove();
                    this.zzfpx.zzb((zzs<? extends Result>)object);
                    ((zzm)object).zzv(Status.zzfla);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfpl.zze(t);
            return (T)object;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final <L> zzcl<L> zzs(@NonNull L l) {
        this.zzfni.lock();
        try {
            Looper looper = this.zzakm;
            L l2 = l;
            zzcl<L> zzcl2 = this.zzfpt.zza(l2, looper, "NO_TYPE");
            return zzcl2;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfpr.get(zzc2);
        zzbq.checkNotNull((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfpr.containsKey(api.zzafu());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfpr.get(api.zzafu());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfni.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfpm) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfpr.containsKey(api.zzafu())) break block6;
                    connectionResult = this.zzfpl.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfpm) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzfii;
                    this.zzfni.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzaib());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfni.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfni.lock();
        try {
            if (this.zzfkm >= 0) {
                zzbq.zza((this.zzfpv != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfpv == null) {
                this.zzfpv = zzbd.zza(this.zzfpr.values(), false);
            } else if (this.zzfpv == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfpv);
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfni.lock();
        try {
            zzbq.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbw(n);
            this.zzahx();
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfni.lock();
        try {
            if (this.zzfkm >= 0) {
                zzbq.zza((this.zzfpv != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfpv == null) {
                this.zzfpv = zzbd.zza(this.zzfpr.values(), false);
            } else if (this.zzfpv == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbw(this.zzfpv);
            this.zzfpk.zzaky();
            ConnectionResult connectionResult = this.zzfpl.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbq.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfni.lock();
        try {
            if (this.zzfpv == null) {
                this.zzfpv = zzbd.zza(this.zzfpr.values(), false);
            } else if (this.zzfpv == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbw(this.zzfpv);
            this.zzfpk.zzaky();
            ConnectionResult connectionResult = this.zzfpl.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfni.lock();
        try {
            this.zzfpx.release();
            if (this.zzfpl != null) {
                this.zzfpl.disconnect();
            }
            this.zzfpt.release();
            for (zzm zzm2 : this.zzfnw) {
                ((zzs)zzm2).zza((zzdo)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfnw.clear();
            if (this.zzfpl == null) {
                return;
            }
            this.zzahz();
            this.zzfpk.zzakx();
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbq.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbq.zza((this.zzfpv != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzdc zzdc2 = new zzdc(this);
        if (this.zzfpr.containsKey(zzbeq.zzdyh)) {
            this.zza(this, zzdc2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbf zzbf2 = new zzbf(this, atomicReference, zzdc2);
            zzbg zzbg2 = new zzbg(this, zzdc2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbeq.API).addConnectionCallbacks(zzbf2).addOnConnectionFailedListener(zzbg2).setHandler(this.zzfpp).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzdc2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzdc zzdc2, boolean bl) {
        zzbeq.zzfzl.zzd(googleApiClient).setResultCallback(new zzbh(this, zzdc2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzch zzch2 = new zzch((Activity)fragmentActivity);
        zzbd zzbd2 = this;
        if (zzbd2.zzfkm >= 0) {
            zzi.zza(zzch2).zzbs(zzbd2.zzfkm);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfpl != null && this.zzfpl.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfpl != null && this.zzfpl.isConnecting();
    }

    private final void zzbw(int n) {
        if (this.zzfpv == null) {
            this.zzfpv = n;
        } else if (this.zzfpv != n) {
            String string2 = zzbd.zzbx(n);
            String string3 = zzbd.zzbx(this.zzfpv);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfpl != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfpr.values()) {
            if (zze2.zzaan()) {
                bl = true;
            }
            if (!zze2.zzaax()) continue;
            bl2 = true;
        }
        switch (this.zzfpv) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzfks) {
                    this.zzfpl = new zzad(this.mContext, this.zzfni, this.zzakm, this.zzfko, this.zzfpr, this.zzfnn, this.zzfnq, this.zzfkp, this.zzfpu, this, true);
                    return;
                }
                this.zzfpl = zzy.zza(this.mContext, this, this.zzfni, this.zzakm, this.zzfko, this.zzfpr, this.zzfnn, this.zzfnq, this.zzfkp, this.zzfpu);
                return;
            }
        }
        if (this.zzfks && !bl2) {
            this.zzfpl = new zzad(this.mContext, this.zzfni, this.zzakm, this.zzfko, this.zzfpr, this.zzfnn, this.zzfnq, this.zzfkp, this.zzfpu, this, false);
            return;
        }
        this.zzfpl = new zzbl(this.mContext, this, this.zzfni, this.zzakm, this.zzfko, this.zzfpr, this.zzfnn, this.zzfnq, this.zzfkp, this.zzfpu, this);
    }

    private final void zzahx() {
        this.zzfpk.zzaky();
        this.zzfpl.connect();
    }

    private final void resume() {
        this.zzfni.lock();
        try {
            if (this.zzfpm) {
                this.zzahx();
            }
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    private final void zzahy() {
        this.zzfni.lock();
        try {
            if (this.zzahz()) {
                this.zzahx();
            }
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    final boolean zzahz() {
        if (!this.zzfpm) {
            return false;
        }
        this.zzfpm = false;
        this.zzfpp.removeMessages(2);
        this.zzfpp.removeMessages(1);
        if (this.zzfpq != null) {
            this.zzfpq.unregister();
            this.zzfpq = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfpk.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfpk.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfpk.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfpk.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfpk.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfpk.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzj(Bundle bundle) {
        while (!this.zzfnw.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfnw.remove());
        }
        this.zzfpk.zzk(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzahz();
        }
        if (!this.zzfpm) {
            this.zzfpk.zzk(connectionResult);
            this.zzfpk.zzakx();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbd zzbd2 = this;
            if (!zzbd2.zzfpm) {
                zzbd2.zzfpm = true;
                if (zzbd2.zzfpq == null) {
                    zzbd2.zzfpq = GoogleApiAvailability.zza(zzbd2.mContext.getApplicationContext(), new zzbj(zzbd2));
                }
                zzbd2.zzfpp.sendMessageDelayed(zzbd2.zzfpp.obtainMessage(1), zzbd2.zzfpn);
                zzbd2.zzfpp.sendMessageDelayed(zzbd2.zzfpp.obtainMessage(2), zzbd2.zzfpo);
            }
        }
        this.zzfpx.zzajj();
        this.zzfpk.zzch(n);
        this.zzfpk.zzakx();
        if (n == 2) {
            this.zzahx();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzakm;
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        return this.zzfpl != null && this.zzfpl.zza(zzcx2);
    }

    @Override
    public final void zzagg() {
        if (this.zzfpl != null) {
            this.zzfpl.zzagg();
        }
    }

    @Override
    public final void zza(zzdi zzdi2) {
        this.zzfni.lock();
        try {
            if (this.zzfpw == null) {
                this.zzfpw = new HashSet<zzdi>();
            }
            this.zzfpw.add(zzdi2);
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void zzb(zzdi zzdi2) {
        this.zzfni.lock();
        try {
            if (this.zzfpw == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfpw.remove(zzdi2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzaia()) {
                this.zzfpl.zzagz();
            }
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    final boolean zzaia() {
        this.zzfni.lock();
        try {
            if (this.zzfpw == null) {
                return false;
            }
            boolean bl = !this.zzfpw.isEmpty();
            return bl;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    final String zzaib() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfpm);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfnw.size());
        PrintWriter printWriter2 = printWriter;
        zzdl zzdl2 = this.zzfpx;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdl2.zzfsy.size());
        if (this.zzfpl != null) {
            this.zzfpl.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzaan()) {
                bl2 = true;
            }
            if (!zze2.zzaax()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbx(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbd zzbd2) {
        zzbd2.resume();
    }

    static /* synthetic */ void zzb(zzbd zzbd2) {
        zzbd2.zzahy();
    }

    static /* synthetic */ void zza(zzbd zzbd2, GoogleApiClient googleApiClient, zzdc zzdc2, boolean bl) {
        zzbd2.zza(googleApiClient, zzdc2, true);
    }

    static /* synthetic */ Context zzc(zzbd zzbd2) {
        return zzbd2.mContext;
    }
}

