/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzar;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcg;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbl
implements zzcf,
zzx {
    private final Lock zzfni;
    private final Condition zzfqe;
    private final Context mContext;
    private final zze zzfns;
    private final zzbn zzfqf;
    final Map<Api.zzc<?>, Api.zze> zzfpr;
    final Map<Api.zzc<?>, ConnectionResult> zzfqg = new HashMap();
    private zzr zzfnn;
    private Map<Api<?>, Boolean> zzfnq;
    private Api.zza<? extends zzcwb, zzcwc> zzfkp;
    private volatile zzbk zzfqh;
    private ConnectionResult zzfqi = null;
    int zzfqj;
    final zzbd zzfmy;
    final zzcg zzfqk;

    public zzbl(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcwb, zzcwc> zza2, ArrayList<zzw> arrayList, zzcg zzcg2) {
        this.mContext = context;
        this.zzfni = lock;
        this.zzfns = zze2;
        this.zzfpr = map;
        this.zzfnn = zzr2;
        this.zzfnq = map2;
        this.zzfkp = zza2;
        this.zzfmy = zzbd2;
        this.zzfqk = zzcg2;
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw2.zza(this);
        }
        this.zzfqf = new zzbn(this, looper);
        this.zzfqe = lock.newCondition();
        this.zzfqh = new zzbc(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzagx();
        return this.zzfqh.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzagx();
        return this.zzfqh.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfqh.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfqe.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfii;
        }
        if (this.zzfqi != null) {
            return this.zzfqi;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfqe.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfii;
        }
        if (this.zzfqi != null) {
            return this.zzfqi;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfqh.disconnect()) {
            this.zzfqg.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzafu();
        if (this.zzfpr.containsKey(zzc2)) {
            if (this.zzfpr.get(zzc2).isConnected()) {
                return ConnectionResult.zzfii;
            }
            if (this.zzfqg.containsKey(zzc2)) {
                return this.zzfqg.get(zzc2);
            }
        }
        return null;
    }

    final void zzaic() {
        this.zzfni.lock();
        try {
            this.zzfqh = new zzar(this, this.zzfnn, this.zzfnq, this.zzfns, this.zzfkp, this.zzfni, this.mContext);
            this.zzfqh.begin();
            this.zzfqe.signalAll();
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    final void zzaid() {
        this.zzfni.lock();
        try {
            this.zzfmy.zzahz();
            this.zzfqh = new zzao(this);
            this.zzfqh.begin();
            this.zzfqe.signalAll();
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfni.lock();
        try {
            this.zzfqi = connectionResult;
            this.zzfqh = new zzbc(this);
            this.zzfqh.begin();
            this.zzfqe.signalAll();
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfqh instanceof zzao;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfqh instanceof zzar;
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        return false;
    }

    @Override
    public final void zzagg() {
    }

    @Override
    public final void zzagz() {
        if (this.isConnected()) {
            ((zzao)this.zzfqh).zzahp();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfni.lock();
        try {
            this.zzfqh.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfni.lock();
        try {
            this.zzfqh.onConnected(bundle);
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfni.lock();
        try {
            this.zzfqh.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    final void zza(zzbm zzbm2) {
        Message message = this.zzfqf.obtainMessage(1, zzbm2);
        this.zzfqf.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzfqf.obtainMessage(2, runtimeException);
        this.zzfqf.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfqh);
        for (Api<?> api : this.zzfnq.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfpr.get(api.zzafu()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbl zzbl2) {
        return zzbl2.zzfni;
    }

    static /* synthetic */ zzbk zzb(zzbl zzbl2) {
        return zzbl2.zzfqh;
    }
}

