/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzo;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.internal.zzbq;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzi
extends zzo {
    private final SparseArray<zza> zzfln = new SparseArray();

    public static zzi zza(zzch zzch2) {
        zzci zzci2 = zzi.zzb((zzch)zzch2);
        zzi zzi2 = (zzi)zzci2.zza("AutoManageHelper", zzi.class);
        if (zzi2 != null) {
            return zzi2;
        }
        return new zzi(zzci2);
    }

    private zzi(zzci zzci2) {
        super(zzci2);
        this.zzfrt.zza("AutoManageHelper", (LifecycleCallback)this);
    }

    public final void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbq.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzbq.zza((this.zzfln.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        zzp zzp2 = (zzp)this.zzfma.get();
        boolean bl = this.mStarted;
        String string = String.valueOf(zzp2);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(49 + String.valueOf(string).length()).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(string).toString());
        zza zza2 = new zza(this, n, googleApiClient, onConnectionFailedListener);
        this.zzfln.put(n, (Object)zza2);
        if (this.mStarted && zzp2 == null) {
            string = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string).length()).append("connecting ").append(string).toString());
            googleApiClient.connect();
        }
    }

    public final void zzbs(int n) {
        zza zza2 = (zza)this.zzfln.get(n);
        this.zzfln.remove(n);
        if (zza2 != null) {
            zza zza3 = zza2;
            zza3.zzflp.unregisterConnectionFailedListener(zza3);
            zza3.zzflp.disconnect();
        }
    }

    @Override
    public final void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzfln);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (this.zzfma.get() == null) {
            for (n = 0; n < this.zzfln.size(); ++n) {
                object = this.zzbt(n);
                if (object == null) continue;
                ((zza)object).zzflp.connect();
            }
        }
    }

    @Override
    public final void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzfln.size(); ++i) {
            zza zza2 = this.zzbt(i);
            if (zza2 == null) continue;
            zza2.zzflp.disconnect();
        }
    }

    public final void dump(String string, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzfln.size(); ++i) {
            zza zza2 = this.zzbt(i);
            if (zza2 == null) continue;
            String[] stringArray2 = stringArray;
            PrintWriter printWriter2 = printWriter;
            FileDescriptor fileDescriptor2 = fileDescriptor;
            String string2 = string;
            zza zza3 = zza2;
            printWriter2.append(string2).append("GoogleApiClient #").print(zza3.zzflo);
            printWriter2.println(":");
            zza3.zzflp.dump(String.valueOf(string2).concat("  "), fileDescriptor2, printWriter2, stringArray2);
        }
    }

    @Override
    protected final void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzfln.get(n);
        if (zza2 != null) {
            this.zzbs(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzflq;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected final void zzagn() {
        for (int i = 0; i < this.zzfln.size(); ++i) {
            zza zza2 = this.zzbt(i);
            if (zza2 == null) continue;
            zza2.zzflp.connect();
        }
    }

    @Nullable
    private final zza zzbt(int n) {
        if (this.zzfln.size() <= n) {
            return null;
        }
        return (zza)this.zzfln.get(this.zzfln.keyAt(n));
    }

    final class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzflo;
        public final GoogleApiClient zzflp;
        public final GoogleApiClient.OnConnectionFailedListener zzflq;
        private /* synthetic */ zzi zzflr;

        public zza(zzi zzi2, int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzflr = zzi2;
            this.zzflo = n;
            this.zzflp = googleApiClient;
            this.zzflq = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string).length()).append("beginFailureResolution for ").append(string).toString());
            this.zzflr.zzb(connectionResult, this.zzflo);
        }
    }
}

