/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbo;
import com.google.android.gms.common.api.internal.zzbw;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzdd;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzfin;
    private final O zzfme;
    private final zzh<O> zzfmf;
    private final Looper zzall;
    private final int mId;
    private final GoogleApiClient zzfmg;
    private final zzcz zzfmh;
    protected final zzbm zzfmi;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzfin = api;
        this.zzfme = null;
        this.zzall = looper;
        this.zzfmf = zzh.zzb(api);
        this.zzfmg = new zzbw(this);
        this.zzfmi = zzbm.zzcj(this.mContext);
        this.mId = this.zzfmi.zzais();
        this.zzfmh = new zzg();
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzcz zzcz2) {
        this(context, api, null, new zzd().zza(looper).zza(zzcz2).zzagq());
    }

    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzfin = api;
        this.zzfme = o;
        this.zzall = zza2.zzfml;
        this.zzfmf = zzh.zza(this.zzfin, this.zzfme);
        this.zzfmg = new zzbw(this);
        this.zzfmi = zzbm.zzcj(this.mContext);
        this.mId = this.zzfmi.zzais();
        this.zzfmh = zza2.zzfmk;
        zzah.zza(activity, this.zzfmi, this.zzfmf);
        this.zzfmi.zza(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzfin = api;
        this.zzfme = o;
        this.zzall = zza2.zzfml;
        this.zzfmf = zzh.zza(this.zzfin, this.zzfme);
        this.zzfmg = new zzbw(this);
        this.zzfmi = zzbm.zzcj(this.mContext);
        this.mId = this.zzfmi.zzais();
        this.zzfmh = zza2.zzfmk;
        this.zzfmi.zza(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzcz zzcz2) {
        this(activity, api, o, new zzd().zza(zzcz2).zza(activity.getMainLooper()).zzagq());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzcz zzcz2) {
        this(context, api, o, new zzd().zza(zzcz2).zzagq());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzahi();
        this.zzfmi.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzdd<A, TResult> zzdd2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzfmi.zza(this, n, zzdd2, taskCompletionSource, this.zzfmh);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzdd<A, TResult> zzdd2) {
        return this.zza(false, (zzdn)((Object)zzdd2));
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzdd<A, TResult> zzdd2) {
        return this.zza(true, (zzdn)((Object)zzdd2));
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    public final <A extends Api.zzb, T extends zzcq<A, ?>, U extends zzdn<A, ?>> Task<Void> zza(@NonNull T t, U u) {
        zzbq.checkNotNull(t);
        zzbq.checkNotNull(u);
        zzbq.checkNotNull(t.zzajo(), (Object)"Listener has already been released.");
        zzbq.checkNotNull(u.zzajo(), (Object)"Listener has already been released.");
        zzbq.checkArgument((boolean)t.zzajo().equals(u.zzajo()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zzfmi.zza(this, t, u);
    }

    public final Task<Boolean> zza(@NonNull zzck<?> zzck2) {
        zzbq.checkNotNull(zzck2, (Object)"Listener key cannot be null.");
        return this.zzfmi.zza(this, zzck2);
    }

    public final <L> zzci<L> zza(@NonNull L l, String string2) {
        return zzcm.zzb(l, this.zzall, string2);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbo<O> zzbo2) {
        zzr zzr2 = this.zzagp().zzgf(this.mContext.getPackageName()).zzgg(this.mContext.getClass().getName()).zzald();
        return this.zzfin.zzage().zza(this.mContext, looper, zzr2, this.zzfme, zzbo2, zzbo2);
    }

    public final Api<O> zzagl() {
        return this.zzfin;
    }

    public final O zzagm() {
        return this.zzfme;
    }

    public final zzh<O> zzagn() {
        return this.zzfmf;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzago() {
        return this.zzfmg;
    }

    public final Looper getLooper() {
        return this.zzall;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    private final zzs zzagp() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        Account account = googleApi.zzfme instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfme).getGoogleSignInAccount()) != null ? googleSignInAccount.getAccount() : (googleApi.zzfme instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzfme).getAccount() : null);
        googleApi = this;
        return new zzs().zze(account).zze(googleApi.zzfme instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfme).getGoogleSignInAccount()) != null ? googleSignInAccount.zzabb() : Collections.emptySet());
    }

    public zzcv zza(Context context, Handler handler) {
        return new zzcv(context, handler, this.zzagp().zzald());
    }

    public static final class zza {
        public static final zza zzfmj = new zzd().zzagq();
        public final zzcz zzfmk;
        public final Looper zzfml;

        private zza(zzcz zzcz2, Account account, Looper looper) {
            this.zzfmk = zzcz2;
            this.zzfml = looper;
        }

        /* synthetic */ zza(zzcz zzcz2, Account account, Looper looper, zzc zzc2) {
            this(zzcz2, null, looper);
        }
    }
}

