/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbfh;
import com.google.android.gms.internal.zzbfj;

public final class zzbff
extends Drawable
implements Drawable.Callback {
    private int zzfxo = 0;
    private long zzdvq;
    private int mFrom;
    private int zzfxp;
    private int zzfxq = 255;
    private int zzfxr;
    private int mAlpha = 0;
    private boolean zzfxj = true;
    private boolean zzfxs;
    private zzbfj zzfxt;
    private Drawable zzfxu;
    private Drawable zzfxv;
    private boolean zzfxw;
    private boolean zzfxx;
    private boolean zzfxy;
    private int zzfxz;

    public zzbff(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbfh.zzakf();
        }
        this.zzfxu = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzfxt.zzfyc |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbfh.zzakf();
        }
        this.zzfxv = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzfxt.zzfyc |= drawable3.getChangingConfigurations();
    }

    zzbff(zzbfj zzbfj2) {
        this.zzfxt = new zzbfj(zzbfj2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzfxt.mChangingConfigurations | this.zzfxt.zzfyc;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zzfxq) {
            this.mAlpha = n;
        }
        this.zzfxq = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzfxu.setColorFilter(colorFilter);
        this.zzfxv.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzfxu.getIntrinsicWidth(), this.zzfxv.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzfxu.getIntrinsicHeight(), this.zzfxv.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzfxu.setBounds(rect);
        this.zzfxv.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzfxt.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzfxt;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzfxy) {
            this.zzfxz = Drawable.resolveOpacity((int)this.zzfxu.getOpacity(), (int)this.zzfxv.getOpacity());
            this.zzfxy = true;
        }
        return this.zzfxz;
    }

    private final boolean canConstantState() {
        if (!this.zzfxw) {
            this.zzfxx = this.zzfxu.getConstantState() != null && this.zzfxv.getConstantState() != null;
            this.zzfxw = true;
        }
        return this.zzfxx;
    }

    public final Drawable mutate() {
        if (!this.zzfxs && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzfxu.mutate();
            this.zzfxv.mutate();
            this.zzfxs = true;
        }
        return this;
    }

    public final Drawable zzake() {
        return this.zzfxv;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzfxp = this.zzfxq;
        this.mAlpha = 0;
        this.zzfxr = 250;
        this.zzfxo = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzfxo) {
            case 1: {
                this.zzdvq = SystemClock.uptimeMillis();
                bl = false;
                this.zzfxo = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzdvq < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzdvq) / (float)this.zzfxr;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzfxo = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zzfxp * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zzfxj;
        Drawable drawable2 = this.zzfxu;
        Drawable drawable3 = this.zzfxv;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzfxq) {
                drawable3.setAlpha(this.zzfxq);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzfxq - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzfxq);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzfxq);
        }
        this.invalidateSelf();
    }
}

