/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zaal;
import com.google.android.gms.common.api.internal.zaam;
import com.google.android.gms.common.api.internal.zaan;
import com.google.android.gms.common.api.internal.zaaq;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zaj;
import com.google.android.gms.signin.zad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaak
implements zabd {
    private final zabe zaft;
    private final Lock zaeo;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zaey;
    private ConnectionResult zafh;
    private int zafw;
    private int zafx = 0;
    private int zafy;
    private final Bundle zafz = new Bundle();
    private final Set<Api.AnyClientKey> zaga = new HashSet<Api.AnyClientKey>();
    private zad zagb;
    private boolean zagc;
    private boolean zagd;
    private boolean zage;
    private IAccountAccessor zagf;
    private boolean zagg;
    private boolean zagh;
    private final ClientSettings zaet;
    private final Map<Api<?>, Boolean> zaew;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zace;
    private ArrayList<Future<?>> zagi = new ArrayList();

    public zaak(zabe zabe2, ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        this.zaft = zabe2;
        this.zaet = clientSettings;
        this.zaew = map;
        this.zaey = googleApiAvailabilityLight;
        this.zace = abstractClientBuilder;
        this.zaeo = lock;
        this.mContext = context;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void begin() {
        this.zaft.zahp.clear();
        this.zagd = false;
        this.zafh = null;
        this.zafx = 0;
        this.zagc = true;
        this.zage = false;
        this.zagg = false;
        boolean bl = false;
        HashMap<Api.Client, zaam> hashMap = new HashMap<Api.Client, zaam>();
        for (Api<?> api : this.zaew.keySet()) {
            Api.Client client = this.zaft.zagz.get(api.getClientKey());
            bl |= api.zah().getPriority() == 1;
            boolean bl2 = this.zaew.get(api);
            if (client.requiresSignIn()) {
                this.zagd = true;
                if (bl2) {
                    this.zaga.add(api.getClientKey());
                } else {
                    this.zagc = false;
                }
            }
            hashMap.put(client, new zaam(this, api, bl2));
        }
        if (bl) {
            this.zagd = false;
        }
        if (this.zagd) {
            this.zaet.setClientSessionId(System.identityHashCode(this.zaft.zaee));
            zaat zaat2 = new zaat(this, null);
            this.zagb = this.zace.buildClient(this.mContext, ((GoogleApiClient)this.zaft.zaee).getLooper(), this.zaet, this.zaet.getSignInOptions(), zaat2, zaat2);
        }
        this.zafy = this.zaft.zagz.size();
        this.zagi.add(zabh.zabb().submit(new zaan(this, hashMap)));
    }

    @GuardedBy(value="mLock")
    private final boolean zaao() {
        --this.zafy;
        if (this.zafy > 0) {
            return false;
        }
        if (this.zafy < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zaft.zaee.zaay());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        if (this.zafh != null) {
            this.zaft.zahs = this.zafw;
            this.zae(this.zafh);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zaa(zaj zaj2) {
        if (!this.zac(0)) {
            return;
        }
        ConnectionResult connectionResult = zaj2.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = zaj2.zacx();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zae(connectionResult2);
                return;
            }
            this.zage = true;
            this.zagf = resolveAccountResponse.getAccountAccessor();
            this.zagg = resolveAccountResponse.getSaveDefaultAccount();
            this.zagh = resolveAccountResponse.isFromCrossClientAuth();
            this.zaap();
            return;
        }
        if (this.zad(connectionResult)) {
            this.zaar();
            this.zaap();
            return;
        }
        this.zae(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaap() {
        if (this.zafy != 0) {
            return;
        }
        if (!this.zagd || this.zage) {
            zaak zaak2 = this;
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            zaak2.zafx = 1;
            zaak2.zafy = zaak2.zaft.zagz.size();
            for (Api.AnyClientKey<?> anyClientKey : zaak2.zaft.zagz.keySet()) {
                if (zaak2.zaft.zahp.containsKey(anyClientKey)) {
                    if (!zaak2.zaao()) continue;
                    zaak2.zaaq();
                    continue;
                }
                arrayList.add(zaak2.zaft.zagz.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                zaak2.zagi.add(zabh.zabb().submit(new zaaq(zaak2, arrayList)));
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnected(Bundle bundle) {
        if (!this.zac(1)) {
            return;
        }
        if (bundle != null) {
            this.zafz.putAll(bundle);
        }
        if (this.zaao()) {
            this.zaaq();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zac(1)) {
            return;
        }
        this.zab(connectionResult, api, bl);
        if (this.zaao()) {
            this.zaaq();
        }
    }

    @GuardedBy(value="mLock")
    private final void zaaq() {
        this.zaft.zaba();
        zabh.zabb().execute(new zaal(this));
        if (this.zagb != null) {
            if (this.zagg) {
                this.zagb.zaa(this.zagf, this.zagh);
            }
            this.zab(false);
        }
        for (Api.AnyClientKey<?> anyClientKey : this.zaft.zahp.keySet()) {
            this.zaft.zagz.get(anyClientKey).disconnect();
        }
        Bundle bundle = this.zafz.isEmpty() ? null : this.zafz;
        this.zaft.zaht.zab(bundle);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(T t) {
        this.zaft.zaee.zafc.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public final void connect() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final boolean disconnect() {
        this.zaas();
        this.zab(true);
        this.zaft.zaf(null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnectionSuspended(int n) {
        this.zae(new ConnectionResult(8, null));
    }

    /*
     * Unable to fully structure code
     */
    @GuardedBy(value="mLock")
    private final void zab(ConnectionResult var1_1, Api<?> var2_2, boolean var3_3) {
        block3: {
            var4_4 = var2_2.zah().getPriority();
            var7_5 = var1_1;
            var6_6 = var3_3;
            var5_7 = this;
            if (!var6_6) break block3;
            var9_8 = var7_5;
            var8_9 = var5_7;
            if (!(var9_8.hasResolution() != false ? true : var8_9.zaey.getErrorResolutionIntent(var9_8.getErrorCode()) != null)) ** GOTO lbl-1000
        }
        if (var5_7.zafh == null || var4_4 < var5_7.zafw) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            this.zafh = var1_1;
            this.zafw = var4_4;
        }
        this.zaft.zahp.put(var2_2.getClientKey(), var1_1);
    }

    @GuardedBy(value="mLock")
    private final void zaar() {
        this.zagd = false;
        this.zaft.zaee.zaha = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zaga) {
            if (this.zaft.zahp.containsKey(anyClientKey)) continue;
            this.zaft.zahp.put(anyClientKey, new ConnectionResult(17, null));
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zad(ConnectionResult connectionResult) {
        return this.zagc && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zae(ConnectionResult connectionResult) {
        this.zaas();
        this.zab(!connectionResult.hasResolution());
        this.zaft.zaf(connectionResult);
        this.zaft.zaht.zac(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zab(boolean bl) {
        if (this.zagb != null) {
            if (this.zagb.isConnected() && bl) {
                this.zagb.zacw();
            }
            this.zagb.disconnect();
            if (this.zaet.isSignInClientDisconnectFixEnabled()) {
                this.zagb = null;
            }
            this.zagf = null;
        }
    }

    private final void zaas() {
        ArrayList<Future<?>> arrayList = this.zagi;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Future<?> future = arrayList.get(i);
            future.cancel(true);
        }
        this.zagi.clear();
    }

    private final Set<Scope> zaat() {
        if (this.zaet == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaet.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zaet.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            if (this.zaft.zahp.containsKey(api.getClientKey())) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        return hashSet;
    }

    @GuardedBy(value="mLock")
    private final boolean zac(int n) {
        if (this.zafx != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zaft.zaee.zaay());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zafy;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = zaak.zad(this.zafx);
            String string4 = zaak.zad(n);
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private static String zad(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Context zaa(zaak zaak2) {
        return zaak2.mContext;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zab(zaak zaak2) {
        return zaak2.zaey;
    }

    static /* synthetic */ Lock zac(zaak zaak2) {
        return zaak2.zaeo;
    }

    static /* synthetic */ zabe zad(zaak zaak2) {
        return zaak2.zaft;
    }

    static /* synthetic */ void zaa(zaak zaak2, ConnectionResult connectionResult) {
        zaak2.zae(connectionResult);
    }

    static /* synthetic */ boolean zae(zaak zaak2) {
        return zaak2.zagd;
    }

    static /* synthetic */ zad zaf(zaak zaak2) {
        return zaak2.zagb;
    }

    static /* synthetic */ Set zag(zaak zaak2) {
        return zaak2.zaat();
    }

    static /* synthetic */ IAccountAccessor zah(zaak zaak2) {
        return zaak2.zagf;
    }

    static /* synthetic */ ClientSettings zai(zaak zaak2) {
        return zaak2.zaet;
    }

    static /* synthetic */ boolean zab(zaak zaak2, ConnectionResult connectionResult) {
        return zaak2.zad(connectionResult);
    }

    static /* synthetic */ void zaj(zaak zaak2) {
        zaak2.zaar();
    }

    static /* synthetic */ void zak(zaak zaak2) {
        zaak2.zaap();
    }

    static /* synthetic */ boolean zaa(zaak zaak2, int n) {
        return zaak2.zac(0);
    }

    static /* synthetic */ void zaa(zaak zaak2, ConnectionResult connectionResult, Api api, boolean bl) {
        zaak2.zab(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zal(zaak zaak2) {
        return zaak2.zaao();
    }

    static /* synthetic */ void zaa(zaak zaak2, zaj zaj2) {
        zaak2.zaa(zaj2);
    }
}

