/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;

public class Storage {
    private static final Lock zaai = new ReentrantLock();
    @GuardedBy(value="sLk")
    private static Storage zaaj;
    private final Lock zaak = new ReentrantLock();
    @GuardedBy(value="mLk")
    private final SharedPreferences zaal;

    @KeepForSdk
    public static Storage getInstance(Context context) {
        Preconditions.checkNotNull((Object)context);
        zaai.lock();
        try {
            if (zaaj == null) {
                zaaj = new Storage(context.getApplicationContext());
            }
            Storage storage = zaaj;
            return storage;
        }
        finally {
            zaai.unlock();
        }
    }

    @VisibleForTesting
    private Storage(Context context) {
        this.zaal = context.getSharedPreferences("com.google.android.gms.signin", 0);
    }

    @KeepForSdk
    public void saveDefaultGoogleSignInAccount(GoogleSignInAccount googleSignInAccount, GoogleSignInOptions googleSignInOptions) {
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount));
        Preconditions.checkNotNull((Object)googleSignInOptions);
        this.zaa("defaultGoogleSignInAccount", googleSignInAccount.zab());
        GoogleSignInOptions googleSignInOptions2 = googleSignInOptions;
        GoogleSignInAccount googleSignInAccount2 = googleSignInAccount;
        Storage storage = this;
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount2));
        Preconditions.checkNotNull((Object)googleSignInOptions2);
        String string = googleSignInAccount2.zab();
        storage.zaa(Storage.zab("googleSignInAccount", string), googleSignInAccount2.zac());
        storage.zaa(Storage.zab("googleSignInOptions", string), googleSignInOptions2.zae());
    }

    private final void zaa(String string, String string2) {
        this.zaak.lock();
        try {
            this.zaal.edit().putString(string, string2).apply();
            return;
        }
        finally {
            this.zaak.unlock();
        }
    }

    @Nullable
    @KeepForSdk
    public GoogleSignInAccount getSavedDefaultGoogleSignInAccount() {
        String string = this.zaf("defaultGoogleSignInAccount");
        return this.zad(string);
    }

    @Nullable
    @VisibleForTesting
    private final GoogleSignInAccount zad(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = this.zaf(Storage.zab("googleSignInAccount", string));
        try {
            if (string2 != null) {
                return GoogleSignInAccount.zaa(string2);
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    @KeepForSdk
    public GoogleSignInOptions getSavedDefaultGoogleSignInOptions() {
        String string = this.zaf("defaultGoogleSignInAccount");
        return this.zae(string);
    }

    @Nullable
    @VisibleForTesting
    private final GoogleSignInOptions zae(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = this.zaf(Storage.zab("googleSignInOptions", string));
        try {
            if (string2 != null) {
                return GoogleSignInOptions.zab(string2);
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    @KeepForSdk
    public String getSavedRefreshToken() {
        return this.zaf("refreshToken");
    }

    @Nullable
    private final String zaf(String string) {
        this.zaak.lock();
        try {
            String string2 = this.zaal.getString(string, null);
            return string2;
        }
        finally {
            this.zaak.unlock();
        }
    }

    public final void zaf() {
        String string = this.zaf("defaultGoogleSignInAccount");
        this.zag("defaultGoogleSignInAccount");
        String string2 = string;
        Storage storage = this;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            storage.zag(Storage.zab("googleSignInAccount", string2));
            storage.zag(Storage.zab("googleSignInOptions", string2));
        }
    }

    private final void zag(String string) {
        this.zaak.lock();
        try {
            this.zaal.edit().remove(string).apply();
            return;
        }
        finally {
            this.zaak.unlock();
        }
    }

    @KeepForSdk
    public void clear() {
        this.zaak.lock();
        try {
            this.zaal.edit().clear().apply();
            return;
        }
        finally {
            this.zaak.unlock();
        }
    }

    private static String zab(String string, String string2) {
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }
}

