/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public class DataBufferRef {
    @KeepForSdk
    protected final DataHolder mDataHolder;
    @KeepForSdk
    protected int mDataRow;
    private int zalu;

    @KeepForSdk
    public DataBufferRef(DataHolder dataHolder, int n) {
        this.mDataHolder = (DataHolder)Preconditions.checkNotNull((Object)dataHolder);
        this.zag(n);
    }

    @KeepForSdk
    protected int getDataRow() {
        return this.mDataRow;
    }

    protected final void zag(int n) {
        Preconditions.checkState((n >= 0 && n < this.mDataHolder.getCount() ? 1 : 0) != 0);
        this.mDataRow = n;
        this.zalu = this.mDataHolder.getWindowIndex(this.mDataRow);
    }

    @KeepForSdk
    public boolean isDataValid() {
        return !this.mDataHolder.isClosed();
    }

    @KeepForSdk
    public boolean hasColumn(String string2) {
        return this.mDataHolder.hasColumn(string2);
    }

    @KeepForSdk
    protected long getLong(String string2) {
        return this.mDataHolder.getLong(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected int getInteger(String string2) {
        return this.mDataHolder.getInteger(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected boolean getBoolean(String string2) {
        return this.mDataHolder.getBoolean(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected String getString(String string2) {
        return this.mDataHolder.getString(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected float getFloat(String string2) {
        return this.mDataHolder.zaa(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected double getDouble(String string2) {
        return this.mDataHolder.zab(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected byte[] getByteArray(String string2) {
        return this.mDataHolder.getByteArray(string2, this.mDataRow, this.zalu);
    }

    @KeepForSdk
    protected Uri parseUri(String string2) {
        String string3 = string2;
        int n = this.mDataRow;
        int n2 = this.zalu;
        String string4 = this.mDataHolder.getString(string3, n, n2);
        if (string4 == null) {
            return null;
        }
        return Uri.parse((String)string4);
    }

    @KeepForSdk
    protected void copyToBuffer(String string2, CharArrayBuffer charArrayBuffer) {
        this.mDataHolder.zaa(string2, this.mDataRow, this.zalu, charArrayBuffer);
    }

    @KeepForSdk
    protected boolean hasNull(String string2) {
        return this.mDataHolder.hasNull(string2, this.mDataRow, this.zalu);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mDataRow, this.zalu, this.mDataHolder});
    }

    public boolean equals(Object object) {
        if (object instanceof DataBufferRef) {
            DataBufferRef dataBufferRef = (DataBufferRef)object;
            return Objects.equal((Object)dataBufferRef.mDataRow, (Object)this.mDataRow) && Objects.equal((Object)dataBufferRef.zalu, (Object)this.zalu) && dataBufferRef.mDataHolder == this.mDataHolder;
        }
        return false;
    }
}

