/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.Freezable;
import java.util.ArrayList;

public final class DataBufferUtils {
    @KeepForSdk
    public static final String KEY_NEXT_PAGE_TOKEN = "next_page_token";
    @KeepForSdk
    public static final String KEY_PREV_PAGE_TOKEN = "prev_page_token";

    private DataBufferUtils() {
    }

    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(DataBuffer<E> dataBuffer) {
        ArrayList arrayList = new ArrayList(dataBuffer.getCount());
        try {
            for (Freezable freezable : dataBuffer) {
                arrayList.add(freezable.freeze());
            }
        }
        finally {
            dataBuffer.close();
        }
        return arrayList;
    }

    public static boolean hasNextPage(DataBuffer<?> dataBuffer) {
        Bundle bundle = dataBuffer.getMetadata();
        return bundle != null && bundle.getString(KEY_NEXT_PAGE_TOKEN) != null;
    }

    public static boolean hasPrevPage(DataBuffer<?> dataBuffer) {
        Bundle bundle = dataBuffer.getMetadata();
        return bundle != null && bundle.getString(KEY_PREV_PAGE_TOKEN) != null;
    }

    public static boolean hasData(DataBuffer<?> dataBuffer) {
        return dataBuffer != null && dataBuffer.getCount() > 0;
    }
}

