/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zap;

@KeepForSdk
public final class ListenerHolder<L> {
    private final zaa zaa;
    @Nullable
    private volatile L zab;
    @Nullable
    private volatile ListenerKey<L> zac;

    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L l, @NonNull String string2) {
        this.zaa = new zaa(looper);
        this.zab = Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        this.zac = new ListenerKey<L>(l, Preconditions.checkNotEmpty((String)string2));
    }

    @KeepForSdk
    public final void notifyListener(@RecentlyNonNull Notifier<? super L> notifier) {
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        Message message = this.zaa.obtainMessage(1, notifier);
        this.zaa.sendMessage(message);
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean hasListener() {
        return this.zab != null;
    }

    @KeepForSdk
    public final void clear() {
        this.zab = null;
        this.zac = null;
    }

    @RecentlyNullable
    @KeepForSdk
    public final ListenerKey<L> getListenerKey() {
        return this.zac;
    }

    @KeepForSdk
    final void notifyListenerInternal(Notifier<? super L> notifier) {
        L l = this.zab;
        if (l == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(l);
            return;
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final L zaa;
        private final String zab;

        @KeepForSdk
        ListenerKey(L l, String string2) {
            this.zaa = l;
            this.zab = string2;
        }

        @KeepForSdk
        @RecentlyNonNull
        public final boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ListenerKey)) {
                return false;
            }
            ListenerKey listenerKey = (ListenerKey)object;
            return this.zaa == listenerKey.zaa && this.zab.equals(listenerKey.zab);
        }

        @KeepForSdk
        @RecentlyNonNull
        public final int hashCode() {
            return System.identityHashCode(this.zaa) * 31 + this.zab.hashCode();
        }
    }

    private final class zaa
    extends zap {
        public zaa(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            Preconditions.checkArgument((message.what == 1 ? 1 : 0) != 0);
            Notifier notifier = (Notifier)message.obj;
            ListenerHolder.this.notifyListenerInternal(notifier);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(@RecentlyNonNull L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

