/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zar;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zac;
import com.google.android.gms.signin.internal.zae;
import com.google.android.gms.signin.internal.zah;
import com.google.android.gms.signin.internal.zak;
import com.google.android.gms.signin.internal.zam;
import com.google.android.gms.signin.zad;

@KeepForSdk
public class SignInClientImpl
extends GmsClient<zae>
implements zad {
    private final boolean zaa;
    private final ClientSettings zab;
    private final Bundle zac;
    @Nullable
    private final Integer zad;

    public SignInClientImpl(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull boolean bl, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull Bundle bundle, @RecentlyNonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @RecentlyNonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zaa = bl;
        this.zab = clientSettings;
        this.zac = bundle;
        this.zad = clientSettings.zad();
    }

    public SignInClientImpl(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull boolean bl, @RecentlyNonNull ClientSettings clientSettings, @RecentlyNonNull SignInOptions signInOptions, @RecentlyNonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @RecentlyNonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, true, clientSettings, SignInClientImpl.createBundleFromClientSettings(clientSettings), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    @RecentlyNonNull
    public boolean requiresSignIn() {
        return this.zaa;
    }

    @Override
    public final void zaa(@RecentlyNonNull IAccountAccessor iAccountAccessor, @RecentlyNonNull boolean bl) {
        try {
            ((zae)this.getService()).zaa(iAccountAccessor, (Integer)Preconditions.checkNotNull((Object)this.zad), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zaa() {
        try {
            ((zae)this.getService()).zaa((Integer)Preconditions.checkNotNull((Object)this.zad));
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zaa(zac zac2) {
        Preconditions.checkNotNull((Object)zac2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            SignInClientImpl signInClientImpl = this;
            Account account = signInClientImpl.zab.getAccountOrDefault();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = Storage.getInstance(signInClientImpl.getContext()).getSavedDefaultGoogleSignInAccount();
            }
            zar zar2 = new zar(account, (Integer)Preconditions.checkNotNull((Object)signInClientImpl.zad), googleSignInAccount);
            ((zae)this.getService()).zaa(new zak(zar2), zac2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zac2.zaa(new zam(8));
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    @RecentlyNonNull
    protected String getStartServiceAction() {
        return "com.google.android.gms.signin.service.START";
    }

    @RecentlyNonNull
    protected String getServiceDescriptor() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    @RecentlyNonNull
    protected Bundle getGetServiceRequestExtraArgs() {
        String string2 = this.zab.getRealClientPackageName();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.zac.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zab.getRealClientPackageName());
        }
        return this.zac;
    }

    @Override
    public final void zab() {
        this.connect((BaseGmsClient.ConnectionProgressReportCallbacks)new BaseGmsClient.LegacyClientCallbackAdapter((BaseGmsClient)this));
    }

    @KeepForSdk
    @RecentlyNonNull
    public static Bundle createBundleFromClientSettings(@RecentlyNonNull ClientSettings clientSettings) {
        SignInOptions signInOptions = clientSettings.zac();
        Integer n = clientSettings.zad();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)clientSettings.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (signInOptions != null) {
            SignInOptions signInOptions2 = signInOptions;
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", false);
            signInOptions2 = signInOptions;
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", false);
            signInOptions2 = signInOptions;
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", null);
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            signInOptions2 = signInOptions;
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", false);
            signInOptions2 = signInOptions;
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", null);
            signInOptions2 = signInOptions;
            bundle.putString("com.google.android.gms.signin.internal.logSessionId", null);
            signInOptions2 = signInOptions;
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", false);
            signInOptions2 = signInOptions;
            Long l = null;
            if (null != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", l.longValue());
            }
            signInOptions2 = signInOptions;
            Long l2 = null;
            if (null != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", l2.longValue());
            }
        }
        return bundle;
    }

    @Override
    @RecentlyNonNull
    public int getMinApkVersion() {
        return 12451000;
    }

    @RecentlyNonNull
    protected /* synthetic */ IInterface createServiceInterface(@RecentlyNonNull IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (iInterface instanceof zae) {
            return (zae)iInterface;
        }
        return new zah(iBinder2);
    }
}

