/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.NonGmsServiceBrokerClient;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zabl;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zaco;
import com.google.android.gms.common.api.zac;
import com.google.android.gms.common.api.zad;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

@KeepForSdk
public abstract class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context zab;
    @Nullable
    private final String zac;
    private final Api<O> zad;
    private final O zae;
    private final ApiKey<O> zaf;
    private final Looper zag;
    private final int zah;
    @NotOnlyInitialized
    private final GoogleApiClient zai;
    private final StatusExceptionMapper zaj;
    @RecentlyNonNull
    protected final GoogleApiManager zaa;

    @Deprecated
    @KeepForSdk
    public GoogleApi(@RecentlyNonNull Context context, @RecentlyNonNull Api<O> api, @RecentlyNonNull O o, @RecentlyNonNull Looper looper, @RecentlyNonNull StatusExceptionMapper statusExceptionMapper) {
        Settings.Builder builder = new Settings.Builder();
        builder.setLooper(looper);
        builder.setMapper(statusExceptionMapper);
        this(context, api, o, builder.build());
    }

    @MainThread
    @KeepForSdk
    public GoogleApi(@RecentlyNonNull Activity activity, @RecentlyNonNull Api<O> zabp2, @RecentlyNonNull O o, @RecentlyNonNull Settings settings) {
        Preconditions.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        Preconditions.checkNotNull(zabp2, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zab = activity.getApplicationContext();
        this.zac = GoogleApi.zaf(activity);
        this.zad = zabp2;
        this.zae = o;
        this.zag = settings.zab;
        this.zaf = ApiKey.zaa(this.zad, this.zae, this.zac);
        this.zai = zabp2 = new zabp(this);
        this.zaa = GoogleApiManager.zaa(this.zab);
        this.zah = this.zaa.zac();
        this.zaj = settings.zaa;
        if (!(activity instanceof GoogleApiActivity) && Looper.myLooper() == Looper.getMainLooper()) {
            zaab.zaa(activity, this.zaa, this.zaf);
        }
        this.zaa.zad(this);
    }

    @KeepForSdk
    public GoogleApi(@RecentlyNonNull Context object, @RecentlyNonNull Api<O> api, @RecentlyNonNull O o, @RecentlyNonNull Settings settings) {
        Preconditions.checkNotNull((Object)object, (Object)"Null context is not permitted.");
        Preconditions.checkNotNull(api, (Object)"Api must not be null.");
        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zab = object.getApplicationContext();
        this.zac = GoogleApi.zaf(object);
        this.zad = api;
        this.zae = o;
        this.zag = settings.zab;
        this.zaf = ApiKey.zaa(this.zad, this.zae, this.zac);
        super(this);
        this.zai = object;
        this.zaa = GoogleApiManager.zaa(this.zab);
        this.zah = this.zaa.zac();
        this.zaj = settings.zaa;
        this.zaa.zad(this);
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@RecentlyNonNull Activity activity, @RecentlyNonNull Api<O> api, @RecentlyNonNull O o, @RecentlyNonNull StatusExceptionMapper statusExceptionMapper) {
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper(statusExceptionMapper);
        builder.setLooper(activity.getMainLooper());
        this(activity, api, o, builder.build());
    }

    @Deprecated
    @KeepForSdk
    public GoogleApi(@RecentlyNonNull Context context, @RecentlyNonNull Api<O> api, @RecentlyNonNull O o, @RecentlyNonNull StatusExceptionMapper statusExceptionMapper) {
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper(statusExceptionMapper);
        this(context, api, o, builder.build());
    }

    @KeepForSdk
    @RecentlyNonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(@RecentlyNonNull T t) {
        this.zad(0, t);
        return t;
    }

    @KeepForSdk
    @RecentlyNonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(@RecentlyNonNull TaskApiCall<A, TResult> taskApiCall) {
        return this.zae(0, taskApiCall);
    }

    @KeepForSdk
    @RecentlyNonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(@RecentlyNonNull T t) {
        this.zad(1, t);
        return t;
    }

    @KeepForSdk
    @RecentlyNonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(@RecentlyNonNull TaskApiCall<A, TResult> taskApiCall) {
        return this.zae(1, taskApiCall);
    }

    @KeepForSdk
    @RecentlyNonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(@RecentlyNonNull T t) {
        this.zad(2, t);
        return t;
    }

    @KeepForSdk
    @RecentlyNonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(@RecentlyNonNull TaskApiCall<A, TResult> taskApiCall) {
        return this.zae(2, taskApiCall);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(@RecentlyNonNull T t, @RecentlyNonNull U u) {
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull(u);
        Preconditions.checkNotNull(t.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(u.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkArgument((boolean)Objects.equal(t.getListenerKey(), u.getListenerKey()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zaa.zan(this, t, u, com.google.android.gms.common.api.zac.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(@RecentlyNonNull RegistrationMethods<A, ?> registrationMethods) {
        Preconditions.checkNotNull(registrationMethods);
        Preconditions.checkNotNull(registrationMethods.register.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(registrationMethods.zaa.getListenerKey(), (Object)"Listener has already been released.");
        return this.zaa.zan(this, registrationMethods.register, registrationMethods.zaa, registrationMethods.zab);
    }

    @KeepForSdk
    @RecentlyNonNull
    public Task<Boolean> doUnregisterEventListener(@RecentlyNonNull ListenerHolder.ListenerKey<?> listenerKey) {
        return this.doUnregisterEventListener(listenerKey, 0);
    }

    @KeepForSdk
    @RecentlyNonNull
    public Task<Boolean> doUnregisterEventListener(@RecentlyNonNull ListenerHolder.ListenerKey<?> listenerKey, int n) {
        Preconditions.checkNotNull(listenerKey, (Object)"Listener key cannot be null.");
        return this.zaa.zao(this, listenerKey, n);
    }

    @KeepForSdk
    @RecentlyNonNull
    public <L> ListenerHolder<L> registerListener(@RecentlyNonNull L l, @RecentlyNonNull String string2) {
        return ListenerHolders.createListenerHolder(l, this.zag, string2);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected Task<Boolean> disconnectService() {
        return this.zaa.zaj(this);
    }

    @KeepForSdk
    @RecentlyNonNull
    public O getApiOptions() {
        return this.zae;
    }

    @Override
    @RecentlyNonNull
    public final ApiKey<O> getApiKey() {
        return this.zaf;
    }

    @KeepForSdk
    @RecentlyNonNull
    public GoogleApiClient asGoogleApiClient() {
        return this.zai;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Looper getLooper() {
        return this.zag;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Context getApplicationContext() {
        return this.zab;
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNullable
    protected String getContextFeatureId() {
        return this.zac;
    }

    @KeepForSdk
    @RecentlyNullable
    protected String getContextAttributionTag() {
        return this.zac;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @RecentlyNonNull
    protected ClientSettings.Builder createClientSettingsBuilder() {
        void var1_9;
        void var1_5;
        GoogleSignInAccount googleSignInAccount;
        ClientSettings.Builder builder = new ClientSettings.Builder();
        O o = this.zae;
        if (o instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)o).getGoogleSignInAccount()) != null) {
            Account account = googleSignInAccount.getAccount();
        } else {
            O o2 = this.zae;
            if (o2 instanceof Api.ApiOptions.HasAccountOptions) {
                Account account = ((Api.ApiOptions.HasAccountOptions)o2).getAccount();
            } else {
                Object var1_15 = null;
            }
        }
        builder.zaa((Account)var1_5);
        O o3 = this.zae;
        if (o3 instanceof Api.ApiOptions.HasGoogleSignInAccountOptions) {
            GoogleSignInAccount googleSignInAccount2 = ((Api.ApiOptions.HasGoogleSignInAccountOptions)o3).getGoogleSignInAccount();
            if (googleSignInAccount2 == null) {
                Set set = Collections.emptySet();
            } else {
                Set<Scope> set = googleSignInAccount2.getRequestedScopes();
            }
        } else {
            Set set = Collections.emptySet();
        }
        builder.zab((Collection<Scope>)var1_9);
        builder.zac(this.zab.getClass().getName());
        builder.setRealClientPackageName(this.zab.getPackageName());
        return builder;
    }

    private final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zad(int n, @NonNull T t) {
        t.zak();
        this.zaa.zak(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.AnyClient> Task<TResult> zae(int n, @NonNull TaskApiCall<A, TResult> taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zaa.zal(this, n, taskApiCall, taskCompletionSource, this.zaj);
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final Api.Client zaa(Looper object, zabl<O> zabl2) {
        Object object2 = ((GoogleApi)this).createClientSettingsBuilder();
        object2 = ((ClientSettings.Builder)object2).build();
        object = ((Api.AbstractClientBuilder)Preconditions.checkNotNull(((GoogleApi)this).zad.zab())).buildClient(((GoogleApi)this).zab, (Looper)object, (ClientSettings)object2, ((GoogleApi)this).zae, zabl2, zabl2);
        if ((this = ((GoogleApi)this).getContextAttributionTag()) != null && object instanceof BaseGmsClient) {
            ((BaseGmsClient)object).setAttributionTag((String)this);
        }
        if (this != null && object instanceof NonGmsServiceBrokerClient) {
            ((NonGmsServiceBrokerClient)object).zaa((String)this);
        }
        return object;
    }

    public final int zab() {
        return this.zah;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static String zaf(Object object) {
        if (!PlatformVersion.isAtLeastR()) return null;
        try {
            return (String)Context.class.getMethod("getAttributionTag", new Class[0]).invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public final zaco zac(Context context, Handler handler) {
        zaco zaco2 = new zaco(context, handler, this.createClientSettingsBuilder().build());
        return zaco2;
    }

    @KeepForSdk
    public static class Settings {
        @KeepForSdk
        @RecentlyNonNull
        public static final Settings DEFAULT_SETTINGS;
        @RecentlyNonNull
        public final StatusExceptionMapper zaa;
        @RecentlyNonNull
        public final Looper zab;

        @KeepForSdk
        private Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper) {
            this.zaa = statusExceptionMapper;
            this.zab = looper;
        }

        static {
            Builder builder = new Builder();
            DEFAULT_SETTINGS = builder.build();
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, zad zad2) {
            this(statusExceptionMapper, null, looper);
        }

        @KeepForSdk
        public static class Builder {
            private StatusExceptionMapper zaa;
            private Looper zab;

            @KeepForSdk
            public Builder() {
            }

            @KeepForSdk
            @RecentlyNonNull
            public Builder setMapper(@RecentlyNonNull StatusExceptionMapper statusExceptionMapper) {
                Preconditions.checkNotNull((Object)statusExceptionMapper, (Object)"StatusExceptionMapper must not be null.");
                this.zaa = statusExceptionMapper;
                return this;
            }

            @KeepForSdk
            @RecentlyNonNull
            public Builder setLooper(@RecentlyNonNull Looper looper) {
                Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
                this.zab = looper;
                return this;
            }

            @KeepForSdk
            @RecentlyNonNull
            public Settings build() {
                Object object;
                if (this.zaa == null) {
                    object = new ApiExceptionMapper();
                    this.zaa = object;
                }
                if (this.zab == null) {
                    this.zab = Looper.getMainLooper();
                }
                object = new Settings(this.zaa, null, this.zab, null);
                return object;
            }
        }
    }
}

