/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.zae;
import com.google.android.gms.common.api.zaf;
import com.google.android.gms.common.api.zag;
import com.google.android.gms.common.internal.Preconditions;

public final class PendingResults {
    @KeepForSdk
    @RecentlyNonNull
    public static PendingResult<Status> immediatePendingResult(@RecentlyNonNull Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static PendingResult<Status> immediatePendingResult(@RecentlyNonNull Status status, @RecentlyNonNull GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull((Object)status, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(googleApiClient);
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> PendingResult<R> immediateFailedResult(@RecentlyNonNull R r, @RecentlyNonNull GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        Preconditions.checkArgument((boolean)(r.getStatus().isSuccess() ^ true), (Object)"Status code must not be SUCCESS");
        zaf<R> zaf2 = new zaf<R>(googleApiClient, r);
        zaf2.setResult(r);
        return zaf2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@RecentlyNonNull R object) {
        Preconditions.checkNotNull(object, (Object)"Result must not be null");
        zag<R> zag2 = new zag<R>(null);
        zag2.setResult(object);
        object = new Object(zag2);
        return object;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@RecentlyNonNull R object, @RecentlyNonNull GoogleApiClient googleApiClient) {
        Preconditions.checkNotNull(object, (Object)"Result must not be null");
        zag<R> zag2 = new zag<R>(googleApiClient);
        zag2.setResult(object);
        object = new Object(zag2);
        return object;
    }

    @RecentlyNonNull
    public static PendingResult<Status> canceledPendingResult() {
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.cancel();
        return statusPendingResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static <R extends Result> PendingResult<R> canceledPendingResult(@RecentlyNonNull R r) {
        Preconditions.checkNotNull(r, (Object)"Result must not be null");
        boolean bl = r.getStatus().getStatusCode() == 16;
        Preconditions.checkArgument((boolean)bl, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zae<R> zae2 = new zae<R>(r);
        zae2.cancel();
        return zae2;
    }

    @KeepForSdk
    private PendingResults() {
    }
}

