/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

@KeepForSdk
public class ListenerHolders {
    private final Set<ListenerHolder<?>> zaa;

    public ListenerHolders() {
        WeakHashMap weakHashMap = new WeakHashMap();
        this.zaa = Collections.newSetFromMap(weakHashMap);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <L> ListenerHolder<L> createListenerHolder(@RecentlyNonNull L l, @RecentlyNonNull Looper looper, @RecentlyNonNull String string2) {
        Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null");
        Preconditions.checkNotNull((Object)string2, (Object)"Listener type must not be null");
        ListenerHolder<L> listenerHolder = new ListenerHolder<L>(looper, l, string2);
        return listenerHolder;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <L> ListenerHolder.ListenerKey<L> createListenerKey(@RecentlyNonNull L l, @RecentlyNonNull String string2) {
        Preconditions.checkNotNull(l, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)string2, (Object)"Listener type must not be null");
        Preconditions.checkNotEmpty((String)string2, (Object)"Listener type must not be empty");
        ListenerHolder.ListenerKey<L> listenerKey = new ListenerHolder.ListenerKey<L>(l, string2);
        return listenerKey;
    }

    @RecentlyNonNull
    public final <L> ListenerHolder<L> zaa(@RecentlyNonNull L object, @RecentlyNonNull Looper looper, @RecentlyNonNull String string2) {
        object = ListenerHolders.createListenerHolder(object, looper, "NO_TYPE");
        this.zaa.add((ListenerHolder<?>)object);
        return object;
    }

    public final void zab() {
        Iterator<ListenerHolder<?>> iterator = this.zaa.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
        this.zaa.clear();
    }
}

