/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

@KeepForSdk
public class DataBufferIterator<T>
implements Iterator<T> {
    @RecentlyNonNull
    protected final DataBuffer<T> zaa;
    protected int zab;

    public DataBufferIterator(@RecentlyNonNull DataBuffer<T> dataBuffer) {
        this.zaa = (DataBuffer)Preconditions.checkNotNull(dataBuffer);
        this.zab = -1;
    }

    @Override
    public final boolean hasNext() {
        return this.zab < this.zaa.getCount() + -1;
    }

    @Override
    @RecentlyNonNull
    public T next() {
        int n;
        if (!this.hasNext()) {
            int n2 = this.zab;
            StringBuilder stringBuilder = new StringBuilder(46);
            stringBuilder.append("Cannot advance the iterator beyond ");
            stringBuilder.append(n2);
            NoSuchElementException noSuchElementException = new NoSuchElementException(stringBuilder.toString());
            throw noSuchElementException;
        }
        DataBuffer<T> dataBuffer = this.zaa;
        this.zab = n = this.zab + 1;
        return dataBuffer.get(n);
    }

    @Override
    public final void remove() {
        Object object = new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
        throw object;
    }
}

