/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zak
implements Handler.Callback {
    @NotOnlyInitialized
    private final zaj zab;
    private final ArrayList zac;
    @VisibleForTesting
    final ArrayList zaa;
    private final ArrayList zad;
    private volatile boolean zae;
    private final AtomicInteger zaf;
    private boolean zag;
    private final Handler zah;
    private final Object zai;

    public zak(Looper looper, zaj object) {
        Object object2 = new ArrayList();
        this.zac = object2;
        object2 = new ArrayList();
        this.zaa = object2;
        object2 = new ArrayList();
        this.zad = object2;
        this.zae = false;
        super(0);
        this.zaf = object2;
        this.zag = false;
        this.zai = object2 = new Object();
        this.zab = object;
        super(looper, this);
        this.zah = object;
    }

    public final void zaa() {
        this.zae = false;
        this.zaf.incrementAndGet();
    }

    public final void zab() {
        this.zae = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zac(ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onConnectionFailure must only be called on the Handler thread");
        this.zah.removeMessages(1);
        Object object = this.zai;
        synchronized (object) {
            boolean bl;
            Object object2 = new ArrayList(this.zad);
            int n = this.zaf.get();
            object2 = ((ArrayList)object2).iterator();
            while (bl = object2.hasNext()) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = (GoogleApiClient.OnConnectionFailedListener)object2.next();
                int n2 = this.zae;
                if (n2 == 0) return;
                n2 = this.zaf.get();
                if (n2 != n) {
                    return;
                }
                n2 = this.zad.contains(onConnectionFailedListener) ? 1 : 0;
                if (n2 == 0) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zad(@Nullable Bundle bundle) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zai;
        synchronized (object) {
            boolean bl = this.zag;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState((boolean)(bl ^= true));
                this.zah.removeMessages(1);
                this.zag = true;
                Preconditions.checkState((boolean)this.zaa.isEmpty());
                Object object2 = new ArrayList(this.zac);
                int n = this.zaf.get();
                object2 = ((ArrayList)object2).iterator();
                while (true) {
                    int n2;
                    GoogleApiClient.ConnectionCallbacks connectionCallbacks;
                    block9: {
                        block8: {
                            boolean bl2;
                            if (!(bl2 = object2.hasNext())) break block8;
                            connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)object2.next();
                            n2 = this.zae;
                            if (n2 != 0 && (n2 = this.zab.isConnected()) != 0 && (n2 = this.zaf.get()) == n) break block9;
                        }
                        this.zaa.clear();
                        this.zag = false;
                        return;
                    }
                    n2 = this.zaa.contains(connectionCallbacks) ? 1 : 0;
                    if (n2 != 0) continue;
                    connectionCallbacks.onConnected(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zae(int n) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.zah.removeMessages(1);
        Object object = this.zai;
        synchronized (object) {
            this.zag = true;
            Object object2 = new ArrayList(this.zac);
            int n2 = this.zaf.get();
            object2 = ((ArrayList)object2).iterator();
            while (true) {
                int n3;
                GoogleApiClient.ConnectionCallbacks connectionCallbacks;
                block8: {
                    block7: {
                        boolean bl;
                        if (!(bl = object2.hasNext())) break block7;
                        connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)object2.next();
                        n3 = this.zae;
                        if (n3 != 0 && (n3 = this.zaf.get()) == n2) break block8;
                    }
                    this.zaa.clear();
                    this.zag = false;
                    return;
                }
                n3 = this.zac.contains(connectionCallbacks) ? 1 : 0;
                if (n3 == 0) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zaf(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = zak2.zai;
        // MONITORENTER : object
        boolean bl = zak2.zac.contains(connectionCallbacks);
        if (bl) {
            String string2 = String.valueOf(connectionCallbacks);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("registerConnectionCallbacks(): listener ");
            stringBuilder.append(string2);
            stringBuilder.append(" is already registered");
            Log.w((String)"GmsClientEvents", (String)stringBuilder.toString());
            // MONITOREXIT : object
        } else {
            zak2.zac.add(connectionCallbacks);
        }
        if (!zak2.zab.isConnected()) return;
        zak zak2 = zak2.zah;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        zak2.sendMessage(zak2.obtainMessage(1, connectionCallbacks));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zag(GoogleApiClient.OnConnectionFailedListener object) {
        Preconditions.checkNotNull((Object)object);
        Object object2 = ((zak)((Object)string2)).zai;
        synchronized (object2) {
            boolean bl = ((zak)((Object)string2)).zad.contains(object);
            if (bl) {
                String string2 = String.valueOf(object);
                object = new StringBuilder();
                ((StringBuilder)object).append("registerConnectionFailedListener(): listener ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" is already registered");
                Log.w((String)"GmsClientEvents", (String)((StringBuilder)object).toString());
            } else {
                ((zak)((Object)string2)).zad.add(object);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zah(GoogleApiClient.ConnectionCallbacks object) {
        Preconditions.checkNotNull((Object)object);
        Object object2 = ((zak)((Object)string2)).zai;
        synchronized (object2) {
            boolean bl = ((zak)((Object)string2)).zac.remove(object);
            if (!bl) {
                String string2 = String.valueOf(object);
                object = new StringBuilder();
                ((StringBuilder)object).append("unregisterConnectionCallbacks(): listener ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" not found");
                Log.w((String)"GmsClientEvents", (String)((StringBuilder)object).toString());
            } else {
                bl = ((zak)((Object)string2)).zag;
                if (!bl) return;
                ((zak)((Object)string2)).zaa.add(object);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zai(GoogleApiClient.OnConnectionFailedListener object) {
        Preconditions.checkNotNull((Object)object);
        Object object2 = this.zai;
        synchronized (object2) {
            boolean bl = this.zad.remove(object);
            if (bl) return;
            String string2 = String.valueOf(object);
            object = new StringBuilder();
            ((StringBuilder)object).append("unregisterConnectionFailedListener(): listener ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" not found");
            Log.w((String)"GmsClientEvents", (String)((StringBuilder)object).toString());
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean handleMessage(Message object) {
        if (((Message)object).what != 1) {
            int n = ((Message)object).what;
            object = new StringBuilder();
            ((StringBuilder)object).append("Don't know how to handle message: ");
            ((StringBuilder)object).append(n);
            Exception exception = new Exception();
            Log.wtf((String)"GmsClientEvents", (String)((StringBuilder)object).toString(), (Throwable)exception);
            return false;
        }
        object = (GoogleApiClient.ConnectionCallbacks)((Message)object).obj;
        Object object2 = this.zai;
        synchronized (object2) {
            boolean bl = this.zae;
            if (!bl) return true;
            bl = this.zab.isConnected();
            if (!bl) return true;
            boolean bl2 = this.zac.contains(object);
            if (!bl2) return true;
            object.onConnected(null);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zaj(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        synchronized (object) {
            return this.zac.contains(connectionCallbacks);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zak(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            return this.zad.contains(onConnectionFailedListener);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

