/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.base.zau;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zak
implements Handler.Callback {
    @NotOnlyInitialized
    private final zaj zab;
    private final ArrayList zac = new ArrayList();
    @VisibleForTesting
    final ArrayList zaa = new ArrayList();
    private final ArrayList zad = new ArrayList();
    private volatile boolean zae = false;
    private final AtomicInteger zaf = new AtomicInteger(0);
    private boolean zag = false;
    private final Handler zah;
    private final Object zai = new Object();

    public zak(Looper looper, zaj zaj2) {
        this.zab = zaj2;
        this.zah = new zau(looper, this);
    }

    public final void zaa() {
        this.zae = false;
        this.zaf.incrementAndGet();
    }

    public final void zab() {
        this.zae = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zac(ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onConnectionFailure must only be called on the Handler thread");
        this.zah.removeMessages(1);
        Object object = this.zai;
        synchronized (object) {
            boolean bl;
            int n = this.zaf.get();
            Iterator iterator = new ArrayList(this.zad).iterator();
            while (bl = iterator.hasNext()) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = (GoogleApiClient.OnConnectionFailedListener)iterator.next();
                int n2 = this.zae;
                if (n2 == 0) return;
                n2 = this.zaf.get();
                if (n2 != n) {
                    return;
                }
                n2 = this.zad.contains(onConnectionFailedListener) ? 1 : 0;
                if (n2 == 0) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zad(@Nullable Bundle bundle) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zai;
        synchronized (object) {
            int n = this.zag;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                Preconditions.checkState((n ^= 1) != 0);
                this.zah.removeMessages(1);
                this.zag = true;
                Preconditions.checkState((boolean)this.zaa.isEmpty());
                n = this.zaf.get();
                Iterator iterator = new ArrayList(this.zac).iterator();
                while (true) {
                    int n2;
                    GoogleApiClient.ConnectionCallbacks connectionCallbacks;
                    block9: {
                        block8: {
                            boolean bl;
                            if (!(bl = iterator.hasNext())) break block8;
                            connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)iterator.next();
                            n2 = this.zae;
                            if (n2 != 0 && (n2 = this.zab.isConnected()) != 0 && (n2 = this.zaf.get()) == n) break block9;
                        }
                        this.zaa.clear();
                        this.zag = false;
                        return;
                    }
                    n2 = this.zaa.contains(connectionCallbacks) ? 1 : 0;
                    if (n2 != 0) continue;
                    connectionCallbacks.onConnected(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zae(int n) {
        Preconditions.checkHandlerThread((Handler)this.zah, (String)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.zah.removeMessages(1);
        Object object = this.zai;
        synchronized (object) {
            this.zag = true;
            int n2 = this.zaf.get();
            Iterator iterator = new ArrayList(this.zac).iterator();
            while (true) {
                int n3;
                GoogleApiClient.ConnectionCallbacks connectionCallbacks;
                block8: {
                    block7: {
                        boolean bl;
                        if (!(bl = iterator.hasNext())) break block7;
                        connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)iterator.next();
                        n3 = this.zae;
                        if (n3 != 0 && (n3 = this.zaf.get()) == n2) break block8;
                    }
                    this.zaa.clear();
                    this.zag = false;
                    return;
                }
                n3 = this.zac.contains(connectionCallbacks) ? 1 : 0;
                if (n3 == 0) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zaf(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        // MONITORENTER : object
        boolean bl = this.zac.contains(connectionCallbacks);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("registerConnectionCallbacks(): listener ");
            stringBuilder.append(String.valueOf(connectionCallbacks));
            stringBuilder.append(" is already registered");
            Log.w((String)"GmsClientEvents", (String)stringBuilder.toString());
            // MONITOREXIT : object
        } else {
            this.zac.add(connectionCallbacks);
        }
        if (!this.zab.isConnected()) return;
        Handler handler = this.zah;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        handler.sendMessage(handler.obtainMessage(1, (Object)connectionCallbacks));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zag(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            boolean bl = this.zad.contains(onConnectionFailedListener);
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("registerConnectionFailedListener(): listener ");
                stringBuilder.append(String.valueOf(onConnectionFailedListener));
                stringBuilder.append(" is already registered");
                Log.w((String)"GmsClientEvents", (String)stringBuilder.toString());
            } else {
                this.zad.add(onConnectionFailedListener);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zah(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        synchronized (object) {
            boolean bl = this.zac.remove(connectionCallbacks);
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("unregisterConnectionCallbacks(): listener ");
                stringBuilder.append(String.valueOf(connectionCallbacks));
                stringBuilder.append(" not found");
                Log.w((String)"GmsClientEvents", (String)stringBuilder.toString());
            } else {
                bl = this.zag;
                if (!bl) return;
                this.zaa.add(connectionCallbacks);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zai(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            boolean bl = this.zad.remove(onConnectionFailedListener);
            if (bl) return;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unregisterConnectionFailedListener(): listener ");
            stringBuilder.append(String.valueOf(onConnectionFailedListener));
            stringBuilder.append(" not found");
            Log.w((String)"GmsClientEvents", (String)stringBuilder.toString());
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean handleMessage(Message object) {
        if (((Message)object).what != 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Don't know how to handle message: ");
            stringBuilder.append(((Message)object).what);
            String string2 = stringBuilder.toString();
            object = new Exception();
            Log.wtf((String)"GmsClientEvents", (String)string2, (Throwable)object);
            return false;
        }
        object = (GoogleApiClient.ConnectionCallbacks)((Message)object).obj;
        Object object2 = ((zak)((Object)string2)).zai;
        synchronized (object2) {
            boolean bl = ((zak)((Object)string2)).zae;
            if (!bl) return true;
            bl = ((zak)((Object)string2)).zab.isConnected();
            if (!bl) return true;
            boolean bl2 = ((zak)((Object)string2)).zac.contains(object);
            if (!bl2) return true;
            object.onConnected(null);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zaj(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        Preconditions.checkNotNull((Object)connectionCallbacks);
        Object object = this.zai;
        synchronized (object) {
            return this.zac.contains(connectionCallbacks);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zak(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        Preconditions.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.zai;
        synchronized (object) {
            return this.zad.contains(onConnectionFailedListener);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

