/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zaa;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import com.google.android.gms.dynamic.zah;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private LifecycleDelegate zaa;
    @Nullable
    private Bundle zab;
    private LinkedList zac;
    private final OnDelegateCreatedListener zad = new zaa(this);

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var3_3;
        void var1_1;
        FrameLayout frameLayout = new FrameLayout(var1_1.getContext());
        this.zaf((Bundle)var3_3, new zad(this, frameLayout, (LayoutInflater)var1_1, (ViewGroup)var2_2, (Bundle)var3_3));
        if (this.zaa == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    @NonNull
    public T getDelegate() {
        return (T)this.zaa;
    }

    @KeepForSdk
    public DeferredLifecycleHelper() {
    }

    @KeepForSdk
    protected abstract void createDelegate(@NonNull OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    protected void handleGooglePlayUnavailable(@NonNull FrameLayout parent) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(parent);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        this.zaf((Bundle)var1_1, new zac(this, (Bundle)var1_1));
    }

    @KeepForSdk
    public void onDestroy() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onDestroy();
            return;
        }
        this.zae(1);
    }

    @KeepForSdk
    public void onDestroyView() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onDestroyView();
            return;
        }
        this.zae(2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onInflate(@NonNull Activity activity, @NonNull Bundle attrs, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.zaf((Bundle)var3_3, new zab(this, (Activity)var1_1, (Bundle)var2_2, (Bundle)var3_3));
    }

    @KeepForSdk
    public void onLowMemory() {
        DeferredLifecycleHelper this_ = this_.zaa;
        if (this_ != null) {
            this_.onLowMemory();
            return;
        }
    }

    @KeepForSdk
    public void onPause() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onPause();
            return;
        }
        this.zae(5);
    }

    @KeepForSdk
    public void onResume() {
        this.zaf(null, new zag(this));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onSaveInstanceState(@NonNull Bundle outState) {
        void var1_1;
        LifecycleDelegate lifecycleDelegate = this_.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onSaveInstanceState((Bundle)var1_1);
            return;
        }
        DeferredLifecycleHelper this_ = this_.zab;
        if (this_ != null) {
            var1_1.putAll((Bundle)this_);
            return;
        }
    }

    @KeepForSdk
    public void onStart() {
        this.zaf(null, new zaf(this));
    }

    @KeepForSdk
    public void onStop() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onStop();
            return;
        }
        this.zae(4);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(@NonNull FrameLayout parent) {
        FrameLayout frameLayout;
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Context context = frameLayout.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = com.google.android.gms.common.internal.zac.zad(context, n);
        String string3 = com.google.android.gms.common.internal.zac.zac(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        LinearLayout linearLayout2 = linearLayout;
        frameLayout.addView((View)linearLayout2);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout2.addView((View)textView);
        frameLayout = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (frameLayout != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener((View.OnClickListener)new zae(context, (Intent)frameLayout));
            return;
        }
    }

    static /* bridge */ /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zaa;
    }

    static /* bridge */ /* synthetic */ LinkedList zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zac;
    }

    static /* bridge */ /* synthetic */ void zac(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zaa = lifecycleDelegate;
    }

    static /* bridge */ /* synthetic */ void zad(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zab = null;
    }

    private final void zae(int n) {
        while (!this.zac.isEmpty() && ((zah)this.zac.getLast()).zaa() >= n) {
            this.zac.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zaf(@Nullable Bundle bundle, zah zah2) {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            zah2.zab(lifecycleDelegate);
            return;
        }
        if (this.zac == null) {
            this.zac = new LinkedList();
        }
        this.zac.add(zah2);
        if (bundle != null) {
            zah2 = this.zab;
            if (zah2 == null) {
                this.zab = (Bundle)bundle.clone();
            } else {
                zah2.putAll(bundle);
            }
        }
        DeferredLifecycleHelper deferredLifecycleHelper = this;
        deferredLifecycleHelper.createDelegate(deferredLifecycleHelper.zad);
    }
}

