/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.api.zzk;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.api.zzm;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzhi;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class zzg
implements GoogleApiClient {
    private final Lock zzPR = new ReentrantLock();
    private final Condition zzQr;
    final zzj zzQs;
    private final int zzPH;
    private final int zzPI;
    private final Context mContext;
    private final Looper zzPx;
    final Queue<zze<?>> zzQt = new LinkedList();
    private volatile boolean zzQu;
    private long zzQv = 120000L;
    private long zzQw = 5000L;
    final zza zzQx;
    BroadcastReceiver zzQy;
    final Map<Api.zzc<?>, Api.zza> zzQz = new HashMap();
    final Map<Api.zzc<?>, ConnectionResult> zzQA = new HashMap();
    Set<Scope> zzQB = new HashSet<Scope>();
    final com.google.android.gms.common.internal.zze zzQg;
    final Map<Api<?>, Integer> zzQh;
    final Api.zzb<? extends zzmd, zzme> zzPK;
    private volatile zzh zzQC;
    private ConnectionResult zzQD = null;
    private final Set<zzi<?>> zzQE = Collections.newSetFromMap(new WeakHashMap());
    final Set<zze<?>> zzQF = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private final zzc zzQG = new zzc(){

        @Override
        public void zzc(zze<?> zze2) {
            zzg.this.zzQF.remove(zze2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks zzQH = new zzd(){

        @Override
        public void onConnected(Bundle connectionHint) {
            zzg.this.zzQC.onConnected(connectionHint);
        }
    };
    private final zzj.zza zzQI = new zzj.zza(){

        @Override
        public boolean isConnected() {
            return zzg.this.isConnected();
        }

        @Override
        public Bundle zzjZ() {
            return null;
        }
    };

    private final GoogleApiClient.OnConnectionFailedListener zza(final Api<?> api, final int n) {
        return new GoogleApiClient.OnConnectionFailedListener(){

            @Override
            public void onConnectionFailed(ConnectionResult result) {
                zzg.this.zzQC.zza(result, api, n);
            }
        };
    }

    public zzg(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, Api.zzb<? extends zzmd, zzme> zzb2, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n, int n2) {
        this.mContext = context;
        this.zzQs = new zzj(looper, this.zzQI);
        this.zzPx = looper;
        this.zzQx = new zza(looper);
        this.zzPH = n;
        this.zzPI = n2;
        this.zzQh = new HashMap();
        this.zzQr = this.zzPR.newCondition();
        this.zzQC = new zzf(this);
        for (GoogleApiClient.ConnectionCallbacks iterator : set) {
            this.zzQs.registerConnectionCallbacks(iterator);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.zzQs.registerConnectionFailedListener(onConnectionFailedListener);
        }
        Map<Api<?>, zze.zza> map2 = zze2.zzlI();
        for (Api<?> api : map.keySet()) {
            Api.ApiOptions apiOptions = map.get(api);
            int n3 = 0;
            if (map2.get(api) != null) {
                n3 = ((zze.zza)map2.get(api)).zzTa ? 1 : 2;
            }
            this.zzQh.put(api, n3);
            zzaa<Object> zzaa2 = api.zzkG() ? zzg.zza(api.zzkD(), (Object)apiOptions, context, looper, zze2, this.zzQH, this.zza(api, n3)) : zzg.zza(api.zzkC(), (Object)apiOptions, context, looper, zze2, this.zzQH, this.zza(api, n3));
            this.zzQz.put(api.zzkF(), zzaa2);
        }
        this.zzQg = zze2;
        this.zzPK = zzb2;
    }

    private static <C extends Api.zza, O> C zza(Api.zzb<C, O> zzb2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return zzb2.zza(context, looper, zze2, object, connectionCallbacks, onConnectionFailedListener);
    }

    private static <C extends Api.zzd, O> zzaa zza(Api.zze<C, O> zze2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zze zze3, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return new zzaa(context, looper, zze2.zzkH(), connectionCallbacks, onConnectionFailedListener, zze3, (Api.zzd)zze2.zzi(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zza, R extends Result, T extends zza.zza<R, A>> T zza(T t) {
        zzv.zzb(t.zzkF() != null, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        zzv.zzb(this.zzQz.containsKey(t.zzkF()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzPR.lock();
        try {
            T t2 = this.zzQC.zza(t);
            return t2;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zza, T extends zza.zza<? extends Result, A>> T zzb(T t) {
        zzv.zzb(t.zzkF() != null, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        this.zzPR.lock();
        try {
            if (this.zzlb()) {
                Object object;
                this.zzQt.add(t);
                while (!this.zzQt.isEmpty()) {
                    object = this.zzQt.remove();
                    this.zzb((zze<A>)object);
                    object.zzk(Status.zzQW);
                }
                object = t;
                return (T)object;
            }
            T t2 = this.zzQC.zzb(t);
            return t2;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> zzi<L> zzl(L l) {
        zzv.zzb(l, (Object)"Listener must not be null");
        this.zzPR.lock();
        try {
            zzi<L> zzi2 = new zzi<L>(this.zzPx, l);
            this.zzQE.add(zzi2);
            zzi<L> zzi3 = zzi2;
            return zzi3;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    @Override
    public <C extends Api.zza> C zza(Api.zzc<C> zzc2) {
        Api.zza zza2 = this.zzQz.get(zzc2);
        zzv.zzb(zza2, (Object)"Appropriate Api was not requested.");
        return (C)zza2;
    }

    @Override
    public boolean zza(Api<?> api) {
        return this.zzQz.containsKey(api.zzkF());
    }

    @Override
    public boolean hasConnectedApi(Api<?> api) {
        Api.zza zza2 = this.zzQz.get(api.zzkF());
        return zza2 == null ? false : zza2.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        Api.zzc<?> zzc2 = api.zzkF();
        this.zzPR.lock();
        try {
            if (!this.isConnected() && !this.zzlb()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzQz.containsKey(zzc2)) {
                if (this.zzQz.get(zzc2).isConnected()) {
                    ConnectionResult connectionResult = ConnectionResult.zzOI;
                    return connectionResult;
                }
                if (this.zzQA.containsKey(zzc2)) {
                    ConnectionResult connectionResult = this.zzQA.get(zzc2);
                    return connectionResult;
                }
                Log.wtf((String)"GoogleApiClientImpl", (String)(api.getName() + " requested in getConnectionResult" + " is not connected but is not present in the failed connections map"));
                ConnectionResult connectionResult = new ConnectionResult(8, null);
                return connectionResult;
            }
        }
        finally {
            this.zzPR.unlock();
        }
        throw new IllegalArgumentException(api.getName() + " was never registered with GoogleApiClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zza(Scope scope) {
        this.zzPR.lock();
        try {
            boolean bl = this.isConnected() && this.zzQB.contains(scope);
            return bl;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzPR.lock();
        try {
            this.zzQC.connect();
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        zzv.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzPR.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.zzQr.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.zzPR.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzOI;
                return connectionResult;
            }
            if (this.zzQD != null) {
                ConnectionResult connectionResult = this.zzQD;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        zzv.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzPR.lock();
        try {
            this.connect();
            long l = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l = this.zzQr.awaitNanos(l);
                    if (l > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzOI;
                return connectionResult;
            }
            if (this.zzQD != null) {
                ConnectionResult connectionResult = this.zzQD;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zzld();
        this.zzav(-1);
    }

    void zzkX() {
        for (zze<?> object : this.zzQF) {
            object.zza(null);
            object.cancel();
        }
        this.zzQF.clear();
        for (zzi zzi2 : this.zzQE) {
            zzi2.clear();
        }
        this.zzQE.clear();
        this.zzQB.clear();
    }

    void zzkY() {
        for (Api.zza zza2 : this.zzQz.values()) {
            zza2.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzav(int n) {
        this.zzPR.lock();
        try {
            this.zzQC.zzas(n);
        }
        finally {
            this.zzPR.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzkZ() {
        this.zzPR.lock();
        try {
            this.zzQC = new com.google.android.gms.common.api.zze(this, this.zzQg, this.zzQh, this.zzPK, this.zzPR, this.mContext);
            this.zzQC.begin();
            this.zzQr.signalAll();
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzla() {
        this.zzPR.lock();
        try {
            this.zzld();
            this.zzQC = new com.google.android.gms.common.api.zzd(this);
            this.zzQC.begin();
            this.zzQr.signalAll();
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(ConnectionResult connectionResult) {
        this.zzPR.lock();
        try {
            this.zzQD = connectionResult;
            this.zzQC = new zzf(this);
            this.zzQC.begin();
            this.zzQr.signalAll();
        }
        finally {
            this.zzPR.unlock();
        }
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzv.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        final zzk zzk2 = new zzk(this.zzPx);
        if (this.zzQz.containsKey(zzhi.zzKh)) {
            this.zza(this, zzk2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzg.this.zza((GoogleApiClient)atomicReference.get(), zzk2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    zzk2.setResult(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzhi.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzQx).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzk2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzk zzk2, final boolean bl) {
        zzhi.zzUh.zzc(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzi(Status status) {
                if (status.isSuccess() && zzg.this.isConnected()) {
                    zzg.this.reconnect();
                }
                zzk2.setResult(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzi((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        if (this.zzPH >= 0) {
            zzl.zza(lifecycleActivity).zzax(this.zzPH);
        } else if (this.zzPI >= 0) {
            zzm.zzb(lifecycleActivity).zzax(this.zzPI);
        } else {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzQC instanceof com.google.android.gms.common.api.zzd;
    }

    @Override
    public boolean isConnecting() {
        return this.zzQC instanceof com.google.android.gms.common.api.zze;
    }

    boolean zzlb() {
        return this.zzQu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzPR.lock();
        try {
            if (this.zzlb()) {
                this.connect();
            }
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlc() {
        this.zzPR.lock();
        try {
            boolean bl = this.zzld();
            if (bl) {
                this.connect();
            }
        }
        finally {
            this.zzPR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzld() {
        this.zzPR.lock();
        try {
            if (!this.zzlb()) {
                boolean bl = false;
                return bl;
            }
            this.zzQu = false;
            this.zzQx.removeMessages(2);
            this.zzQx.removeMessages(1);
            if (this.zzQy != null) {
                this.mContext.getApplicationContext().unregisterReceiver(this.zzQy);
                this.zzQy = null;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.zzPR.unlock();
        }
    }

    <A extends Api.zza> void zzb(zze<A> zze2) {
        this.zzQF.add(zze2);
        zze2.zza(this.zzQG);
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzQs.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzQs.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzQs.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzQs.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzQs.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzQs.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzPx;
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).println("GoogleApiClient:");
        String string2 = prefix + "  ";
        writer.append(string2).append("mState=").append(this.zzQC.getName());
        writer.append(" mResuming=").print(this.zzQu);
        writer.append(" mWorkQueue.size()=").print(this.zzQt.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzQF.size());
        for (Api.zza zza2 : this.zzQz.values()) {
            zza2.dump(string2, fd, writer, args);
        }
    }

    @Override
    public int getSessionId() {
        return System.identityHashCode(this);
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzg.this.zzlc();
                    break;
                }
                case 2: {
                    zzg.this.resume();
                    break;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    private static class zzb
    extends BroadcastReceiver {
        private WeakReference<zzg> zzQP;

        zzb(zzg zzg2) {
            this.zzQP = new WeakReference<zzg>(zzg2);
        }

        public void onReceive(Context context, Intent intent) {
            Uri uri = intent.getData();
            String string2 = null;
            if (uri != null) {
                string2 = uri.getSchemeSpecificPart();
            }
            if (string2 == null || !string2.equals("com.google.android.gms")) {
                return;
            }
            zzg zzg2 = (zzg)this.zzQP.get();
            if (zzg2 == null) {
                return;
            }
            zzg2.resume();
        }
    }

    public abstract class zzd
    implements GoogleApiClient.ConnectionCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            zzg.this.zzPR.lock();
            try {
                if (zzg.this.zzQC instanceof zzf) {
                    return;
                }
                switch (cause) {
                    case 2: {
                        zzg.this.zzav(cause);
                        zzg.this.connect();
                        return;
                    }
                    case 1: {
                        if (zzg.this.zzlb()) {
                            return;
                        }
                        zzg.this.zzQu = true;
                        if (zzg.this.zzQy == null) {
                            zzg.this.zzQy = new zzb(zzg.this);
                            IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
                            intentFilter.addDataScheme("package");
                            zzg.this.mContext.getApplicationContext().registerReceiver(zzg.this.zzQy, intentFilter);
                        }
                        zzg.this.zzQx.sendMessageDelayed(zzg.this.zzQx.obtainMessage(1), zzg.this.zzQv);
                        zzg.this.zzQx.sendMessageDelayed(zzg.this.zzQx.obtainMessage(2), zzg.this.zzQw);
                        zzg.this.zzav(cause);
                        return;
                    }
                }
                return;
            }
            finally {
                zzg.this.zzPR.unlock();
            }
        }
    }

    static interface zze<A extends Api.zza> {
        public void cancel();

        public Api.zzc<A> zzkF();

        public void zzb(A var1) throws DeadObjectException;

        public void forceFailureUnlessReady(Status var1);

        public void zzk(Status var1);

        public void zza(zzc var1);

        public int zzkI();
    }

    static interface zzc {
        public void zzc(zze<?> var1);
    }
}

