/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    private final int zzzH;
    private final Uri zzSr;
    private final int zzma;
    private final int zzmb;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.zzzH = versionCode;
        this.zzSr = url;
        this.zzma = width;
        this.zzmb = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.zzg(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.zzzH;
    }

    private static Uri zzg(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.zzSr;
    }

    public int getWidth() {
        return this.zzma;
    }

    public int getHeight() {
        return this.zzmb;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.zzma, this.zzmb, this.zzSr.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzSr.toString());
            jSONObject.put("width", this.zzma);
            jSONObject.put("height", this.zzmb);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return zzu.equal(this.zzSr, webImage.zzSr) && this.zzma == webImage.zzma && this.zzmb == webImage.zzmb;
    }

    public int hashCode() {
        return zzu.hashCode(this.zzSr, this.zzma, this.zzmb);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }
}

