/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzo;
import com.google.android.gms.common.internal.zzx;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzo zzo2 = new zzo(Looper.getMainLooper());
        zzo2.zza(result);
        return zzo2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzb<R> zzb2 = new zzb<R>();
        zzb2.zza(result);
        return zzb2;
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzo zzo2 = new zzo(Looper.getMainLooper());
        zzo2.cancel();
        return zzo2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzx.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends com.google.android.gms.common.api.zzb<R> {
        private final R zzaaB;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzaaB = r;
        }

        @Override
        protected R zzb(Status status) {
            if (status.getStatusCode() != this.zzaaB.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzaaB;
        }
    }

    private static final class zzb<R extends Result>
    extends com.google.android.gms.common.api.zza<R> {
        public zzb() {
            super(Looper.getMainLooper());
        }

        @Override
        protected R zzb(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

