/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlz;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class zzma {
    private static final Method zzagh = zzma.zzpZ();
    private static final Method zzagi = zzma.zzqa();
    private static final Method zzagj = zzma.zzqb();
    private static final Method zzagk = zzma.zzqc();
    private static final Method zzagl = zzma.zzqd();

    public static WorkSource zze(int n, String string2) {
        WorkSource workSource = new WorkSource();
        zzma.zza(workSource, n, string2);
        return workSource;
    }

    public static WorkSource zzj(Context context, String string2) {
        if (context == null) {
            return null;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"WorkSourceUtil", (String)("Could not find package: " + string2));
            return null;
        }
        if (applicationInfo == null) {
            Log.e((String)"WorkSourceUtil", (String)("Could not get applicationInfo from package: " + string2));
            return null;
        }
        return zzma.zze(applicationInfo.uid, string2);
    }

    public static void zza(WorkSource workSource, int n, String string2) {
        if (zzagi != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                zzagi.invoke((Object)workSource, n, string2);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource");
            }
            return;
        }
        if (zzagh != null) {
            try {
                zzagh.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource");
            }
        }
    }

    public static int zza(WorkSource workSource) {
        if (zzagj != null) {
            try {
                return (Integer)zzagj.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource");
            }
        }
        return 0;
    }

    public static String zza(WorkSource workSource, int n) {
        if (zzagl != null) {
            try {
                return (String)zzagl.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource");
            }
        }
        return null;
    }

    public static List<String> zzb(WorkSource workSource) {
        int n;
        int n2 = n = workSource == null ? 0 : zzma.zza(workSource);
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string2 = zzma.zza(workSource, i);
            if (zzlz.zzcB(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean zzaq(Context context) {
        int n = context.getPackageManager().checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName());
        return n == 0;
    }

    private static Method zzpZ() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzqa() {
        Method method = null;
        if (zzlv.zzpU()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    private static Method zzqb() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzqc() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzqd() {
        Method method = null;
        if (zzlv.zzpU()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }
}

