/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

public final class Size {
    private final int zzoG;
    private final int zzoH;

    public Size(int width, int height) {
        this.zzoG = width;
        this.zzoH = height;
    }

    public int getWidth() {
        return this.zzoG;
    }

    public int getHeight() {
        return this.zzoH;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Size) {
            Size size = (Size)obj;
            return this.zzoG == size.zzoG && this.zzoH == size.zzoH;
        }
        return false;
    }

    public String toString() {
        return this.zzoG + "x" + this.zzoH;
    }

    private static NumberFormatException zzcC(String string2) {
        throw new NumberFormatException("Invalid Size: \"" + string2 + "\"");
    }

    public static Size parseSize(String string2) throws NumberFormatException {
        if (string2 == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        int n = string2.indexOf(42);
        if (n < 0) {
            n = string2.indexOf(120);
        }
        if (n < 0) {
            throw Size.zzcC(string2);
        }
        try {
            return new Size(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.zzcC(string2);
        }
    }

    public int hashCode() {
        return this.zzoH ^ (this.zzoG << 16 | this.zzoG >>> 16);
    }
}

