/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapTeleporter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zza();
    final int mVersionCode;
    ParcelFileDescriptor zzMq;
    final int zzagd;
    private Bitmap zzaoU;
    private boolean zzaoV;
    private File zzaoW;

    BitmapTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor, int n2) {
        this.mVersionCode = n;
        this.zzMq = parcelFileDescriptor;
        this.zzagd = n2;
        this.zzaoU = null;
        this.zzaoV = false;
    }

    public BitmapTeleporter(Bitmap bitmap) {
        this.mVersionCode = 1;
        this.zzMq = null;
        this.zzagd = 0;
        this.zzaoU = bitmap;
        this.zzaoV = true;
    }

    public Bitmap zzsP() {
        if (!this.zzaoV) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzMq));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                this.zza(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zzaoU = bitmap;
            this.zzaoV = true;
        }
        return this.zzaoU;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzMq == null) {
            Bitmap bitmap = this.zzaoU;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            FileOutputStream fileOutputStream = this.zzsQ();
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                this.zza(dataOutputStream);
            }
        }
        zza.zza(this, parcel, n | 1);
        this.zzMq = null;
    }

    public void release() {
        if (!this.zzaoV) {
            try {
                this.zzMq.close();
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    public void zzd(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zzaoW = file;
    }

    private FileOutputStream zzsQ() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zzaoW == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zzaoW);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zzMq = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private void zza(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
        }
    }
}

