/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseException;

public abstract class zznp {
    public final int zzalC;
    public final int zzagd;

    public zznp(int n, int n2) {
        this.zzalC = n;
        this.zzagd = n2;
    }

    public abstract void zzb(Api.zzb var1) throws DeadObjectException;

    public abstract void zzv(@NonNull Status var1);

    public boolean cancel() {
        return true;
    }

    public void zza(SparseArray<zzpf> sparseArray) {
    }

    public static final class zzb<TResult>
    extends zznp {
        private final zzpd<Api.zzb, TResult> zzalE;
        private final TaskCompletionSource<TResult> zzalF;
        private static final Status zzalG = new Status(8, "Connection to Google Play services was lost while executing the API call.");

        public zzb(int n, int n2, zzpd<Api.zzb, TResult> zzpd2, TaskCompletionSource<TResult> taskCompletionSource) {
            super(n, n2);
            this.zzalF = taskCompletionSource;
            this.zzalE = zzpd2;
        }

        @Override
        public void zzb(Api.zzb zzb2) throws DeadObjectException {
            try {
                this.zzalE.zza(zzb2, this.zzalF);
            }
            catch (DeadObjectException deadObjectException) {
                this.zzv(zzalG);
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zzv(zzalG);
            }
        }

        @Override
        public void zzv(@NonNull Status status) {
            if (status.getStatusCode() == 8) {
                this.zzalF.setException((Exception)new FirebaseException(status.getStatusMessage()));
            } else {
                this.zzalF.setException((Exception)new FirebaseApiNotAvailableException(status.getStatusMessage()));
            }
        }
    }

    public static final class zza
    extends zznp {
        public final zznt.zza<? extends Result, Api.zzb> zzalD;

        public zza(int n, int n2, zznt.zza<? extends Result, Api.zzb> zza2) {
            super(n, n2);
            this.zzalD = zza2;
        }

        @Override
        public void zzb(Api.zzb zzb2) throws DeadObjectException {
            this.zzalD.zzb(zzb2);
        }

        @Override
        public void zzv(@NonNull Status status) {
            this.zzalD.zzx(status);
        }

        @Override
        public boolean cancel() {
            return this.zzalD.zzrH();
        }

        @Override
        public void zza(SparseArray<zzpf> sparseArray) {
            zzpf zzpf2 = (zzpf)sparseArray.get(this.zzalC);
            if (zzpf2 != null) {
                zzpf2.zzg(this.zzalD);
            }
        }
    }
}

