/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.common.util.zzs;

public final class zzph
extends Drawable
implements Drawable.Callback {
    private int zzapU = 0;
    private long zzXy;
    private int mFrom;
    private int zzapV;
    private int zzapW = 255;
    private int zzapX;
    private int zzapY = 0;
    private boolean zzapO = true;
    private boolean zzapZ;
    private zzb zzaqa;
    private Drawable zzaqb;
    private Drawable zzaqc;
    private boolean zzaqd;
    private boolean zzaqe;
    private boolean zzaqf;
    private int zzaqg;

    public zzph(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzaqh;
        }
        this.zzaqb = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaqa.zzaqk |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzaqh;
        }
        this.zzaqc = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaqa.zzaqk |= drawable3.getChangingConfigurations();
    }

    zzph(zzb zzb2) {
        this.zzaqa = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback;
        if (zzs.zzuX() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback;
        if (zzs.zzuX() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback;
        if (zzs.zzuX() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaqa.zzaqj | this.zzaqa.zzaqk;
    }

    public void setAlpha(int n) {
        if (this.zzapY == this.zzapW) {
            this.zzapY = n;
        }
        this.zzapW = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzaqb.setColorFilter(colorFilter);
        this.zzaqc.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzaqb.getIntrinsicWidth(), this.zzaqc.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzaqb.getIntrinsicHeight(), this.zzaqc.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.zzaqb.setBounds(rect);
        this.zzaqc.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaqa.zzaqj = this.getChangingConfigurations();
            return this.zzaqa;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzaqf) {
            this.zzaqg = Drawable.resolveOpacity((int)this.zzaqb.getOpacity(), (int)this.zzaqc.getOpacity());
            this.zzaqf = true;
        }
        return this.zzaqg;
    }

    public boolean canConstantState() {
        if (!this.zzaqd) {
            this.zzaqe = this.zzaqb.getConstantState() != null && this.zzaqc.getConstantState() != null;
            this.zzaqd = true;
        }
        return this.zzaqe;
    }

    public Drawable mutate() {
        if (!this.zzapZ && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaqb.mutate();
            this.zzaqc.mutate();
            this.zzapZ = true;
        }
        return this;
    }

    public Drawable zztc() {
        return this.zzaqc;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.zzapV = this.zzapW;
        this.zzapY = 0;
        this.zzapX = n;
        this.zzapU = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzapU) {
            case 1: {
                this.zzXy = SystemClock.uptimeMillis();
                bl = false;
                this.zzapU = 2;
                break;
            }
            case 2: {
                if (this.zzXy < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzXy) / (float)this.zzapX;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzapU = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzapY = (int)(0.0f + (float)(this.zzapV - 0) * f);
            }
        }
        int n = this.zzapY;
        boolean bl3 = this.zzapO;
        Drawable drawable2 = this.zzaqb;
        Drawable drawable3 = this.zzaqc;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzapW) {
                drawable3.setAlpha(this.zzapW);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzapW - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzapW);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzapW);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzph$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzph$zza zzaqh = new com.google.android.gms.internal.zzph$zza();
        private static final zza zzaqi = new zza();

        private com.google.android.gms.internal.zzph$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzaqi;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzaqh;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzaqj;
        int zzaqk;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzaqj = zzb2.zzaqj;
                this.zzaqk = zzb2.zzaqk;
            }
        }

        public Drawable newDrawable() {
            return new zzph(this);
        }

        public int getChangingConfigurations() {
            return this.zzaqj;
        }
    }
}

