/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepName
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zze();
    private final int mVersionCode;
    private final String[] zzape;
    Bundle zzapf;
    private final CursorWindow[] zzapg;
    private final int zzahG;
    private final Bundle zzaph;
    int[] zzapi;
    int zzapj;
    boolean mClosed = false;
    private Object zzapk;
    private boolean zzapl = true;
    private static final zza zzapm = new zza(new String[0], null){

        @Override
        public zza zza(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public zza zza(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.zzape = stringArray;
        this.zzapg = cursorWindowArray;
        this.zzahG = n2;
        this.zzaph = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.mVersionCode = 1;
        this.zzape = (String[])zzaa.zzz((Object)stringArray);
        this.zzapg = (CursorWindow[])zzaa.zzz((Object)cursorWindowArray);
        this.zzahG = n;
        this.zzaph = bundle;
        this.zzsT();
    }

    public void zzu(Object object) {
        this.zzapk = object;
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzape, DataHolder.zza(zza2, -1), n, bundle);
    }

    public void zzsT() {
        int n;
        this.zzapf = new Bundle();
        for (n = 0; n < this.zzape.length; ++n) {
            this.zzapf.putInt(this.zzape[n], n);
        }
        this.zzapi = new int[this.zzapg.length];
        n = 0;
        for (int i = 0; i < this.zzapg.length; ++i) {
            this.zzapi[i] = n;
            int n2 = this.zzapg[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzapg[i].getNumRows() - n3;
        }
        this.zzapj = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    String[] zzsU() {
        return this.zzape;
    }

    CursorWindow[] zzsV() {
        return this.zzapg;
    }

    public int getStatusCode() {
        return this.zzahG;
    }

    public Bundle zzsO() {
        return this.zzaph;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzape.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zzapn.size() ? zza2.zzapn : zza2.zzapn.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzape.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzape.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzape.length && bl2; ++n3) {
                    String string2 = zza2.zzape[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzape.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzg(String string2, int n) {
        if (this.zzapf == null || !this.zzapf.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzapj) {
            throw new CursorIndexOutOfBoundsException(n, this.zzapj);
        }
    }

    public boolean zzcY(String string2) {
        return this.zzapf.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzapg[n2].getLong(n, this.zzapf.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzapg[n2].getInt(n, this.zzapf.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzapg[n2].getString(n, this.zzapf.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzg(string2, n);
        Long l = this.zzapg[n2].getLong(n, this.zzapf.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzapg[n2].getFloat(n, this.zzapf.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzapg[n2].getBlob(n, this.zzapf.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzg(string2, n);
        this.zzapg[n2].copyStringToBuffer(n, this.zzapf.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzapg[n2].isNull(n, this.zzapf.getInt(string2));
    }

    public int getCount() {
        return this.zzapj;
    }

    public int zzbP(int n) {
        int n2;
        zzaa.zzai((n >= 0 && n < this.zzapj ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzapi.length; ++n2) {
            if (n >= this.zzapi[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzapi.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzapg.length; ++i) {
                    this.zzapg[i].close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.zzapl && this.zzapg.length > 0 && !this.isClosed()) {
                String string2;
                if (this.zzapk == null) {
                    String string3 = String.valueOf(this.toString());
                    string2 = string3.length() != 0 ? "internal object: ".concat(string3) : new String("internal object: ");
                } else {
                    string2 = this.zzapk.toString();
                }
                String string4 = string2;
                Log.e((String)"DataBuffer", (String)new StringBuilder(161 + String.valueOf(string4).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (").append(string4).append(")").toString());
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzb(String[] stringArray) {
        return new zza(stringArray, null);
    }

    public static DataHolder zzbQ(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zzapm, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzape;
        private final ArrayList<HashMap<String, Object>> zzapn;
        private final String zzapo;
        private final HashMap<Object, Integer> zzapp;
        private boolean zzapq;
        private String zzapr;

        private zza(String[] stringArray, String string2) {
            this.zzape = (String[])zzaa.zzz((Object)stringArray);
            this.zzapn = new ArrayList();
            this.zzapo = string2;
            this.zzapp = new HashMap();
            this.zzapq = false;
            this.zzapr = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            com.google.android.gms.common.internal.zzb.zzv(hashMap);
            int n = this.zzb(hashMap);
            if (n == -1) {
                this.zzapn.add(hashMap);
            } else {
                this.zzapn.remove(n);
                this.zzapn.add(n, hashMap);
            }
            this.zzapq = false;
            return this;
        }

        private int zzb(HashMap<String, Object> hashMap) {
            if (this.zzapo == null) {
                return -1;
            }
            Object object = hashMap.get(this.zzapo);
            if (object == null) {
                return -1;
            }
            Integer n = this.zzapp.get(object);
            if (n == null) {
                this.zzapp.put(object, this.zzapn.size());
                return -1;
            }
            return n;
        }

        public zza zza(ContentValues contentValues) {
            com.google.android.gms.common.internal.zzb.zzv((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            Set set = contentValues.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public DataHolder zzbR(int n) {
            return new DataHolder(this, n, null);
        }
    }
}

