/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T Ks;
    private Bundle Kt;
    private LinkedList<zza> Ku;
    private final zzf<T> Kv = new zzf<T>(){

        public void zza(T t) {
            zza.this.Ks = t;
            for (zza zza2 : zza.this.Ku) {
                zza2.zzb(zza.this.Ks);
            }
            zza.this.Ku.clear();
            zza.this.Kt = null;
        }
    };

    public T zzbbt() {
        return this.Ks;
    }

    private void zznd(int n) {
        while (!this.Ku.isEmpty() && this.Ku.getLast().getState() >= n) {
            this.Ku.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.Ks != null) {
            zza2.zzb((LifecycleDelegate)this.Ks);
            return;
        }
        if (this.Ku == null) {
            this.Ku = new LinkedList();
        }
        this.Ku.add(zza2);
        if (bundle != null) {
            if (this.Kt == null) {
                this.Kt = (Bundle)bundle.clone();
            } else {
                this.Kt.putAll(bundle);
            }
        }
        this.zza(this.Kv);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle bundle, final Bundle bundle2) {
        this.zza(bundle2, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.Ks.onInflate(activity, bundle, bundle2);
            }
        });
    }

    public void onCreate(final Bundle bundle) {
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.Ks.onCreate(bundle);
            }
        });
    }

    public View onCreateView(final LayoutInflater layoutInflater, final ViewGroup viewGroup, final Bundle bundle) {
        final FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.Ks.onCreateView(layoutInflater, viewGroup, bundle));
            }
        });
        if (this.Ks == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzh.zzc(context, n, GooglePlayServicesUtil.zzbv((Context)context));
        String string3 = zzh.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    context.startActivity(GooglePlayServicesUtil.zzfd(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.Ks.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.Ks.onResume();
            }
        });
    }

    public void onPause() {
        if (this.Ks != null) {
            this.Ks.onPause();
        } else {
            this.zznd(5);
        }
    }

    public void onStop() {
        if (this.Ks != null) {
            this.Ks.onStop();
        } else {
            this.zznd(4);
        }
    }

    public void onDestroyView() {
        if (this.Ks != null) {
            this.Ks.onDestroyView();
        } else {
            this.zznd(2);
        }
    }

    public void onDestroy() {
        if (this.Ks != null) {
            this.Ks.onDestroy();
        } else {
            this.zznd(1);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.Ks != null) {
            this.Ks.onSaveInstanceState(bundle);
        } else if (this.Kt != null) {
            bundle.putAll(this.Kt);
        }
    }

    public void onLowMemory() {
        if (this.Ks != null) {
            this.Ks.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

