/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzqx;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zzpo<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> sS = new ThreadLocal<Boolean>(){

        protected Boolean zzaoy() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzaoy();
        }
    };
    private final Object sT = new Object();
    protected final zza<R> sU;
    protected final WeakReference<GoogleApiClient> sV;
    private final CountDownLatch zzale = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> sW = new ArrayList();
    private ResultCallback<? super R> sX;
    private R sm;
    private zzb sY;
    private volatile boolean sZ;
    private boolean zzak;
    private boolean ta;
    private zzr tb;
    private volatile zzqx<R> tc;
    private boolean td = false;

    @Deprecated
    zzpo() {
        this.sU = new zza(Looper.getMainLooper());
        this.sV = new WeakReference<Object>(null);
    }

    protected zzpo(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.sU = new zza(looper);
        this.sV = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzpo(Looper looper) {
        this.sU = new zza(looper);
        this.sV = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzale.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzab.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzab.zza((this.tc == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzale.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzaa(Status.sr);
        }
        zzab.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzab.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzab.zza((this.tc == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzale.await(l, timeUnit);
            if (!bl) {
                this.zzaa(Status.st);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzaa(Status.sr);
        }
        zzab.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.sT;
        synchronized (object) {
            if (resultCallback == null) {
                this.sX = null;
                return;
            }
            zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzab.zza((this.tc == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.sU.zza(resultCallback, (R)this.get());
            } else {
                this.sX = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.sT;
        synchronized (object) {
            if (resultCallback == null) {
                this.sX = null;
                return;
            }
            zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzab.zza((this.tc == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.sU.zza(resultCallback, (R)this.get());
            } else {
                this.sX = resultCallback;
                this.sU.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzab.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.sT;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzv(this.sm.getStatus());
            } else {
                this.sW.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.sT;
        synchronized (object) {
            if (this.zzak || this.sZ) {
                return;
            }
            if (this.tb != null) {
                try {
                    this.tb.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzpo.zze(this.sm);
            this.zzak = true;
            this.zzd(this.zzc(Status.su));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzaov() {
        Object object = this.sT;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.sV.get();
            if (googleApiClient == null || !this.td) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.sT;
        synchronized (object) {
            return this.zzak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.sT;
        synchronized (object) {
            zzab.zza((this.tc == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzab.zza((this.sX == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            this.td = true;
            this.tc = new zzqx(this.sV);
            TransformedResult<? extends S> transformedResult = this.tc.then(resultTransform);
            if (this.isReady()) {
                this.sU.zza(this.tc, this.get());
            } else {
                this.sX = this.tc;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(R r) {
        Object object = this.sT;
        synchronized (object) {
            if (this.ta || this.zzak || this.isReady() && this.zzaox()) {
                zzpo.zze(r);
                return;
            }
            zzab.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzd(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzaa(Status status) {
        Object object = this.sT;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzc(this.zzc(status));
                this.ta = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    protected void zzaos() {
    }

    @Override
    public Integer zzaoj() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzr zzr2) {
        Object object = this.sT;
        synchronized (object) {
            this.tb = zzr2;
        }
    }

    public void zzaow() {
        this.td = this.td || sS.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.sT;
        synchronized (object) {
            zzab.zza((!this.sZ ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzab.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.sm;
            this.sm = null;
            this.sX = null;
            this.sZ = true;
        }
        this.zzaos();
        return r;
    }

    boolean zzaox() {
        return false;
    }

    private void zzd(R r) {
        this.sm = r;
        this.tb = null;
        this.zzale.countDown();
        Status status = this.sm.getStatus();
        if (this.zzak) {
            this.sX = null;
        } else if (this.sX == null) {
            if (this.sm instanceof Releasable) {
                this.sY = new zzb();
            }
        } else {
            this.sU.zzaoz();
            this.sU.zza(this.sX, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.sW) {
            zza2.zzv(status);
        }
        this.sW.clear();
    }

    public static void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zzpo.zze(zzpo.this.sm);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzpo<R> zzpo2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzpo2), l);
        }

        public void zzaoz() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzpo zzpo2 = (zzpo)message.obj;
                    zzpo2.zzaa(Status.st);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzpo.zze(r);
                throw runtimeException;
            }
        }
    }
}

